/* This file is part of the OWL API.
 * The contents of this file are subject to the LGPL License, Version 3.0.
 * Copyright 2011, Ulm University
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0 in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License. */
/* Generated By:JavaCC: Do not edit this line. KRSS2Parser.java */
package org.semanticweb.owlapi.krss2.parser;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.krss1.parser.NameResolverStrategy;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

@SuppressWarnings("all")
class KRSS2Parser implements KRSS2ParserConstants {

    private OWLOntology ontology;
    private OWLDataFactory dataFactory;
    private Map<String, IRI> string2IRI;
    private String base;
    private NameResolverStrategy nameResolution;
    // all fields for the adaptive strategy
    private int adaptiveMaxRuns = 10;
    private boolean alwaysIRIs = false;
    private boolean alwaysNames = false;

    void setOntology(OWLOntology ontology, OWLDataFactory dataFactory) {
        this.ontology = ontology;
        this.dataFactory = dataFactory;
        string2IRI = new HashMap<String, IRI>();
        OWLOntologyID id = ontology.getOntologyID();
        if (!id.isAnonymous()) {
            base = id.getOntologyIRI().get().toString() + "#";
        } else {
            base = id.toString() + "#";
        }
        nameResolution = NameResolverStrategy.CHECK;
    }

    protected void addAxiom(OWLAxiom ax) {
        try {
            ((OWLMutableOntology) ontology).applyChange(new AddAxiom(ontology,
                    ax));
        } catch (OWLOntologyChangeException e) {
            throw new KRSS2OWLParserException(e);
        }
    }

    IRI getIRI(String s) throws URISyntaxException {
        IRI iri = string2IRI.get(s);
        if (iri == null) {
            switch (nameResolution) {
                case IRI: {
                    iri = IRI.create(s);
                    break;
                }
                case NAME: {
                    iri = IRI.create(base + s);
                    break;
                }
                case ADAPTIVE: {
                    if (adaptiveMaxRuns <= 1) {
                        if (alwaysIRIs && !alwaysNames) {
                            nameResolution = NameResolverStrategy.IRI;
                        } else if (alwaysNames && !alwaysIRIs) {
                            nameResolution = NameResolverStrategy.NAME;
                        } else {
                            nameResolution = NameResolverStrategy.CHECK;
                        }
                    }
                    adaptiveMaxRuns--;
                }
                //$FALL-THROUGH$
                case CHECK: {
                    String ns = XMLUtils.getNCNamePrefix(s);
                    if (ns.equals("")) {
                        iri = IRI.create(base + s);
                    } else {
                        iri = IRI.create(s);
                    }
                    break;
                }
                default:
                    break;
            }
            string2IRI.put(s, iri);
        }
        return iri;
    }

    void setNameResolution(NameResolverStrategy nameResolution) {
        this.nameResolution = nameResolution;
    }

    void parse() {
        label_1: while (true) {
            if (jj_2_1(2)) {} else {
                break label_1;
            }
            TBoxStatement();
        }
        if (jj_2_2(2)) {
            jj_consume_token(ENDTBOX);
        } else {}
        label_2: while (true) {
            if (jj_2_3(2)) {} else {
                break label_2;
            }
            ABoxStatement();
        }
        if (jj_2_4(2)) {
            jj_consume_token(ENDABOX);
        } else {}
        jj_consume_token(0);
    }

    private void TBoxStatement() {
        if (jj_2_5(2)) {
            DefinePrimitiveConcept();
        } else if (jj_2_6(2)) {
            DefineConcept();
        } else if (jj_2_7(2)) {
            Implies();
        } else if (jj_2_8(2)) {
            Equivalent();
        } else if (jj_2_9(2)) {
            Disjoint();
        } else if (jj_2_10(2)) {
            ComplexRoleInclusion();
        } else if (jj_2_11(2)) {
            DefinePrimitiveRole();
        } else if (jj_2_12(2)) {
            DefineRole();
        } else if (jj_2_13(2)) {
            DisjointRoles();
        } else if (jj_2_14(2)) {
            RolesEquivalent();
        } else if (jj_2_15(2)) {
            ImpliesRole();
        } else if (jj_2_16(2)) {
            Inverses();
        } else if (jj_2_17(2)) {
            Range();
        } else if (jj_2_18(2)) {
            Transitive();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // Concepts
    private void DefinePrimitiveConcept() {
        OWLClassExpression subClass = null;
        OWLClassExpression superClass = null;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINEPRIMITIVECONCEPT);
        subClass = ConceptName();
        if (jj_2_19(2)) {
            superClass = ConceptExpression();
        } else {}
        jj_consume_token(CLOSEPAR);
        if (superClass == null) {
            addAxiom(dataFactory.getOWLSubClassOfAxiom(subClass,
                    dataFactory.getOWLThing()));
        } else {
            addAxiom(dataFactory.getOWLSubClassOfAxiom(subClass, superClass));
        }
    }

    private void DefineConcept() {
        OWLClassExpression clsA;
        OWLClassExpression clsB;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINECONCEPT);
        clsA = ConceptName();
        clsB = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        if (clsB == null) {
            clsB = dataFactory.getOWLThing();
        }
        addAxiom(dataFactory.getOWLEquivalentClassesAxiom(clsA, clsB));
    }

    private void Disjoint() {
        OWLClassExpression desc1;
        OWLClassExpression desc2;
        jj_consume_token(OPENPAR);
        jj_consume_token(DISJOINT);
        desc1 = ConceptExpression();
        desc2 = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLDisjointClassesAxiom(desc1, desc2));
    }

    private void Equivalent() {
        OWLClassExpression desc1;
        OWLClassExpression desc2;
        jj_consume_token(OPENPAR);
        jj_consume_token(EQUIVALENT);
        desc1 = ConceptExpression();
        desc2 = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLEquivalentClassesAxiom(desc1, desc2));
    }

    private void Implies() {
        OWLClassExpression subDescription;
        OWLClassExpression superDescription;
        jj_consume_token(OPENPAR);
        jj_consume_token(IMPLIES);
        subDescription = ConceptExpression();
        superDescription = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLSubClassOfAxiom(subDescription,
                superDescription));
    }

    // Roles
    private void DefineRole() {
        OWLObjectPropertyExpression propA;
        OWLObjectPropertyExpression propB;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINEROLE);
        propA = RoleExpression();
        propB = RoleExpression();
        jj_consume_token(CLOSEPAR);
        Set<OWLObjectPropertyExpression> ops = new HashSet<OWLObjectPropertyExpression>();
        ops.add(propA);
        ops.add(propB);
        addAxiom(dataFactory.getOWLEquivalentObjectPropertiesAxiom(ops));
    }

    private void DefinePrimitiveRole() {
        OWLObjectProperty subProp;
        OWLObjectProperty superProp;
        OWLClassExpression desc;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINEPRIMITIVEROLE);
        subProp = RoleName();
        if (subProp != null) {
            addAxiom(dataFactory.getOWLDeclarationAxiom(subProp));
        }
        Parent(subProp);
        RightIdentity(subProp);
        Parents(subProp);
        DomainAttribute(subProp);
        RangeAttribute(subProp);
        TransitiveAttribute(subProp);
        SymmetricAttribute(subProp);
        ReflexiveAttribute(subProp);
        InverseProperty(subProp);
        jj_consume_token(CLOSEPAR);
    }

    private void RightIdentity(OWLObjectProperty r) {
        OWLObjectProperty s;
        if (jj_2_20(2)) {
            jj_consume_token(RIGHT_IDENTITY_ATTRIBUTE);
            s = RoleName();
            List<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>(
                    2);
            chain.add(r);
            chain.add(s);
            addAxiom(dataFactory.getOWLSubPropertyChainOfAxiom(chain, r));
        }
    }

    private void LeftIdentity(OWLObjectProperty r) {
        OWLObjectProperty s;
        if (jj_2_21(2)) {
            jj_consume_token(LEFT_IDENTITY_ATTRIBUTE);
            s = RoleName();
            List<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>(
                    2);
            chain.add(s);
            chain.add(r);
            addAxiom(dataFactory.getOWLSubPropertyChainOfAxiom(chain, r));
        }
    }

    private void InverseProperty(OWLObjectProperty subProp) {
        OWLObjectPropertyExpression superProp;
        if (jj_2_22(2)) {
            jj_consume_token(INVERSE_ATTRIBUTE);
            superProp = RoleExpression();
            addAxiom(dataFactory.getOWLInverseObjectPropertiesAxiom(subProp,
                    superProp));
        } else {}
    }

    private void DomainAttribute(OWLObjectProperty subProp) {
        OWLClassExpression desc;
        Set<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        if (jj_2_26(2)) {
            jj_consume_token(DOMAIN_ATTRIBUTE);
            if (jj_2_24(2)) {
                jj_consume_token(OPENPAR);
                label_3: while (true) {
                    desc = ConceptExpression();
                    if (desc != null) {
                        descs.add(desc);
                    }
                    if (jj_2_23(2)) {} else {
                        break label_3;
                    }
                }
                jj_consume_token(CLOSEPAR);
            } else if (jj_2_25(2)) {
                desc = ConceptExpression();
                descs.add(desc);
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
            for (OWLClassExpression eachDescription : descs) {
                addAxiom(dataFactory.getOWLObjectPropertyDomainAxiom(subProp,
                        eachDescription));
            }
        } else {}
    }

    private void RangeAttribute(OWLObjectProperty subProp) {
        OWLClassExpression desc;
        Set<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        if (jj_2_30(2)) {
            jj_consume_token(RANGE_ATTRIBUTE);
            if (jj_2_28(2)) {
                jj_consume_token(OPENPAR);
                label_4: while (true) {
                    desc = ConceptExpression();
                    if (desc != null) {
                        descs.add(desc);
                    }
                    if (jj_2_27(2)) {} else {
                        break label_4;
                    }
                }
                jj_consume_token(CLOSEPAR);
            } else if (jj_2_29(2)) {
                desc = ConceptExpression();
                descs.add(desc);
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
            for (OWLClassExpression eachDescription : descs) {
                addAxiom(dataFactory.getOWLObjectPropertyRangeAxiom(subProp,
                        eachDescription));
            }
        } else {}
    }

    private void TransitiveAttribute(OWLObjectProperty property) {
        if (jj_2_33(2)) {
            jj_consume_token(TRANSITIVE_ATTRIBUTE);
            if (jj_2_31(2)) {
                jj_consume_token(NIL);
            } else if (jj_2_32(2)) {
                jj_consume_token(TRUE);
                addAxiom(dataFactory
                        .getOWLTransitiveObjectPropertyAxiom(property));
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
        } else {}
    }

    private void SymmetricAttribute(OWLObjectProperty property) {
        if (jj_2_36(2)) {
            jj_consume_token(SYMMETRIC_ATTRIBUTE);
            if (jj_2_34(2)) {
                jj_consume_token(NIL);
            } else if (jj_2_35(2)) {
                jj_consume_token(TRUE);
                addAxiom(dataFactory
                        .getOWLSymmetricObjectPropertyAxiom(property));
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
        } else {}
    }

    private void ReflexiveAttribute(OWLObjectProperty property) {
        if (jj_2_39(2)) {
            jj_consume_token(REFLEXIVE_ATTRIBUTE);
            if (jj_2_37(2)) {
                jj_consume_token(NIL);
            } else if (jj_2_38(2)) {
                jj_consume_token(TRUE);
                addAxiom(dataFactory
                        .getOWLReflexiveObjectPropertyAxiom(property));
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
        } else {}
    }

    private void Parents(OWLObjectProperty subProp) {
        Set<OWLObjectProperty> roles;
        OWLObjectProperty superProp;
        if (jj_2_46(2)) {
            if (jj_2_44(2)) {
                jj_consume_token(PARENTS);
                if (jj_2_40(2)) {
                    jj_consume_token(NIL);
                } else if (jj_2_41(2)) {
                    jj_consume_token(OPENPAR);
                    roles = RoleNameSet();
                    jj_consume_token(CLOSEPAR);
                    if (roles != null) {
                        for (OWLObjectProperty prop : roles) {
                            addAxiom(dataFactory
                                    .getOWLSubObjectPropertyOfAxiom(subProp,
                                            prop));
                        }
                    }
                } else {
                    jj_consume_token(-1);
                    throw new ParseException();
                }
            } else if (jj_2_45(2)) {
                jj_consume_token(PARENT);
                if (jj_2_42(2)) {
                    jj_consume_token(NIL);
                } else if (jj_2_43(2)) {
                    superProp = RoleName();
                    addAxiom(dataFactory.getOWLSubObjectPropertyOfAxiom(
                            subProp, superProp));
                } else {
                    jj_consume_token(-1);
                    throw new ParseException();
                }
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
        } else {}
    }

    private void Parent(OWLObjectProperty subProp) {
        OWLObjectProperty superProp;
        if (jj_2_47(2)) {
            superProp = RoleName();
            addAxiom(dataFactory.getOWLSubObjectPropertyOfAxiom(subProp,
                    superProp));
        } else {}
    }

    private void DisjointRoles() {
        OWLObjectPropertyExpression exp1;
        OWLObjectPropertyExpression exp2;
        jj_consume_token(OPENPAR);
        jj_consume_token(DISJOINTROLES);
        exp1 = RoleExpression();
        exp2 = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLDisjointObjectPropertiesAxiom(exp1, exp2));
    }

    private void ImpliesRole() {
        OWLObjectPropertyExpression subProp;
        OWLObjectPropertyExpression superProp;
        jj_consume_token(OPENPAR);
        jj_consume_token(IMPLIESROLE);
        subProp = RoleExpression();
        superProp = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLSubObjectPropertyOfAxiom(subProp, superProp));
    }

    private void Inverses() {
        OWLObjectPropertyExpression prop1;
        OWLObjectPropertyExpression prop2;
        jj_consume_token(OPENPAR);
        jj_consume_token(INVERSE);
        prop1 = RoleExpression();
        prop2 = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLInverseObjectPropertiesAxiom(prop1, prop2));
    }

    private void RolesEquivalent() {
        OWLObjectPropertyExpression exp1;
        OWLObjectPropertyExpression exp2;
        jj_consume_token(OPENPAR);
        jj_consume_token(ROLESEQUIVALENT);
        exp1 = RoleExpression();
        exp2 = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLEquivalentObjectPropertiesAxiom(exp1, exp2));
    }

    private void ComplexRoleInclusion() {
        OWLObjectProperty superProp;
        List<OWLObjectPropertyExpression> chain;
        jj_consume_token(OPENPAR);
        jj_consume_token(ROLE_INCLUSION);
        chain = propertyChain();
        superProp = RoleName();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLSubPropertyChainOfAxiom(chain, superProp));
    }

    private List<OWLObjectPropertyExpression> propertyChain() {
        List<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
        List<OWLObjectPropertyExpression> subChain;
        OWLObjectPropertyExpression prop;
        jj_consume_token(OPENPAR);
        jj_consume_token(COMPOSE);
        prop = RoleExpression();
        chain.add(prop);
        if (jj_2_48(2)) {
            subChain = propertyChain();
            chain.addAll(subChain);
        } else if (jj_2_49(2)) {
            prop = RoleExpression();
            chain.add(prop);
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        jj_consume_token(CLOSEPAR);
        return chain;
    }

    private void Transitive() {
        OWLObjectProperty prop;
        jj_consume_token(OPENPAR);
        jj_consume_token(TRANSITIVE);
        prop = RoleName();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLTransitiveObjectPropertyAxiom(prop));
    }

    private void Range() {
        OWLObjectProperty prop;
        OWLClassExpression rng;
        jj_consume_token(OPENPAR);
        jj_consume_token(RANGE);
        prop = RoleName();
        rng = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLObjectPropertyRangeAxiom(prop, rng));
    }

    private OWLClassExpression ConceptExpression() {
        OWLClassExpression desc;
        if (jj_2_50(2)) {
            desc = ConceptName();
        } else if (jj_2_51(2)) {
            desc = And();
        } else if (jj_2_52(2)) {
            desc = Or();
        } else if (jj_2_53(2)) {
            desc = Not();
        } else if (jj_2_54(2)) {
            desc = All();
        } else if (jj_2_55(2)) {
            desc = Some();
        } else if (jj_2_56(2)) {
            desc = AtLeast();
        } else if (jj_2_57(2)) {
            desc = AtMost();
        } else if (jj_2_58(2)) {
            desc = Exactly();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    private OWLClassExpression ConceptName() {
        IRI IRI;
        IRI = Name();
        return dataFactory.getOWLClass(IRI);
    }

    private Set<OWLClassExpression> ConceptSet() {
        Set<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        OWLClassExpression desc;
        label_5: while (true) {
            desc = ConceptExpression();
            descs.add(desc);
            if (jj_2_59(2)) {} else {
                break label_5;
            }
        }
        return descs;
    }

    private OWLClassExpression And() {
        Set<OWLClassExpression> operands;
        jj_consume_token(OPENPAR);
        jj_consume_token(AND);
        operands = ConceptSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectIntersectionOf(operands);
    }

    private OWLClassExpression Or() {
        Set<OWLClassExpression> operands;
        jj_consume_token(OPENPAR);
        jj_consume_token(OR);
        operands = ConceptSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectUnionOf(operands);
    }

    private OWLClassExpression Not() {
        OWLClassExpression operand;
        jj_consume_token(OPENPAR);
        jj_consume_token(NOT);
        operand = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectComplementOf(operand);
    }

    private OWLClassExpression All() {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler;
        jj_consume_token(OPENPAR);
        jj_consume_token(ALL);
        prop = RoleExpression();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectAllValuesFrom(prop, filler);
    }

    private OWLClassExpression Some() {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler;
        jj_consume_token(OPENPAR);
        jj_consume_token(SOME);
        prop = RoleExpression();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
    }

    private OWLClassExpression AtLeast() {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler = null;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(ATLEAST);
        card = Integer();
        prop = RoleExpression();
        if (jj_2_60(2)) {
            filler = ConceptExpression();
        } else {}
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return dataFactory.getOWLObjectMinCardinality(card, prop);
        }
        return dataFactory.getOWLObjectMinCardinality(card, prop, filler);
    }

    private OWLClassExpression AtMost() {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler = null;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(ATMOST);
        card = Integer();
        prop = RoleExpression();
        if (jj_2_61(2)) {
            filler = ConceptExpression();
        } else {}
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return dataFactory.getOWLObjectMaxCardinality(card, prop);
        }
        return dataFactory.getOWLObjectMaxCardinality(card, prop, filler);
    }

    private OWLClassExpression Exactly() {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler = null;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(EXACTLY);
        card = Integer();
        prop = RoleExpression();
        if (jj_2_62(2)) {
            filler = ConceptExpression();
        } else {}
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return dataFactory.getOWLObjectExactCardinality(card, prop);
        }
        return dataFactory.getOWLObjectExactCardinality(card, prop, filler);
    }

    private OWLObjectProperty RoleName() {
        IRI IRI;
        IRI = Name();
        if (IRI == null) {
            return null;
        }
        return dataFactory.getOWLObjectProperty(IRI);
    }

    private Set<OWLObjectProperty> RoleNameSet() {
        Set<OWLObjectProperty> roles = new HashSet<OWLObjectProperty>();
        OWLObjectProperty role;
        label_6: while (true) {
            role = RoleName();
            roles.add(role);
            if (jj_2_63(2)) {} else {
                break label_6;
            }
        }
        return roles;
    }

    private OWLObjectPropertyExpression RoleExpression() {
        OWLObjectPropertyExpression exp;
        if (jj_2_64(2)) {
            jj_consume_token(OPENPAR);
            jj_consume_token(INV);
            exp = RoleExpression();
            jj_consume_token(CLOSEPAR);
            return dataFactory.getOWLObjectInverseOf(exp);
        } else if (jj_2_65(2)) {
            exp = RoleName();
            return exp;
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private void ABoxStatement() {
        if (jj_2_66(2)) {
            Instance();
        } else if (jj_2_67(2)) {
            Related();
        } else if (jj_2_68(2)) {
            Equal();
        } else if (jj_2_69(2)) {
            Distinct();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private void Instance() {
        OWLIndividual ind;
        OWLClassExpression type;
        jj_consume_token(OPENPAR);
        jj_consume_token(INSTANCE);
        ind = IndividualName();
        type = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory.getOWLClassAssertionAxiom(type, ind));
    }

    private void Related() {
        OWLIndividual subj;
        OWLObjectProperty prop;
        OWLIndividual obj;
        jj_consume_token(OPENPAR);
        jj_consume_token(RELATED);
        subj = IndividualName();
        prop = RoleName();
        obj = IndividualName();
        jj_consume_token(CLOSEPAR);
        addAxiom(dataFactory
                .getOWLObjectPropertyAssertionAxiom(prop, subj, obj));
    }

    private void Equal() {
        OWLIndividual indA, indB;
        Set<OWLIndividual> inds = new HashSet<OWLIndividual>();
        jj_consume_token(OPENPAR);
        jj_consume_token(EQUAL);
        indA = IndividualName();
        indB = IndividualName();
        jj_consume_token(CLOSEPAR);
        inds.add(indA);
        inds.add(indB);
        addAxiom(dataFactory.getOWLSameIndividualAxiom(inds));
    }

    private void Distinct() {
        OWLIndividual indA, indB;
        Set<OWLIndividual> inds = new HashSet<OWLIndividual>();
        jj_consume_token(OPENPAR);
        jj_consume_token(DISTINCT);
        indA = IndividualName();
        indB = IndividualName();
        jj_consume_token(CLOSEPAR);
        inds.add(indA);
        inds.add(indB);
        addAxiom(dataFactory.getOWLDifferentIndividualsAxiom(inds));
    }

    private OWLIndividual IndividualName() {
        IRI name;
        name = Name();
        return dataFactory.getOWLNamedIndividual(name);
    }

    private int Integer() {
        Token t;
        t = jj_consume_token(INT);
        return Integer.parseInt(t.image);
    }

    private boolean parseBoolean() {
        if (jj_2_70(2)) {
            jj_consume_token(TRUE);
            return true;
        } else if (jj_2_71(2)) {
            jj_consume_token(NIL);
            return false;
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private IRI Name() {
        Token t;
        if (jj_2_76(2)) {
            if (jj_2_72(2)) {
                t = jj_consume_token(NAME);
            } else if (jj_2_73(2)) {
                t = jj_consume_token(INT);
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
            try {
                return getIRI(t.image);
            } catch (URISyntaxException e) {
                return null;
            }
        } else if (jj_2_77(2)) {
            if (jj_2_74(2)) {
                t = jj_consume_token(TOP);
                return OWLRDFVocabulary.OWL_THING.getIRI();
            } else if (jj_2_75(2)) {
                t = jj_consume_token(BOTTOM);
                return OWLRDFVocabulary.OWL_NOTHING.getIRI();
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_1();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(0, xla);
        }
    }

    private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_2();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(1, xla);
        }
    }

    private boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_3();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(2, xla);
        }
    }

    private boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_4();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(3, xla);
        }
    }

    private boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_5();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(4, xla);
        }
    }

    private boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_6();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(5, xla);
        }
    }

    private boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_7();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(6, xla);
        }
    }

    private boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_8();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(7, xla);
        }
    }

    private boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_9();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(8, xla);
        }
    }

    private boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_10();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(9, xla);
        }
    }

    private boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_11();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(10, xla);
        }
    }

    private boolean jj_2_12(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_12();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(11, xla);
        }
    }

    private boolean jj_2_13(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_13();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(12, xla);
        }
    }

    private boolean jj_2_14(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_14();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(13, xla);
        }
    }

    private boolean jj_2_15(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_15();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(14, xla);
        }
    }

    private boolean jj_2_16(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_16();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(15, xla);
        }
    }

    private boolean jj_2_17(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_17();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(16, xla);
        }
    }

    private boolean jj_2_18(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_18();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(17, xla);
        }
    }

    private boolean jj_2_19(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_19();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(18, xla);
        }
    }

    private boolean jj_2_20(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_20();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(19, xla);
        }
    }

    private boolean jj_2_21(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_21();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(20, xla);
        }
    }

    private boolean jj_2_22(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_22();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(21, xla);
        }
    }

    private boolean jj_2_23(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_23();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(22, xla);
        }
    }

    private boolean jj_2_24(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_24();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(23, xla);
        }
    }

    private boolean jj_2_25(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_25();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(24, xla);
        }
    }

    private boolean jj_2_26(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_26();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(25, xla);
        }
    }

    private boolean jj_2_27(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_27();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(26, xla);
        }
    }

    private boolean jj_2_28(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_28();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(27, xla);
        }
    }

    private boolean jj_2_29(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_29();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(28, xla);
        }
    }

    private boolean jj_2_30(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_30();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(29, xla);
        }
    }

    private boolean jj_2_31(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_31();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(30, xla);
        }
    }

    private boolean jj_2_32(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_32();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(31, xla);
        }
    }

    private boolean jj_2_33(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_33();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(32, xla);
        }
    }

    private boolean jj_2_34(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_34();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(33, xla);
        }
    }

    private boolean jj_2_35(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_35();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(34, xla);
        }
    }

    private boolean jj_2_36(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_36();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(35, xla);
        }
    }

    private boolean jj_2_37(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_37();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(36, xla);
        }
    }

    private boolean jj_2_38(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_38();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(37, xla);
        }
    }

    private boolean jj_2_39(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_39();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(38, xla);
        }
    }

    private boolean jj_2_40(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_40();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(39, xla);
        }
    }

    private boolean jj_2_41(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_41();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(40, xla);
        }
    }

    private boolean jj_2_42(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_42();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(41, xla);
        }
    }

    private boolean jj_2_43(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_43();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(42, xla);
        }
    }

    private boolean jj_2_44(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_44();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(43, xla);
        }
    }

    private boolean jj_2_45(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_45();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(44, xla);
        }
    }

    private boolean jj_2_46(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_46();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(45, xla);
        }
    }

    private boolean jj_2_47(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_47();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(46, xla);
        }
    }

    private boolean jj_2_48(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_48();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(47, xla);
        }
    }

    private boolean jj_2_49(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_49();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(48, xla);
        }
    }

    private boolean jj_2_50(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_50();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(49, xla);
        }
    }

    private boolean jj_2_51(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_51();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(50, xla);
        }
    }

    private boolean jj_2_52(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_52();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(51, xla);
        }
    }

    private boolean jj_2_53(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_53();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(52, xla);
        }
    }

    private boolean jj_2_54(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_54();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(53, xla);
        }
    }

    private boolean jj_2_55(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_55();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(54, xla);
        }
    }

    private boolean jj_2_56(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_56();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(55, xla);
        }
    }

    private boolean jj_2_57(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_57();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(56, xla);
        }
    }

    private boolean jj_2_58(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_58();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(57, xla);
        }
    }

    private boolean jj_2_59(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_59();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(58, xla);
        }
    }

    private boolean jj_2_60(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_60();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(59, xla);
        }
    }

    private boolean jj_2_61(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_61();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(60, xla);
        }
    }

    private boolean jj_2_62(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_62();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(61, xla);
        }
    }

    private boolean jj_2_63(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_63();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(62, xla);
        }
    }

    private boolean jj_2_64(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_64();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(63, xla);
        }
    }

    private boolean jj_2_65(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_65();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(64, xla);
        }
    }

    private boolean jj_2_66(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_66();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(65, xla);
        }
    }

    private boolean jj_2_67(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_67();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(66, xla);
        }
    }

    private boolean jj_2_68(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_68();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(67, xla);
        }
    }

    private boolean jj_2_69(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_69();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(68, xla);
        }
    }

    private boolean jj_2_70(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_70();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(69, xla);
        }
    }

    private boolean jj_2_71(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_71();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(70, xla);
        }
    }

    private boolean jj_2_72(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_72();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(71, xla);
        }
    }

    private boolean jj_2_73(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_73();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(72, xla);
        }
    }

    private boolean jj_2_74(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_74();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(73, xla);
        }
    }

    private boolean jj_2_75(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_75();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(74, xla);
        }
    }

    private boolean jj_2_76(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_76();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(75, xla);
        }
    }

    private boolean jj_2_77(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_77();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(76, xla);
        }
    }

    private boolean jj_3_19() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_9() {
        if (jj_3R_13()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_36() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(EXACTLY)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_13() {
        if (jj_3R_17()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_19() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(IMPLIESROLE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_25() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_43() {
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_11() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(IMPLIES)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_42() {
        if (jj_scan_token(NIL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_57() {
        if (jj_3R_35()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_8() {
        if (jj_3R_12()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_35() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ATMOST)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_17() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DISJOINTROLES)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_12() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(EQUIVALENT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_12() {
        if (jj_3R_16()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_45() {
        if (jj_scan_token(PARENT)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_42()) {
            jj_scanpos = xsp;
            if (jj_3_43()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        if (jj_3R_11()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_4() {
        if (jj_scan_token(ENDABOX)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_47() {
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_13() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DISJOINT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_56() {
        if (jj_3R_34()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_34() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ATLEAST)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_18() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_38() {
        if (jj_scan_token(TRUE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_41() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_3R_26()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_49() {
        if (jj_3R_25()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_75() {
        if (jj_scan_token(BOTTOM)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_73() {
        if (jj_scan_token(INT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_71() {
        if (jj_scan_token(NIL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_17() {
        if (jj_3R_21()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_74() {
        if (jj_scan_token(TOP)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_33() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(SOME)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_10() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINECONCEPT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_77() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_74()) {
            jj_scanpos = xsp;
            if (jj_3_75()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_37() {
        if (jj_scan_token(NIL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_40() {
        if (jj_scan_token(NIL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_55() {
        if (jj_3R_33()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_6() {
        if (jj_3R_10()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_11() {
        if (jj_3R_15()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_35() {
        if (jj_scan_token(TRUE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_3() {
        if (jj_3R_8()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_72() {
        if (jj_scan_token(NAME)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_76() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_72()) {
            jj_scanpos = xsp;
            if (jj_3_73()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_41() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_76()) {
            jj_scanpos = xsp;
            if (jj_3_77()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_34() {
        if (jj_scan_token(NIL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_44() {
        if (jj_scan_token(PARENTS)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_40()) {
            jj_scanpos = xsp;
            if (jj_3_41()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_46() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_44()) {
            jj_scanpos = xsp;
            if (jj_3_45()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_32() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ALL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_16() {
        if (jj_3R_20()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_32() {
        if (jj_scan_token(TRUE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_9() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINEPRIMITIVECONCEPT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_54() {
        if (jj_3R_32()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_31() {
        if (jj_scan_token(NIL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_2() {
        if (jj_scan_token(ENDTBOX)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_70() {
        if (jj_scan_token(TRUE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_31() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(NOT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_39() {
        if (jj_scan_token(REFLEXIVE_ATTRIBUTE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_37()) {
            jj_scanpos = xsp;
            if (jj_3_38()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_27() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_15() {
        if (jj_3R_19()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_53() {
        if (jj_3R_31()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_10() {
        if (jj_3R_14()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_5() {
        if (jj_3R_9()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_7() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_5()) {
            jj_scanpos = xsp;
            if (jj_3_6()) {
                jj_scanpos = xsp;
                if (jj_3_7()) {
                    jj_scanpos = xsp;
                    if (jj_3_8()) {
                        jj_scanpos = xsp;
                        if (jj_3_9()) {
                            jj_scanpos = xsp;
                            if (jj_3_10()) {
                                jj_scanpos = xsp;
                                if (jj_3_11()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_12()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_13()) {
                                            jj_scanpos = xsp;
                                            if (jj_3_14()) {
                                                jj_scanpos = xsp;
                                                if (jj_3_15()) {
                                                    jj_scanpos = xsp;
                                                    if (jj_3_16()) {
                                                        jj_scanpos = xsp;
                                                        if (jj_3_17()) {
                                                            jj_scanpos = xsp;
                                                            if (jj_3_18()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_36() {
        if (jj_scan_token(SYMMETRIC_ATTRIBUTE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_34()) {
            jj_scanpos = xsp;
            if (jj_3_35()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_30() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(OR)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_28() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        Token xsp;
        if (jj_3_27()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_27()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        if (jj_3R_7()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_23() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_52() {
        if (jj_3R_30()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_33() {
        if (jj_scan_token(TRANSITIVE_ATTRIBUTE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_31()) {
            jj_scanpos = xsp;
            if (jj_3_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_29() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(AND)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_24() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        Token xsp;
        if (jj_3_23()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_23()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3_48() {
        if (jj_3R_27()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_59() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_30() {
        if (jj_scan_token(RANGE_ATTRIBUTE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_28()) {
            jj_scanpos = xsp;
            if (jj_3_29()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_51() {
        if (jj_3R_29()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_40() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DISTINCT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_28() {
        if (jj_3R_41()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_69() {
        if (jj_3R_40()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_39() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(EQUAL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_26() {
        if (jj_scan_token(DOMAIN_ATTRIBUTE)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_24()) {
            jj_scanpos = xsp;
            if (jj_3_25()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_50() {
        if (jj_3R_28()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_23() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_50()) {
            jj_scanpos = xsp;
            if (jj_3_51()) {
                jj_scanpos = xsp;
                if (jj_3_52()) {
                    jj_scanpos = xsp;
                    if (jj_3_53()) {
                        jj_scanpos = xsp;
                        if (jj_3_54()) {
                            jj_scanpos = xsp;
                            if (jj_3_55()) {
                                jj_scanpos = xsp;
                                if (jj_3_56()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_57()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_58()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_68() {
        if (jj_3R_39()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_38() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(RELATED)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_22() {
        if (jj_scan_token(INVERSE_ATTRIBUTE)) {
            return true;
        }
        if (jj_3R_25()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_21() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(RANGE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_67() {
        if (jj_3R_38()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_37() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(INSTANCE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_21() {
        if (jj_scan_token(LEFT_IDENTITY_ATTRIBUTE)) {
            return true;
        }
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_62() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_22() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(TRANSITIVE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_66() {
        if (jj_3R_37()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_8() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_66()) {
            jj_scanpos = xsp;
            if (jj_3_67()) {
                jj_scanpos = xsp;
                if (jj_3_68()) {
                    jj_scanpos = xsp;
                    if (jj_3_69()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_20() {
        if (jj_scan_token(RIGHT_IDENTITY_ATTRIBUTE)) {
            return true;
        }
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_27() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(COMPOSE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_61() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_65() {
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_64() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(INV)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_25() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_64()) {
            jj_scanpos = xsp;
            if (jj_3_65()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_14() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ROLE_INCLUSION)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_15() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINEPRIMITIVEROLE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_60() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_63() {
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_26() {
        Token xsp;
        if (jj_3_63()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_63()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_18() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ROLESEQUIVALENT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_14() {
        if (jj_3R_18()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_24() {
        if (jj_3R_41()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_16() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINEROLE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_29() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_20() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(INVERSE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_58() {
        if (jj_3R_36()) {
            return true;
        }
        return false;
    }

    private KRSS2ParserTokenManager token_source;
    private JavaCharStream jj_input_stream;
    private Token token;
    private Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos, jj_lastpos;
    private int jj_la;
    private int jj_gen;
    final private int[] jj_la1 = new int[0];
    static private int[] jj_la1_0;
    static private int[] jj_la1_1;
    static private int[] jj_la1_2;
    static {
        jj_la1_init_0();
        jj_la1_init_1();
        jj_la1_init_2();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[] {};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[] {};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[] {};
    }

    final private JJCalls[] jj_2_rtns = new JJCalls[77];
    private boolean jj_rescan = false;
    private int jj_gc = 0;

    KRSS2Parser(java.io.InputStream stream) {
        this(stream, null);
    }

    KRSS2Parser(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new OWLRuntimeException(e);
        }
        token_source = new KRSS2ParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(java.io.InputStream stream) {
        ReInit(stream, null);
    }

    void ReInit(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new OWLRuntimeException(e);
        }
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    KRSS2Parser(java.io.Reader stream) {
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new KRSS2ParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    KRSS2Parser(KRSS2ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(KRSS2ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) {
        Token oldToken;
        if ((oldToken = token).next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    static private final class LookaheadSuccess extends OWLRuntimeException {

        private static final long serialVersionUID = 40000L;

        public LookaheadSuccess() {}
    }

    final private LookaheadSuccess jj_ls = new LookaheadSuccess();

    private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source
                        .getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) {
                jj_add_error_token(kind, i);
            }
        }
        if (jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    Token getNextToken() {
        if (token.next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) {
                t = t.next;
            } else {
                t = t.next = token_source.getNextToken();
            }
        }
        return t;
    }

    private int jj_ntk() {
        if ((jj_nt = token.next) == null) {
            return jj_ntk = (token.next = token_source.getNextToken()).kind;
        } else {
            return jj_ntk = jj_nt.kind;
        }
    }

    private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries
                    .iterator(); it.hasNext();) {
                int[] oldentry = (int[]) it.next();
                if (oldentry.length == jj_expentry.length) {
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            continue jj_entries_loop;
                        }
                    }
                    jj_expentries.add(jj_expentry);
                    break jj_entries_loop;
                }
            }
            if (pos != 0) {
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
        }
    }

    ParseException generateParseException() {
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[70];
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 0; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 70; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = jj_expentries.get(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 77; i++) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen > jj_gen) {
                        jj_la = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                            case 0:
                                jj_3_1();
                                break;
                            case 1:
                                jj_3_2();
                                break;
                            case 2:
                                jj_3_3();
                                break;
                            case 3:
                                jj_3_4();
                                break;
                            case 4:
                                jj_3_5();
                                break;
                            case 5:
                                jj_3_6();
                                break;
                            case 6:
                                jj_3_7();
                                break;
                            case 7:
                                jj_3_8();
                                break;
                            case 8:
                                jj_3_9();
                                break;
                            case 9:
                                jj_3_10();
                                break;
                            case 10:
                                jj_3_11();
                                break;
                            case 11:
                                jj_3_12();
                                break;
                            case 12:
                                jj_3_13();
                                break;
                            case 13:
                                jj_3_14();
                                break;
                            case 14:
                                jj_3_15();
                                break;
                            case 15:
                                jj_3_16();
                                break;
                            case 16:
                                jj_3_17();
                                break;
                            case 17:
                                jj_3_18();
                                break;
                            case 18:
                                jj_3_19();
                                break;
                            case 19:
                                jj_3_20();
                                break;
                            case 20:
                                jj_3_21();
                                break;
                            case 21:
                                jj_3_22();
                                break;
                            case 22:
                                jj_3_23();
                                break;
                            case 23:
                                jj_3_24();
                                break;
                            case 24:
                                jj_3_25();
                                break;
                            case 25:
                                jj_3_26();
                                break;
                            case 26:
                                jj_3_27();
                                break;
                            case 27:
                                jj_3_28();
                                break;
                            case 28:
                                jj_3_29();
                                break;
                            case 29:
                                jj_3_30();
                                break;
                            case 30:
                                jj_3_31();
                                break;
                            case 31:
                                jj_3_32();
                                break;
                            case 32:
                                jj_3_33();
                                break;
                            case 33:
                                jj_3_34();
                                break;
                            case 34:
                                jj_3_35();
                                break;
                            case 35:
                                jj_3_36();
                                break;
                            case 36:
                                jj_3_37();
                                break;
                            case 37:
                                jj_3_38();
                                break;
                            case 38:
                                jj_3_39();
                                break;
                            case 39:
                                jj_3_40();
                                break;
                            case 40:
                                jj_3_41();
                                break;
                            case 41:
                                jj_3_42();
                                break;
                            case 42:
                                jj_3_43();
                                break;
                            case 43:
                                jj_3_44();
                                break;
                            case 44:
                                jj_3_45();
                                break;
                            case 45:
                                jj_3_46();
                                break;
                            case 46:
                                jj_3_47();
                                break;
                            case 47:
                                jj_3_48();
                                break;
                            case 48:
                                jj_3_49();
                                break;
                            case 49:
                                jj_3_50();
                                break;
                            case 50:
                                jj_3_51();
                                break;
                            case 51:
                                jj_3_52();
                                break;
                            case 52:
                                jj_3_53();
                                break;
                            case 53:
                                jj_3_54();
                                break;
                            case 54:
                                jj_3_55();
                                break;
                            case 55:
                                jj_3_56();
                                break;
                            case 56:
                                jj_3_57();
                                break;
                            case 57:
                                jj_3_58();
                                break;
                            case 58:
                                jj_3_59();
                                break;
                            case 59:
                                jj_3_60();
                                break;
                            case 60:
                                jj_3_61();
                                break;
                            case 61:
                                jj_3_62();
                                break;
                            case 62:
                                jj_3_63();
                                break;
                            case 63:
                                jj_3_64();
                                break;
                            case 64:
                                jj_3_65();
                                break;
                            case 65:
                                jj_3_66();
                                break;
                            case 66:
                                jj_3_67();
                                break;
                            case 67:
                                jj_3_68();
                                break;
                            case 68:
                                jj_3_69();
                                break;
                            case 69:
                                jj_3_70();
                                break;
                            case 70:
                                jj_3_71();
                                break;
                            case 71:
                                jj_3_72();
                                break;
                            case 72:
                                jj_3_73();
                                break;
                            case 73:
                                jj_3_74();
                                break;
                            case 74:
                                jj_3_75();
                                break;
                            case 75:
                                jj_3_76();
                                break;
                            case 76:
                                jj_3_77();
                                break;
                            default:
                                break;
                        }
                    }
                    p = p.next;
                } while (p != null);
            } catch (LookaheadSuccess ls) {}
        }
        jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {

        int gen;
        Token first;
        int arg;
        JJCalls next;
    }
}
