/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.parser;

import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.OWLExpressionParser;
import org.semanticweb.owlapi.expression.OWLOntologyChecker;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserImpl;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OntologyAxiomPair;

public class ManchesterOWLSyntaxFramesParser
implements OWLExpressionParser<Set<OntologyAxiomPair>> {
    private final OWLDataFactory dataFactory;
    private OWLEntityChecker checker;
    @Nullable
    private OWLOntologyChecker ontologyChecker;
    @Nullable
    private OWLOntology defaultOntology;

    public ManchesterOWLSyntaxFramesParser(OWLDataFactory dataFactory, OWLEntityChecker checker) {
        this.dataFactory = dataFactory;
        this.checker = checker;
    }

    @Override
    public void setOWLEntityChecker(OWLEntityChecker entityChecker) {
        this.checker = entityChecker;
    }

    public void setOWLOntologyChecker(OWLOntologyChecker ontologyChecker) {
        this.ontologyChecker = ontologyChecker;
    }

    public void setDefaultOntology(OWLOntology ontology) {
        this.defaultOntology = ontology;
    }

    @Override
    public Set<OntologyAxiomPair> parse(String expression) {
        ManchesterOWLSyntaxParserImpl parser = new ManchesterOWLSyntaxParserImpl(new OntologyConfigurator(), this.dataFactory);
        parser.setOWLEntityChecker(this.checker);
        parser.setStringToParse(expression);
        parser.setDefaultOntology(OWLAPIPreconditions.verifyNotNull(this.defaultOntology));
        parser.setOWLOntologyChecker(OWLAPIPreconditions.verifyNotNull(this.ontologyChecker));
        return parser.parseFrames();
    }
}

