/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.MapPointer;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomIndexImpl;

public class OWLImmutableOntologyImpl
extends OWLAxiomIndexImpl
implements OWLOntology,
Serializable {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    protected OWLOntologyManager manager;
    @Nonnull
    protected OWLOntologyID ontologyID;
    private final OWLEntityReferenceChecker entityReferenceChecker = new OWLEntityReferenceChecker();

    @Override
    protected int index() {
        return 1;
    }

    public OWLImmutableOntologyImpl(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyID ontologyID) {
        this.manager = (OWLOntologyManager)OWLAPIPreconditions.checkNotNull((Object)manager, (String)"manager cannot be null");
        this.ontologyID = (OWLOntologyID)OWLAPIPreconditions.checkNotNull((Object)ontologyID, (String)"ontologyID cannot be null");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ontology(");
        sb.append(this.ontologyID);
        sb.append(") [Axioms: ");
        int axiomCount = this.ints.getAxiomCount();
        sb.append(axiomCount);
        sb.append(" Logical Axioms: ");
        sb.append(this.ints.getLogicalAxiomCount());
        sb.append("] First 20 axioms: {");
        for (OWLAxiom ax : Iterables.limit(this.ints.getAxioms(), (int)20)) {
            sb.append(ax).append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    public void setOWLOntologyManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public boolean isAnonymous() {
        return this.ontologyID.isAnonymous();
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        if (object == this) {
            return 0;
        }
        OWLOntology other = (OWLOntology)object;
        return this.ontologyID.compareTo(other.getOntologyID());
    }

    public boolean isEmpty() {
        return this.ints.isEmpty();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean includeImportsClosure) {
        return this.getAxiomCount(axiomType, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public int getAxiomCount(boolean includeImportsClosure) {
        return this.getAxiomCount(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getAxiomCount(axiomType);
        }
        int result = 0;
        for (OWLOntology ont : this.getImportsClosure()) {
            result += ont.getAxiomCount(axiomType);
        }
        return result;
    }

    public boolean containsAxiom(@Nonnull OWLAxiom axiom) {
        return Internals.contains(this.ints.getAxiomsByType(), axiom.getAxiomType(), axiom);
    }

    public int getAxiomCount() {
        return this.getAxiomCount(Imports.EXCLUDED);
    }

    public int getAxiomCount(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.getAxiomCount();
        }
        int total = 0;
        for (OWLOntology o : this.getImportsClosure()) {
            total += o.getAxiomCount();
        }
        return total;
    }

    public Set<OWLAxiom> getAxioms() {
        return this.getAxioms(Imports.EXCLUDED);
    }

    public Set<OWLAxiom> getAxioms(boolean b) {
        return this.getAxioms(Imports.fromBoolean((boolean)b));
    }

    public Set<OWLAxiom> getAxioms(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return OWLImmutableOntologyImpl.asSet(this.ints.getAxioms());
        }
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLOntology o : this.getImportsClosure()) {
            axioms.addAll(o.getAxioms());
        }
        return axioms;
    }

    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return OWLImmutableOntologyImpl.asSet(this.ints.getAxiomsByType().getValues(axiomType));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean includeImportsClosure) {
        return this.getAxioms(axiomType, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getAxioms(axiomType);
        }
        Set toReturn = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            toReturn.addAll(o.getAxioms(axiomType));
        }
        return toReturn;
    }

    @Nonnull
    public Set<OWLAxiom> getTBoxAxioms(Imports includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType type : AxiomType.TBoxAxiomTypes) {
            assert (type != null);
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    @Nonnull
    public Set<OWLAxiom> getABoxAxioms(Imports includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType type : AxiomType.ABoxAxiomTypes) {
            assert (type != null);
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    @Nonnull
    public Set<OWLAxiom> getRBoxAxioms(Imports includeImportsClosure) {
        HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
        for (AxiomType type : AxiomType.RBoxAxiomTypes) {
            assert (type != null);
            toReturn.addAll(this.getAxioms(type, includeImportsClosure));
        }
        return toReturn;
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return this.ints.getAxiomCount(axiomType);
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        return this.ints.getLogicalAxioms();
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.getLogicalAxioms();
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getLogicalAxioms(Imports.EXCLUDED));
        }
        return result;
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(boolean includeImportsClosure) {
        return this.getLogicalAxioms(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public int getLogicalAxiomCount() {
        return this.ints.getLogicalAxiomCount();
    }

    public int getLogicalAxiomCount(boolean includeImportsClosure) {
        return this.getLogicalAxiomCount(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public int getLogicalAxiomCount(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.getLogicalAxiomCount();
        }
        int total = 0;
        for (OWLOntology o : this.getImportsClosure()) {
            total += o.getLogicalAxiomCount(Imports.EXCLUDED);
        }
        return total;
    }

    @Nonnull
    public Set<OWLAnnotation> getAnnotations() {
        return (Set)this.ints.getOntologyAnnotations(true);
    }

    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.ints.getGeneralClassAxioms();
    }

    public boolean containsAxiom(@Nonnull OWLAxiom axiom, boolean includeImportsClosure) {
        return this.containsAxiom(axiom, Imports.fromBoolean((boolean)includeImportsClosure), AxiomAnnotations.CONSIDER_AXIOM_ANNOTATIONS);
    }

    public boolean containsAxiom(@Nonnull OWLAxiom axiom, Imports includeImportsClosure, AxiomAnnotations ignoreAnnotations) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            if (ignoreAnnotations == AxiomAnnotations.CONSIDER_AXIOM_ANNOTATIONS) {
                return this.containsAxiom(axiom);
            }
            return this.containsAxiomIgnoreAnnotations(axiom);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsAxiom(axiom, Imports.EXCLUDED, ignoreAnnotations)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom axiom) {
        for (OWLAxiom ax : this.ints.getAxiomsByType().getValues(axiom.getAxiomType())) {
            if (!ax.equalsIgnoreAnnotations(axiom)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom axiom, boolean importsIncluded) {
        return this.containsAxiom(axiom, Imports.fromBoolean((boolean)importsIncluded), AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS);
    }

    @Nonnull
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom axiom) {
        Set result = CollectionFactory.createLinkedSet();
        if (this.containsAxiom(axiom)) {
            result.add(axiom);
        }
        for (OWLAxiom ax : this.ints.getAxiomsByType().getValues(axiom.getAxiomType())) {
            if (!ax.equalsIgnoreAnnotations(axiom)) continue;
            result.add(ax);
        }
        return result;
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom axiom, boolean includeImportsClosure) {
        return this.getAxiomsIgnoreAnnotations(axiom, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom axiom, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getAxiomsIgnoreAnnotations(axiom);
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getAxiomsIgnoreAnnotations(axiom, Imports.EXCLUDED));
        }
        return result;
    }

    public boolean containsClassInSignature(IRI owlClassIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsClassInSignature(owlClassIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsClassInSignature(owlClassIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    public boolean containsObjectPropertyInSignature(IRI owlObjectPropertyIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsObjectPropertyInSignature(owlObjectPropertyIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsObjectPropertyInSignature(owlObjectPropertyIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDataPropertyInSignature(IRI owlDataPropertyIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsDataPropertyInSignature(owlDataPropertyIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsDataPropertyInSignature(owlDataPropertyIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnnotationPropertyInSignature(IRI owlAnnotationPropertyIRI, Imports includeImportsClosure) {
        OWLAnnotationProperty p = this.manager.getOWLDataFactory().getOWLAnnotationProperty(owlAnnotationPropertyIRI);
        if (includeImportsClosure == Imports.INCLUDED) {
            for (OWLOntology o : this.getImportsClosure()) {
                if (!o.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI, Imports.EXCLUDED)) continue;
                return true;
            }
        } else if (this.ints.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI)) {
            return true;
        }
        return this.checkOntologyAnnotations(p);
    }

    private boolean checkOntologyAnnotations(OWLAnnotationProperty owlAnnotationProperty) {
        for (OWLAnnotation anno : this.ints.getOntologyAnnotations(false)) {
            if (!anno.getProperty().equals(owlAnnotationProperty)) continue;
            return true;
        }
        return false;
    }

    public boolean containsIndividualInSignature(IRI owlIndividualIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsIndividualInSignature(owlIndividualIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsIndividualInSignature(owlIndividualIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDatatypeInSignature(IRI owlDatatypeIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsDatatypeInSignature(owlDatatypeIRI);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsDatatypeInSignature(owlDatatypeIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI entityIRI) {
        return this.getEntitiesInSignature(entityIRI, Imports.EXCLUDED);
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri, Imports includeImportsClosure) {
        Set result = CollectionFactory.createSet((int)6);
        if (this.containsClassInSignature(iri, includeImportsClosure)) {
            result.add(this.manager.getOWLDataFactory().getOWLClass(iri));
        }
        if (this.containsObjectPropertyInSignature(iri, includeImportsClosure)) {
            result.add(this.manager.getOWLDataFactory().getOWLObjectProperty(iri));
        }
        if (this.containsDataPropertyInSignature(iri, includeImportsClosure)) {
            result.add(this.manager.getOWLDataFactory().getOWLDataProperty(iri));
        }
        if (this.containsIndividualInSignature(iri, includeImportsClosure)) {
            result.add(this.manager.getOWLDataFactory().getOWLNamedIndividual(iri));
        }
        if (this.containsDatatypeInSignature(iri, includeImportsClosure)) {
            result.add(this.manager.getOWLDataFactory().getOWLDatatype(iri));
        }
        if (this.containsAnnotationPropertyInSignature(iri, includeImportsClosure)) {
            result.add(this.manager.getOWLDataFactory().getOWLAnnotationProperty(iri));
        }
        return result;
    }

    public Set<IRI> getPunnedIRIs(Imports includeImportsClosure) {
        HashSet<IRI> punned = new HashSet<IRI>();
        HashSet<IRI> test = new HashSet<IRI>();
        if (includeImportsClosure == Imports.INCLUDED) {
            for (OWLOntology oWLOntology : this.getImportsClosure()) {
                for (OWLEntity e : oWLOntology.getClassesInSignature(Imports.EXCLUDED)) {
                    if (test.add(e.getIRI())) continue;
                    punned.add(e.getIRI());
                }
                for (OWLEntity e : oWLOntology.getDataPropertiesInSignature(Imports.EXCLUDED)) {
                    if (test.add(e.getIRI())) continue;
                    punned.add(e.getIRI());
                }
                for (OWLEntity e : oWLOntology.getObjectPropertiesInSignature(Imports.EXCLUDED)) {
                    if (test.add(e.getIRI())) continue;
                    punned.add(e.getIRI());
                }
                for (OWLEntity e : oWLOntology.getAnnotationPropertiesInSignature(Imports.EXCLUDED)) {
                    if (test.add(e.getIRI())) continue;
                    punned.add(e.getIRI());
                }
                for (OWLEntity e : oWLOntology.getDatatypesInSignature(Imports.EXCLUDED)) {
                    if (test.add(e.getIRI())) continue;
                    punned.add(e.getIRI());
                }
                for (OWLEntity e : oWLOntology.getIndividualsInSignature(Imports.EXCLUDED)) {
                    if (test.add(e.getIRI())) continue;
                    punned.add(e.getIRI());
                }
            }
            if (punned.isEmpty()) {
                return CollectionFactory.emptySet();
            }
            return punned;
        }
        for (OWLEntity oWLEntity : this.getClassesInSignature(Imports.EXCLUDED)) {
            test.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getDataPropertiesInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getObjectPropertiesInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getAnnotationPropertiesInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getDatatypesInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        for (OWLEntity oWLEntity : this.getIndividualsInSignature(Imports.EXCLUDED)) {
            if (test.add(oWLEntity.getIRI())) continue;
            punned.add(oWLEntity.getIRI());
        }
        if (punned.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        return punned;
    }

    public boolean containsReference(@Nonnull OWLEntity entity, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsReference(entity);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsReference(entity, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeclared(OWLEntity owlEntity) {
        return this.ints.isDeclared(owlEntity);
    }

    public boolean isDeclared(OWLEntity owlEntity, Imports includeImportsClosure) {
        if (this.isDeclared(owlEntity)) {
            return true;
        }
        if (includeImportsClosure == Imports.INCLUDED) {
            for (OWLOntology ont : this.manager.getImportsClosure((OWLOntology)this)) {
                if (ont.equals(this) || !ont.isDeclared(owlEntity)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity) {
        return this.containsEntityInSignature(owlEntity, Imports.EXCLUDED);
    }

    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity, Imports includeImportsClosure) {
        if (includeImportsClosure != Imports.INCLUDED) {
            return this.entityReferenceChecker.containsReference(owlEntity);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.containsEntityInSignature(owlEntity, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntityInSignature(IRI entityIRI, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            if (this.containsClassInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            if (this.containsObjectPropertyInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            if (this.containsDataPropertyInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            if (this.containsIndividualInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            if (this.containsDatatypeInSignature(entityIRI, Imports.EXCLUDED)) {
                return true;
            }
            return this.containsAnnotationPropertyInSignature(entityIRI, Imports.EXCLUDED);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsEntityInSignature(entityIRI, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        Set entities = CollectionFactory.createLinkedSet();
        entities.addAll(this.getClassesInSignature());
        entities.addAll(this.getObjectPropertiesInSignature());
        entities.addAll(this.getDataPropertiesInSignature());
        entities.addAll(this.getIndividualsInSignature());
        entities.addAll(this.getDatatypesInSignature());
        entities.addAll(this.getAnnotationPropertiesInSignature(Imports.EXCLUDED));
        return entities;
    }

    public Set<OWLEntity> getSignature(Imports includeImportsClosure) {
        Set<OWLEntity> entities = this.getSignature();
        if (includeImportsClosure == Imports.INCLUDED) {
            for (OWLOntology ont : this.getImportsClosure()) {
                entities.addAll(ont.getSignature(Imports.EXCLUDED));
            }
        }
        return entities;
    }

    @Nonnull
    private static <T> Set<T> asSet(Iterable<T> i) {
        if (i instanceof Set) {
            ArrayList list = new ArrayList();
            Iterables.addAll(list, i);
            return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(list);
        }
        HashSet set = new HashSet();
        Iterables.addAll(set, i);
        return set;
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get()).keySet());
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLClass.class, OWLAxiom.class).get()).keySet());
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLDataProperty.class, OWLAxiom.class).get()).keySet());
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLObjectProperty.class, OWLAxiom.class).get()).keySet());
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLNamedIndividual.class, OWLAxiom.class).get()).keySet());
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLDatatype.class, OWLAxiom.class).get()).keySet());
    }

    public Set<OWLClass> getClassesInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getClassesInSignature();
        }
        Set results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getClassesInSignature());
        }
        return results;
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getObjectPropertiesInSignature();
        }
        Set results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getObjectPropertiesInSignature());
        }
        return results;
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getDataPropertiesInSignature();
        }
        Set results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDataPropertiesInSignature());
        }
        return results;
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getIndividualsInSignature();
        }
        Set results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getIndividualsInSignature());
        }
        return results;
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get()).keySet());
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getReferencedAnonymousIndividuals(Imports.EXCLUDED));
        }
        return result;
    }

    public Set<OWLDatatype> getDatatypesInSignature(Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getDatatypesInSignature();
        }
        Set results = CollectionFactory.createLinkedSet();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDatatypesInSignature());
        }
        return results;
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(Imports includeImportsClosure) {
        Set props = CollectionFactory.createLinkedSet();
        if (includeImportsClosure == Imports.EXCLUDED) {
            Iterables.addAll((Collection)props, ((MapPointer)this.ints.get(OWLAnnotationProperty.class, OWLAxiom.class, Navigation.IN_SUB_POSITION).get()).keySet());
            for (OWLAnnotation anno : this.ints.getOntologyAnnotations(false)) {
                props.add(anno.getProperty());
            }
        } else {
            for (OWLOntology ont : this.getImportsClosure()) {
                props.addAll(ont.getAnnotationPropertiesInSignature(Imports.EXCLUDED));
            }
        }
        return props;
    }

    @Nonnull
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return (Set)this.ints.getImportsDeclarations(true);
    }

    public Set<IRI> getDirectImportsDocuments() {
        Set result = CollectionFactory.createLinkedSet();
        for (OWLImportsDeclaration importsDeclaration : this.ints.getImportsDeclarations(false)) {
            result.add(importsDeclaration.getIRI());
        }
        return result;
    }

    public Set<OWLOntology> getImports() {
        return this.manager.getImports((OWLOntology)this);
    }

    public Set<OWLOntology> getDirectImports() {
        return this.manager.getDirectImports((OWLOntology)this);
    }

    public Set<OWLOntology> getImportsClosure() {
        return this.getOWLOntologyManager().getImportsClosure((OWLOntology)this);
    }

    public void accept(@Nonnull OWLObjectVisitor visitor) {
        visitor.visit((OWLOntology)this);
    }

    public void accept(@Nonnull OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLOntology)this);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLOntology)this);
    }

    public <O> O accept(@Nonnull OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLOntology)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntology)) {
            return false;
        }
        OWLOntology other = (OWLOntology)obj;
        return this.ontologyID.equals((Object)other.getOntologyID());
    }

    @Override
    public int hashCode() {
        return this.ontologyID.hashCode();
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass cls, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLClass.class, OWLClassAxiom.class).get()).getValues(cls));
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getAxioms(cls, Imports.EXCLUDED));
        }
        return result;
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property, Imports includeImportsClosure) {
        Set result = CollectionFactory.createSet((int)50);
        if (includeImportsClosure == Imports.EXCLUDED) {
            result.addAll(this.getAsymmetricObjectPropertyAxioms(property));
            result.addAll(this.getReflexiveObjectPropertyAxioms(property));
            result.addAll(this.getSymmetricObjectPropertyAxioms(property));
            result.addAll(this.getIrreflexiveObjectPropertyAxioms(property));
            result.addAll(this.getTransitiveObjectPropertyAxioms(property));
            result.addAll(this.getInverseFunctionalObjectPropertyAxioms(property));
            result.addAll(this.getFunctionalObjectPropertyAxioms(property));
            result.addAll(this.getInverseObjectPropertyAxioms(property));
            result.addAll(this.getObjectPropertyDomainAxioms(property));
            result.addAll(this.getEquivalentObjectPropertiesAxioms(property));
            result.addAll(this.getDisjointObjectPropertiesAxioms(property));
            result.addAll(this.getObjectPropertyRangeAxioms(property));
            result.addAll(this.getObjectSubPropertyAxiomsForSubProperty(property));
        } else {
            for (OWLOntology o : this.getImportsClosure()) {
                result.addAll(o.getAxioms(property, Imports.EXCLUDED));
            }
        }
        return result;
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property, Imports includeImportsClosure) {
        Set result = CollectionFactory.createLinkedSet();
        if (includeImportsClosure == Imports.EXCLUDED) {
            for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
                if (!ax.getSubProperty().equals(property)) continue;
                result.add(ax);
            }
            for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
                if (!ax.getProperty().equals(property)) continue;
                result.add(ax);
            }
            for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
                if (!ax.getProperty().equals(property)) continue;
                result.add(ax);
            }
        } else {
            for (OWLOntology o : this.getImportsClosure()) {
                result.addAll(o.getAxioms(property, Imports.EXCLUDED));
            }
        }
        return result;
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property, Imports includeImportsClosure) {
        Set result = CollectionFactory.createLinkedSet();
        if (includeImportsClosure == Imports.EXCLUDED) {
            result.addAll(this.getDataPropertyDomainAxioms(property));
            result.addAll(this.getEquivalentDataPropertiesAxioms(property));
            result.addAll(this.getDisjointDataPropertiesAxioms(property));
            result.addAll(this.getDataPropertyRangeAxioms(property));
            result.addAll(this.getFunctionalDataPropertyAxioms((OWLDataPropertyExpression)property));
            result.addAll(this.getDataSubPropertyAxiomsForSubProperty(property));
        } else {
            for (OWLOntology o : this.getImportsClosure()) {
                result.addAll(o.getAxioms(property, Imports.EXCLUDED));
            }
        }
        return result;
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual, Imports includeImportsClosure) {
        Set result = CollectionFactory.createLinkedSet();
        if (includeImportsClosure == Imports.EXCLUDED) {
            result.addAll(this.getClassAssertionAxioms(individual));
            result.addAll(this.getObjectPropertyAssertionAxioms(individual));
            result.addAll(this.getDataPropertyAssertionAxioms(individual));
            result.addAll(this.getNegativeObjectPropertyAssertionAxioms(individual));
            result.addAll(this.getNegativeDataPropertyAssertionAxioms(individual));
            result.addAll(this.getSameIndividualAxioms(individual));
            result.addAll(this.getDifferentIndividualAxioms(individual));
        } else {
            for (OWLOntology o : this.getImportsClosure()) {
                result.addAll(o.getAxioms(individual, Imports.EXCLUDED));
            }
        }
        return result;
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.getDatatypeDefinitions(datatype);
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getAxioms(datatype, Imports.EXCLUDED));
        }
        return result;
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlEntity) {
        return this.getReferencingAxioms(owlEntity, Imports.EXCLUDED);
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlEntity, boolean includeImports) {
        return this.getReferencingAxioms(owlEntity, Imports.fromBoolean((boolean)includeImports));
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlEntity, Imports includeImportsClosure) {
        if (owlEntity instanceof OWLEntity) {
            if (includeImportsClosure == Imports.EXCLUDED) {
                return OWLImmutableOntologyImpl.asSet(this.ints.getReferencingAxioms((OWLEntity)owlEntity));
            }
            Set result = CollectionFactory.createLinkedSet();
            for (OWLOntology ont : this.getImportsClosure()) {
                result.addAll(ont.getReferencingAxioms(owlEntity, Imports.EXCLUDED));
            }
            return result;
        }
        if (owlEntity instanceof OWLAnonymousIndividual) {
            return OWLImmutableOntologyImpl.asSet(((MapPointer)this.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get()).getValues((OWLAnonymousIndividual)owlEntity));
        }
        if (owlEntity instanceof IRI) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            Set<OWLEntity> entities = this.getEntitiesInSignature((IRI)owlEntity, includeImportsClosure);
            for (OWLEntity e : entities) {
                assert (e != null);
                axioms.addAll(this.getReferencingAxioms((OWLPrimitive)e, includeImportsClosure));
            }
            for (OWLDataPropertyAssertionAxiom ax : this.getAxioms(AxiomType.DATA_PROPERTY_ASSERTION)) {
                if (!((OWLLiteral)ax.getObject()).getDatatype().getIRI().equals((Object)OWL2Datatype.XSD_ANY_URI.getIRI()) || !((OWLLiteral)ax.getObject()).getLiteral().equals(owlEntity.toString())) continue;
                axioms.add((OWLAxiom)ax);
            }
            for (OWLDataPropertyAssertionAxiom ax : this.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
                Optional lit;
                if (ax.getSubject().equals(owlEntity)) {
                    axioms.add((OWLAxiom)ax);
                    continue;
                }
                if (!ax.getValue().asLiteral().isPresent() || !((OWLLiteral)(lit = ax.getValue().asLiteral()).get()).getDatatype().getIRI().equals((Object)OWL2Datatype.XSD_ANY_URI.getIRI()) || !((OWLLiteral)lit.get()).getLiteral().equals(owlEntity.toString())) continue;
                axioms.add((OWLAxiom)ax);
            }
            return axioms;
        }
        if (owlEntity instanceof OWLLiteral) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            for (OWLDataPropertyAssertionAxiom ax : this.getAxioms(AxiomType.DATA_PROPERTY_ASSERTION)) {
                if (!((OWLLiteral)ax.getObject()).equals(owlEntity)) continue;
                axioms.add((OWLAxiom)ax);
            }
            for (OWLDataPropertyAssertionAxiom ax : this.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
                if (!owlEntity.equals(ax.getValue().asLiteral().orNull())) continue;
                axioms.add((OWLAxiom)ax);
            }
            for (AxiomType t : AxiomType.AXIOM_TYPES) {
                for (OWLAxiom ax : this.getAxioms(t)) {
                    if (!this.hasLiteralInAnnotations(owlEntity, ax)) continue;
                    axioms.add(ax);
                }
            }
            return axioms;
        }
        return CollectionFactory.emptySet();
    }

    protected boolean hasLiteralInAnnotations(OWLPrimitive owlEntity, OWLAxiom ax) {
        for (OWLAnnotation ann : ax.getAnnotations()) {
            if (!ann.getValue().equals(owlEntity)) continue;
            return true;
        }
        return false;
    }

    public <A extends OWLAxiom> Set<A> getAxioms(@Nonnull Class<A> type, @Nonnull OWLObject entity, Imports includeImports, Navigation forSubPosition) {
        if (includeImports == Imports.EXCLUDED) {
            return this.getAxioms(type, entity.getClass(), entity, Imports.EXCLUDED, forSubPosition);
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getAxioms(type, entity, Imports.EXCLUDED, forSubPosition));
        }
        return result;
    }

    public <A extends OWLAxiom> Set<A> getAxioms(@Nonnull Class<A> type, @Nonnull Class<? extends OWLObject> explicitClass, @Nonnull OWLObject entity, @Nonnull Imports includeImports, @Nonnull Navigation forSubPosition) {
        if (includeImports == Imports.EXCLUDED) {
            Optional<MapPointer<? extends OWLObject, A>> optional = this.ints.get(explicitClass, type, forSubPosition);
            if (optional.isPresent()) {
                return OWLImmutableOntologyImpl.asSet(((MapPointer)optional.get()).getValues(entity));
            }
            HashSet<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : this.getAxioms(AxiomType.getTypeForClass(type))) {
                if (!ax.getSignature().contains(entity)) continue;
                toReturn.add(ax);
            }
            return toReturn;
        }
        Set result = CollectionFactory.createLinkedSet();
        for (OWLOntology o : this.getImportsClosure()) {
            result.addAll(o.getAxioms(type, entity, Imports.EXCLUDED, forSubPosition));
        }
        return result;
    }

    @Nonnull
    public <T extends OWLAxiom> Collection<T> filterAxioms(@Nonnull OWLAxiomSearchFilter filter, @Nonnull Object key, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.filterAxioms(filter, key);
        }
        HashSet toReturn = new HashSet();
        for (OWLOntology o : this.getImportsClosure()) {
            toReturn.addAll(o.filterAxioms(filter, key, Imports.EXCLUDED));
        }
        return toReturn;
    }

    public boolean contains(@Nonnull OWLAxiomSearchFilter filter, @Nonnull Object key, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.contains(filter, key);
        }
        for (OWLOntology o : this.getImportsClosure()) {
            if (!o.contains(filter, key, Imports.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass cls) {
        return this.getAxioms(cls, false);
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property) {
        return this.getAxioms(property, Imports.EXCLUDED);
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property) {
        return this.getAxioms(property, Imports.EXCLUDED);
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        return this.getAxioms(individual, Imports.EXCLUDED);
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property) {
        return this.getAxioms(property, Imports.EXCLUDED);
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype) {
        return this.getAxioms(datatype, Imports.EXCLUDED);
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass cls, boolean includeImportsClosure) {
        return this.getAxioms(cls, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property, boolean includeImportsClosure) {
        return this.getAxioms(property, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property, boolean includeImportsClosure) {
        return this.getAxioms(property, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual, boolean includeImportsClosure) {
        return this.getAxioms(individual, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property, boolean includeImportsClosure) {
        return this.getAxioms(property, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype, boolean includeImportsClosure) {
        return this.getAxioms(datatype, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public void saveOntology() throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this);
    }

    public void saveOntology(IRI documentIRI) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, documentIRI);
    }

    public void saveOntology(OutputStream outputStream) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, outputStream);
    }

    public void saveOntology(OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, ontologyFormat);
    }

    public void saveOntology(OWLDocumentFormat ontologyFormat, IRI documentIRI) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, ontologyFormat, documentIRI);
    }

    public void saveOntology(OWLDocumentFormat ontologyFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, ontologyFormat, outputStream);
    }

    public void saveOntology(OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, documentTarget);
    }

    public void saveOntology(OWLDocumentFormat ontologyFormat, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.getOWLOntologyManager().saveOntology((OWLOntology)this, ontologyFormat, documentTarget);
    }

    public boolean containsDatatypeInSignature(IRI owlDatatypeIRI) {
        return this.containsDatatypeInSignature(owlDatatypeIRI, Imports.EXCLUDED);
    }

    public boolean containsEntityInSignature(IRI entityIRI) {
        return this.containsEntityInSignature(entityIRI, Imports.EXCLUDED);
    }

    public boolean containsClassInSignature(IRI owlClassIRI) {
        return this.containsClassInSignature(owlClassIRI, Imports.EXCLUDED);
    }

    public boolean containsObjectPropertyInSignature(IRI owlObjectPropertyIRI) {
        return this.containsObjectPropertyInSignature(owlObjectPropertyIRI, Imports.EXCLUDED);
    }

    public boolean containsDataPropertyInSignature(IRI owlDataPropertyIRI) {
        return this.containsDataPropertyInSignature(owlDataPropertyIRI, Imports.EXCLUDED);
    }

    public boolean containsAnnotationPropertyInSignature(IRI owlAnnotationPropertyIRI) {
        return this.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI, Imports.EXCLUDED);
    }

    public boolean containsIndividualInSignature(IRI owlIndividualIRI) {
        return this.containsIndividualInSignature(owlIndividualIRI, Imports.EXCLUDED);
    }

    public boolean containsReference(OWLEntity entity) {
        return this.containsReference(entity, Imports.EXCLUDED);
    }

    public Set<OWLClass> getClassesInSignature(boolean includeImportsClosure) {
        return this.getClassesInSignature(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean includeImportsClosure) {
        return this.getObjectPropertiesInSignature(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean includeImportsClosure) {
        return this.getDataPropertiesInSignature(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean includeImportsClosure) {
        return this.getIndividualsInSignature(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(boolean includeImportsClosure) {
        return this.getReferencedAnonymousIndividuals(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLDatatype> getDatatypesInSignature(boolean includeImportsClosure) {
        return this.getDatatypesInSignature(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(boolean includeImportsClosure) {
        return this.getAnnotationPropertiesInSignature(Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean includeImportsClosure) {
        return this.containsEntityInSignature(owlEntity, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsEntityInSignature(IRI entityIRI, boolean includeImportsClosure) {
        return this.containsEntityInSignature(entityIRI, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsClassInSignature(IRI owlClassIRI, boolean includeImportsClosure) {
        return this.containsClassInSignature(owlClassIRI, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsObjectPropertyInSignature(IRI owlObjectPropertyIRI, boolean includeImportsClosure) {
        return this.containsObjectPropertyInSignature(owlObjectPropertyIRI, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsDataPropertyInSignature(IRI owlDataPropertyIRI, boolean includeImportsClosure) {
        return this.containsDataPropertyInSignature(owlDataPropertyIRI, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsAnnotationPropertyInSignature(IRI owlAnnotationPropertyIRI, boolean includeImportsClosure) {
        return this.containsAnnotationPropertyInSignature(owlAnnotationPropertyIRI, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsDatatypeInSignature(IRI owlDatatypeIRI, boolean includeImportsClosure) {
        return this.containsDatatypeInSignature(owlDatatypeIRI, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsIndividualInSignature(IRI owlIndividualIRI, boolean includeImportsClosure) {
        return this.containsIndividualInSignature(owlIndividualIRI, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean includeImportsClosure) {
        return this.getEntitiesInSignature(iri, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    public boolean containsReference(OWLEntity entity, boolean includeImportsClosure) {
        return this.containsReference(entity, Imports.fromBoolean((boolean)includeImportsClosure));
    }

    private class OWLEntityReferenceChecker
    implements OWLEntityVisitor,
    Serializable {
        private static final long serialVersionUID = 40000L;
        private boolean ref;

        OWLEntityReferenceChecker() {
        }

        public boolean containsReference(@Nonnull OWLEntity entity) {
            this.ref = false;
            entity.accept((OWLEntityVisitor)this);
            return this.ref;
        }

        public void visit(@Nonnull OWLClass cls) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsClassInSignature(cls);
        }

        public void visit(@Nonnull OWLDatatype datatype) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsDatatypeInSignature(datatype);
        }

        public void visit(@Nonnull OWLNamedIndividual individual) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsIndividualInSignature(individual);
        }

        public void visit(@Nonnull OWLDataProperty property) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsDataPropertyInSignature(property);
        }

        public void visit(@Nonnull OWLObjectProperty property) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsObjectPropertyInSignature(property);
        }

        public void visit(@Nonnull OWLAnnotationProperty property) {
            this.ref = OWLImmutableOntologyImpl.this.ints.containsAnnotationPropertyInSignature(property);
        }
    }
}

