/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLNaryPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubObjectPropertyOfAxiomImpl;

public class OWLInverseObjectPropertiesAxiomImpl
extends OWLNaryPropertyAxiomImpl<OWLObjectPropertyExpression>
implements OWLInverseObjectPropertiesAxiom {
    @Nonnull
    private final OWLObjectPropertyExpression first;
    @Nonnull
    private final OWLObjectPropertyExpression second;

    public OWLInverseObjectPropertiesAxiomImpl(OWLObjectPropertyExpression first, OWLObjectPropertyExpression second, Collection<OWLAnnotation> annotations) {
        super(new TreeSet<OWLObjectPropertyExpression>(Arrays.asList((OWLObjectPropertyExpression)OWLAPIPreconditions.checkNotNull((Object)first, (String)"first cannot be null"), (OWLObjectPropertyExpression)OWLAPIPreconditions.checkNotNull((Object)second, (String)"second cannot be null"))), annotations);
        this.first = first;
        this.second = second;
    }

    public Collection<OWLInverseObjectPropertiesAxiom> asPairwiseAxioms() {
        return CollectionFactory.createSet((Object)this);
    }

    public Collection<OWLInverseObjectPropertiesAxiom> splitToAnnotatedPairs() {
        return this.asPairwiseAxioms();
    }

    public OWLInverseObjectPropertiesAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLInverseObjectPropertiesAxiomImpl(this.getFirstProperty(), this.getSecondProperty(), NO_ANNOTATIONS);
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLInverseObjectPropertiesAxiomImpl(this.getFirstProperty(), this.getSecondProperty(), this.mergeAnnos(anns));
    }

    public OWLObjectPropertyExpression getFirstProperty() {
        return this.first;
    }

    public OWLObjectPropertyExpression getSecondProperty() {
        return this.second;
    }

    public Collection<OWLSubObjectPropertyOfAxiom> asSubObjectPropertyOfAxioms() {
        HashSet<OWLSubObjectPropertyOfAxiom> axs = new HashSet<OWLSubObjectPropertyOfAxiom>();
        axs.add(new OWLSubObjectPropertyOfAxiomImpl(this.first, this.second.getInverseProperty().getSimplified(), (Collection<OWLAnnotation>)NO_ANNOTATIONS));
        axs.add(new OWLSubObjectPropertyOfAxiomImpl(this.second, this.first.getInverseProperty().getSimplified(), (Collection<OWLAnnotation>)NO_ANNOTATIONS));
        return axs;
    }
}

