/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImpl
extends OWLObjectImpl
implements OWLLiteral {
    private static final int COMPRESSION_LIMIT = 160;
    private final LiteralWrapper literal;
    @Nonnull
    private static final OWLDatatype RDF_PLAIN_LITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    @Nonnull
    private static final OWLDatatype RDF_LANG_STRING = new OWL2DatatypeImpl(OWL2Datatype.RDF_LANG_STRING);
    @Nonnull
    private static final OWLDatatype XSD_STRING = new OWL2DatatypeImpl(OWL2Datatype.XSD_STRING);
    @Nonnull
    private final OWLDatatype datatype;
    @Nonnull
    private final String language;

    public OWLLiteralImpl(String literal, @Nullable String lang, @Nullable OWLDatatype datatype) {
        this.literal = new LiteralWrapper((String)OWLAPIPreconditions.checkNotNull((Object)literal, (String)"literal cannot be null"));
        if (lang == null || lang.isEmpty()) {
            this.language = "";
            this.datatype = datatype == null || datatype.equals(RDF_PLAIN_LITERAL) || datatype.equals(XSD_STRING) ? XSD_STRING : datatype;
        } else {
            if (datatype != null && !datatype.equals(RDF_LANG_STRING) && !datatype.equals(RDF_PLAIN_LITERAL)) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.language = lang;
            this.datatype = RDF_LANG_STRING;
        }
    }

    public String getLiteral() {
        return this.literal.get();
    }

    public boolean hasLang() {
        return !this.language.isEmpty();
    }

    public boolean isRDFPlainLiteral() {
        return this.getDatatype().isRDFPlainLiteral();
    }

    public boolean isInteger() {
        return this.getDatatype().isInteger();
    }

    public boolean isBoolean() {
        return this.getDatatype().isBoolean();
    }

    public boolean isDouble() {
        return this.getDatatype().isDouble();
    }

    public boolean isFloat() {
        return this.getDatatype().isFloat();
    }

    public int parseInteger() {
        return Integer.parseInt(this.literal.get());
    }

    static boolean asBoolean(String s) {
        return Boolean.parseBoolean(s) || "1".equals(s.trim());
    }

    public boolean parseBoolean() {
        return OWLLiteralImpl.asBoolean(this.literal.get());
    }

    public double parseDouble() {
        return Double.parseDouble(this.literal.get());
    }

    public float parseFloat() {
        return Float.parseFloat(this.literal.get());
    }

    public String getLang() {
        return this.language;
    }

    public boolean hasLang(@Nullable String lang) {
        if (lang == null || lang.isEmpty()) {
            return this.language.isEmpty();
        }
        return this.language.equalsIgnoreCase(lang.trim());
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    protected int hashCode(OWLObject object) {
        return OWLLiteralImpl.hash(object.hashIndex(), Stream.of(this.getDatatype(), this.specificHash(), this.getLang()));
    }

    private int specificHash() {
        if (this.literal.l != null) {
            return this.literal.l.hashCode();
        }
        return Arrays.hashCode(this.literal.bytes);
    }

    private static class LiteralWrapper
    implements Serializable {
        private static final String COMPRESSED_ENCODING = "UTF-16";
        String l;
        byte[] bytes;

        LiteralWrapper(String s) {
            if (s.length() > 160) {
                try {
                    this.bytes = LiteralWrapper.compress(s);
                    this.l = null;
                }
                catch (IOException e) {
                    this.l = s;
                    this.bytes = null;
                }
            } else {
                this.bytes = null;
                this.l = s;
            }
        }

        String get() {
            if (this.l != null) {
                return (String)OWLAPIPreconditions.verifyNotNull((Object)this.l);
            }
            try {
                return LiteralWrapper.decompress(this.bytes);
            }
            catch (IOException e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }

        static byte[] compress(String s) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream zipout = new GZIPOutputStream(out);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipout, COMPRESSED_ENCODING);
            writer.write(s);
            ((Writer)writer).flush();
            zipout.finish();
            zipout.flush();
            return out.toByteArray();
        }

        static String decompress(byte[] result) throws IOException {
            ByteArrayInputStream in = new ByteArrayInputStream(result);
            GZIPInputStream zipin = new GZIPInputStream(in);
            InputStreamReader reader = new InputStreamReader((InputStream)zipin, COMPRESSED_ENCODING);
            StringBuilder b = new StringBuilder();
            int c = ((Reader)reader).read();
            while (c > -1) {
                b.append((char)c);
                c = ((Reader)reader).read();
            }
            return b.toString();
        }
    }
}

