/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;

public abstract class OWLNaryClassAxiomImpl
extends OWLClassAxiomImpl
implements OWLNaryClassAxiom {
    @Nonnull
    protected final List<OWLClassExpression> classExpressions;

    public OWLNaryClassAxiomImpl(Collection<? extends OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        super(annotations);
        OWLAPIPreconditions.checkNotNull(classExpressions, (String)"classExpressions cannot be null");
        this.classExpressions = CollectionFactory.sortOptionally(classExpressions.stream().distinct(), OWLClassExpression.class);
    }

    public Stream<OWLClassExpression> classExpressions() {
        return this.classExpressions.stream();
    }

    public boolean contains(OWLClassExpression ce) {
        return this.classExpressions.contains(ce);
    }

    public Set<OWLClassExpression> getClassExpressionsMinus(OWLClassExpression ... desc) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>(this.classExpressions);
        for (OWLClassExpression d : desc) {
            result.remove(d);
        }
        return result;
    }
}

