/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyAxiomImpl;

public abstract class OWLNaryPropertyAxiomImpl<P extends OWLPropertyExpression>
extends OWLPropertyAxiomImpl
implements OWLNaryPropertyAxiom<P> {
    protected final List<P> properties;

    public OWLNaryPropertyAxiomImpl(Collection<? extends P> properties, Collection<OWLAnnotation> annotations) {
        this(((Collection)OWLAPIPreconditions.checkNotNull(properties, (String)"properties cannot be null")).stream(), annotations);
    }

    public OWLNaryPropertyAxiomImpl(Stream<? extends P> properties, Collection<OWLAnnotation> annotations) {
        super(annotations);
        OWLAPIPreconditions.checkNotNull(properties, (String)"properties cannot be null");
        this.properties = OWLAPIStreamUtils.sorted(OWLPropertyExpression.class, properties);
    }

    @SafeVarargs
    OWLNaryPropertyAxiomImpl(Collection<OWLAnnotation> annotations, P ... properties) {
        this(Stream.of(properties), annotations);
    }

    public Stream<P> properties() {
        return OWLAPIStreamUtils.streamFromSorted(this.properties);
    }

    public Set<P> getPropertiesMinus(P property) {
        LinkedHashSet<P> props = new LinkedHashSet<P>(this.properties);
        props.remove(property);
        return props;
    }
}

