/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.AsOWLAnnotationProperty;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.AsOWLDataProperty;
import org.semanticweb.owlapi.model.AsOWLDatatype;
import org.semanticweb.owlapi.model.AsOWLNamedIndividual;
import org.semanticweb.owlapi.model.AsOWLObjectProperty;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;
import uk.ac.manchester.cs.owl.owlapi.HasIncrementalSignatureGenerationSupport;

public abstract class OWLObjectImpl
implements OWLObject,
Serializable,
HasIncrementalSignatureGenerationSupport {
    protected static final Set<OWLAnnotation> NO_ANNOTATIONS = Collections.emptySet();
    protected static final IntBinaryOperator hashIteration = (a, b) -> a * 37 + b;
    protected static LoadingCache<OWLObjectImpl, Set<OWLEntity>> signatures = OWLObjectImpl.build(key -> key.addSignatureEntitiesToSet(new TreeSet()));
    protected static LoadingCache<OWLObjectImpl, Set<OWLAnonymousIndividual>> anonCaches = OWLObjectImpl.build(key -> key.addAnonymousIndividualsToSet(new TreeSet()));
    protected static LoadingCache<OWLObjectImpl, List<OWLClass>> classesSignatures = OWLObjectImpl.build(key -> OWLObjectImpl.cacheSig(key, AsOWLClass::isOWLClass, AsOWLClass::asOWLClass));
    protected static LoadingCache<OWLObjectImpl, List<OWLDataProperty>> dataPropertySignatures = OWLObjectImpl.build(key -> OWLObjectImpl.cacheSig(key, AsOWLDataProperty::isOWLDataProperty, AsOWLDataProperty::asOWLDataProperty));
    protected static LoadingCache<OWLObjectImpl, List<OWLObjectProperty>> objectPropertySignatures = OWLObjectImpl.build(key -> OWLObjectImpl.cacheSig(key, AsOWLObjectProperty::isOWLObjectProperty, AsOWLObjectProperty::asOWLObjectProperty));
    protected static LoadingCache<OWLObjectImpl, List<OWLDatatype>> datatypeSignatures = OWLObjectImpl.build(key -> OWLObjectImpl.cacheSig(key, AsOWLDatatype::isOWLDatatype, AsOWLDatatype::asOWLDatatype));
    protected static LoadingCache<OWLObjectImpl, List<OWLNamedIndividual>> individualSignatures = OWLObjectImpl.build(key -> OWLObjectImpl.cacheSig(key, AsOWLNamedIndividual::isOWLNamedIndividual, AsOWLNamedIndividual::asOWLNamedIndividual));
    protected static LoadingCache<OWLObjectImpl, List<OWLAnnotationProperty>> annotationPropertiesSignatures = OWLObjectImpl.build(key -> OWLObjectImpl.cacheSig(key, AsOWLAnnotationProperty::isOWLAnnotationProperty, AsOWLAnnotationProperty::asOWLAnnotationProperty));
    protected int hashCode = 0;

    static <Q, T> LoadingCache<Q, T> build(CacheLoader<Q, T> c) {
        return Caffeine.newBuilder().weakKeys().softValues().build(c);
    }

    static <T> List<T> cacheSig(OWLObject o, Predicate<OWLEntity> p, Function<OWLEntity, T> f) {
        return OWLAPIStreamUtils.asList(o.signature().filter(p).map(f));
    }

    static int hash(int start, Stream<?> s) {
        return ((Stream)s.sequential()).mapToInt(OWLObjectImpl::hash).reduce(start, hashIteration);
    }

    private static int hash(Object o) {
        if (o instanceof Stream) {
            return ((Stream)o).mapToInt(Object::hashCode).sum();
        }
        return o.hashCode();
    }

    protected int hashCode(OWLObject object) {
        return OWLObjectImpl.hash(object.hashIndex(), object.components());
    }

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return ((Set)anonCaches.get((Object)this)).stream();
    }

    public Stream<OWLEntity> signature() {
        return ((Set)signatures.get((Object)this)).stream();
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return ((Set)signatures.get((Object)this)).contains(owlEntity);
    }

    public Stream<OWLClass> classesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)classesSignatures.get((Object)this)));
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)dataPropertySignatures.get((Object)this)));
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)objectPropertySignatures.get((Object)this)));
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)individualSignatures.get((Object)this)));
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)datatypeSignatures.get((Object)this)));
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)annotationPropertiesSignatures.get((Object)this)));
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        return ((Collection)this.accept((OWLObjectVisitorEx)new OWLClassExpressionCollector())).stream();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLObject)) {
            return false;
        }
        OWLObject other = (OWLObject)obj;
        if (this.typeIndex() != other.typeIndex()) {
            return false;
        }
        return OWLAPIStreamUtils.equalStreams((Stream)this.components(), (Stream)other.components());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.hashCode(this);
        }
        return this.hashCode;
    }

    public int compareTo(@Nullable OWLObject o) {
        OWLAPIPreconditions.checkNotNull((Object)o);
        assert (o != null);
        int diff = Integer.compare(this.typeIndex(), o.typeIndex());
        if (diff != 0) {
            return diff;
        }
        return OWLAPIStreamUtils.compareIterators(this.components().iterator(), o.components().iterator());
    }

    protected int compareAnnotations(List<OWLAnnotation> l1, List<OWLAnnotation> l2) {
        int i;
        for (i = 0; i < l1.size() && i < l2.size(); ++i) {
            int diff = l1.get(i).compareTo((Object)l2.get(i));
            if (diff == 0) continue;
            return diff;
        }
        if (i < l2.size()) {
            return -1;
        }
        if (i < l1.size()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return ToStringRenderer.getRendering((OWLObject)this);
    }
}

