/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.model;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.oboformat.model.FrameStructureException;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clause {
    private static final Logger LOGGER = LoggerFactory.getLogger(Clause.class);
    private static final Set<?> trueValues = Sets.newHashSet((Object[])new Serializable[]{Boolean.TRUE, "true"});
    private static final Set<?> falseValues = Sets.newHashSet((Object[])new Serializable[]{Boolean.FALSE, "false"});
    @Nullable
    protected String tag;
    @Nonnull
    protected List<Object> values = new ArrayList<Object>();
    @Nonnull
    protected Collection<Xref> xrefs = new ArrayList<Xref>();
    @Nonnull
    protected Collection<QualifierValue> qualifierValues = new ArrayList<QualifierValue>();

    public Clause(OBOFormatConstants.OboFormatTag tag) {
        this(tag.getTag());
    }

    public Clause(@Nullable String tag) {
        this.tag = tag;
    }

    public Clause(@Nullable String tag, String value) {
        this(tag);
        this.setValue(value);
    }

    public Clause(OBOFormatConstants.OboFormatTag tag, String value) {
        this(tag.getTag(), value);
    }

    @Deprecated
    public Clause() {
    }

    public Clause withValue(String value) {
        this.setValue(value);
        return this;
    }

    void freeze() {
        this.freezeValues();
        this.freezeXrefs();
        this.freezeQualifiers();
    }

    void freezeValues() {
        switch (this.values.size()) {
            case 0: {
                this.values = Collections.emptyList();
                break;
            }
            case 1: {
                Object o = this.values.iterator().next();
                this.values = Collections.singletonList(o);
                break;
            }
            default: {
                ((ArrayList)this.values).trimToSize();
            }
        }
    }

    void freezeXrefs() {
        switch (this.xrefs.size()) {
            case 0: {
                this.xrefs = Collections.emptyList();
                break;
            }
            case 1: {
                Xref xref = this.xrefs.iterator().next();
                this.xrefs = Collections.singletonList(xref);
                break;
            }
            default: {
                if (!(this.xrefs instanceof ArrayList)) break;
                ((ArrayList)this.xrefs).trimToSize();
            }
        }
    }

    void freezeQualifiers() {
        switch (this.qualifierValues.size()) {
            case 0: {
                this.qualifierValues = Collections.emptyList();
                break;
            }
            case 1: {
                QualifierValue qualifierValue = this.qualifierValues.iterator().next();
                this.qualifierValues = Collections.singletonList(qualifierValue);
                break;
            }
            default: {
                if (!(this.qualifierValues instanceof ArrayList)) break;
                ((ArrayList)this.qualifierValues).trimToSize();
            }
        }
    }

    public boolean hasNoAnnotations() {
        return this.xrefs.isEmpty() && this.qualifierValues.isEmpty();
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Collection<Object> getValues() {
        return this.values;
    }

    public void setValues(Collection<Object> values) {
        if (!(this.values instanceof ArrayList)) {
            switch (values.size()) {
                case 0: {
                    this.values = Collections.emptyList();
                    break;
                }
                case 1: {
                    Object o = values.iterator().next();
                    this.values = Collections.singletonList(o);
                    break;
                }
                default: {
                    this.values = new ArrayList<Object>(values);
                    break;
                }
            }
        } else {
            this.values.clear();
            this.values.addAll(values);
        }
    }

    public void setValue(Object v) {
        if (this.values instanceof ArrayList) {
            this.values.clear();
            this.values.add(v);
        } else {
            this.values = Collections.singletonList(v);
        }
    }

    public void addValue(@Nullable Object v) {
        if (!(this.values instanceof ArrayList)) {
            ArrayList<Object> newValues = new ArrayList<Object>(this.values.size() + 1);
            newValues.addAll(this.values);
            this.values = newValues;
        }
        this.values.add(v);
    }

    public Object getValue() {
        Object value = null;
        if (!this.values.isEmpty()) {
            value = this.values.get(0);
        }
        if (value == null) {
            LOGGER.error("Cannot translate: {}", (Object)this);
            throw new FrameStructureException("Clause value is null: " + this);
        }
        return value;
    }

    public <T> T getValue(Class<T> cls) {
        Object value = this.getValue();
        return cls.cast(value);
    }

    public Object getValue2() {
        Object value = null;
        if (this.values.size() > 1) {
            value = this.values.get(1);
        }
        if (value == null) {
            LOGGER.error("Cannot translate: {}", (Object)this);
            throw new FrameStructureException("Clause second value is null: " + this);
        }
        return value;
    }

    public <T> T getValue2(Class<T> cls) {
        Object value = this.getValue2();
        return cls.cast(value);
    }

    public Collection<Xref> getXrefs() {
        return this.xrefs;
    }

    public void setXrefs(Collection<Xref> xrefs) {
        if (!(this.xrefs instanceof ArrayList)) {
            switch (xrefs.size()) {
                case 0: {
                    this.xrefs = Collections.emptyList();
                    break;
                }
                case 1: {
                    Xref xref = xrefs.iterator().next();
                    this.xrefs = Collections.singletonList(xref);
                    break;
                }
                default: {
                    this.xrefs = new ArrayList<Xref>(xrefs);
                    break;
                }
            }
        } else {
            this.xrefs.clear();
            this.xrefs.addAll(xrefs);
        }
    }

    public void addXref(Xref xref) {
        if (!(this.xrefs instanceof ArrayList)) {
            ArrayList<Xref> newXrefs = new ArrayList<Xref>(this.xrefs.size() + 1);
            newXrefs.addAll(this.xrefs);
            this.xrefs = newXrefs;
        }
        this.xrefs.add(xref);
    }

    public Collection<QualifierValue> getQualifierValues() {
        return this.qualifierValues;
    }

    public void setQualifierValues(Collection<QualifierValue> qualifierValues) {
        if (!(this.qualifierValues instanceof ArrayList)) {
            switch (qualifierValues.size()) {
                case 0: {
                    this.qualifierValues = Collections.emptyList();
                    break;
                }
                case 1: {
                    QualifierValue qualifierValue = qualifierValues.iterator().next();
                    this.qualifierValues = Collections.singletonList(qualifierValue);
                    break;
                }
                default: {
                    this.qualifierValues = new ArrayList<QualifierValue>(qualifierValues);
                    break;
                }
            }
        } else {
            this.qualifierValues.clear();
            this.qualifierValues.addAll(qualifierValues);
        }
    }

    public void addQualifierValue(QualifierValue qv) {
        if (!(this.qualifierValues instanceof ArrayList)) {
            ArrayList<QualifierValue> newQualifierValues = new ArrayList<QualifierValue>(this.qualifierValues.size() + 1);
            newQualifierValues.addAll(this.qualifierValues);
            this.qualifierValues = newQualifierValues;
        }
        this.qualifierValues.add(qv);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.tag);
        sb.append('(');
        for (Object ob : this.values) {
            sb.append(' ');
            sb.append(ob);
        }
        if (!this.qualifierValues.isEmpty()) {
            sb.append('{');
            for (QualifierValue qv : this.qualifierValues) {
                sb.append(qv);
                sb.append(' ');
            }
            sb.append('}');
        }
        if (!this.xrefs.isEmpty()) {
            sb.append('[');
            for (Xref x : this.xrefs) {
                sb.append(x);
                sb.append(' ');
            }
            sb.append(']');
        }
        sb.append(')');
        return sb.toString();
    }

    private static boolean collectionsEquals(@Nullable Collection<?> c1, @Nullable Collection<?> c2) {
        if (c1 == null || c1.isEmpty()) {
            return c2 == null || c2.isEmpty();
        }
        if (c2 == null || c1.size() != c2.size()) {
            return false;
        }
        return Clause.checkContents(c1, c2);
    }

    protected static boolean checkContents(Collection<?> c1, Collection<?> c2) {
        HashSet s = new HashSet(c2);
        for (Object x : c1) {
            if (s.contains(x)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 29791 * this.qualifierValues.hashCode() + 31 * this.xrefs.hashCode() + 961 * this.values.hashCode() + this.taghash();
    }

    private int taghash() {
        if (this.tag == null) {
            return 0;
        }
        assert (this.tag != null);
        return this.tag.hashCode();
    }

    private boolean tag(@Nullable String otherTag) {
        if (this.tag == null) {
            return otherTag == null;
        }
        assert (this.tag != null);
        return this.tag.equals(otherTag);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof Clause)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Clause other = (Clause)obj;
        if (!this.tag(other.tag)) {
            return false;
        }
        if (this.getValues().size() == 1 && other.getValues().size() == 1 ? !this.compareValues(other) : !this.getValues().equals(other.getValues())) {
            return false;
        }
        if (!Clause.collectionsEquals(this.xrefs, other.getXrefs())) {
            return false;
        }
        return Clause.collectionsEquals(this.qualifierValues, other.getQualifierValues());
    }

    protected boolean compareValues(Clause other) {
        try {
            Object v1 = this.getValue();
            Object v2 = other.getValue();
            if (v1 != v2 && !v1.equals(v2)) {
                return trueValues.contains(v1) && trueValues.contains(v2) || falseValues.contains(v1) && falseValues.contains(v2);
            }
        }
        catch (FrameStructureException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

