/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class Obo2OWLConstants {
    public static final String DEFAULT_IRI_PREFIX = "http://purl.obolibrary.org/obo/";
    public static final String OIOVOCAB_IRI_PREFIX = "http://www.geneontology.org/formats/oboInOwl#";
    public static final IRI IRI_IAO_0000231 = IRI.create((String)"http://purl.obolibrary.org/obo/", (String)"IAO_0000231");
    public static final IRI IRI_IAO_0000227 = IRI.create((String)"http://purl.obolibrary.org/obo/", (String)"IAO_0000227");
    private static final Map<String, Obo2OWLVocabulary> TAGSTOVOCAB = Stream.of(Obo2OWLVocabulary.values()).collect(Collectors.toMap(Obo2OWLVocabulary::getMappedTag, Function.identity()));

    @Nullable
    public static Obo2OWLVocabulary getVocabularyObj(String tag) {
        return TAGSTOVOCAB.get(tag);
    }

    public static enum Obo2OWLVocabulary implements HasIRI
    {
        IRI_IAO_0000424("http://purl.obolibrary.org/obo/", "IAO_0000424", "expand expression to", OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag()),
        IRI_IAO_0000425("http://purl.obolibrary.org/obo/", "IAO_0000425", "expand assertion to", OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag()),
        IRI_IAO_0000115("http://purl.obolibrary.org/obo/", "IAO_0000115", "definition", OBOFormatConstants.OboFormatTag.TAG_DEF.getTag()),
        IRI_IAO_0000427("http://purl.obolibrary.org/obo/", "IAO_0000427", "antisymmetric property", OBOFormatConstants.OboFormatTag.TAG_IS_ANTI_SYMMETRIC.getTag()),
        IRI_IAO_0100001("http://purl.obolibrary.org/obo/", "IAO_0100001", "term replaced by", OBOFormatConstants.OboFormatTag.TAG_REPLACED_BY.getTag()),
        IRI_OIO_shorthand("http://www.geneontology.org/formats/oboInOwl#", "shorthand", "shorthand", "shorthand"),
        IRI_OIO_consider("http://www.geneontology.org/formats/oboInOwl#", "consider", "consider", OBOFormatConstants.OboFormatTag.TAG_CONSIDER.getTag()),
        IRI_OIO_hasOBOFormatVersion("http://www.geneontology.org/formats/oboInOwl#", "hasOBOFormatVersion", "has_obo_format_version", OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag()),
        IRI_OIO_treatXrefsAsIsA("http://www.geneontology.org/formats/oboInOwl#", "treat-xrefs-as-is_a", "treat-xrefs-as-is_a", OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_IS_A.getTag()),
        IRI_OIO_treatXrefsAsHasSubClass("http://www.geneontology.org/formats/oboInOwl#", "treat-xrefs-as-has-subclass", "treat-xrefs-as-has-subclass", OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_HAS_SUBCLASS.getTag()),
        IRI_OIO_treatXrefsAsRelationship("http://www.geneontology.org/formats/oboInOwl#", "treat-xrefs-as-relationship", "treat-xrefs-as-relationship", OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_RELATIONSHIP.getTag()),
        IRI_OIO_treatXrefsAsGenusDifferentia("http://www.geneontology.org/formats/oboInOwl#", "treat-xrefs-as-genus-differentia", "treat-xrefs-as-genus-differentia", OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_GENUS_DIFFERENTIA.getTag()),
        IRI_OIO_treatXrefsAsReverseGenusDifferentia("http://www.geneontology.org/formats/oboInOwl#", "treat-xrefs-as-reverse-genus-differentia", "treat-xrefs-as-reverse-genus-differentia", OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_REVERSE_GENUS_DIFFERENTIA.getTag()),
        IRI_OIO_treatXrefsAsEquivalent("http://www.geneontology.org/formats/oboInOwl#", "treat-xrefs-as-equivalent", "treat-xrefs-as-equivalent", OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_EQUIVALENT.getTag()),
        IRI_OIO_hasOboNamespace("http://www.geneontology.org/formats/oboInOwl#", "hasOBONamespace", "has_obo_namespace", OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag()),
        IRI_OIO_hasDbXref("http://www.geneontology.org/formats/oboInOwl#", "hasDbXref", "database_cross_reference", OBOFormatConstants.OboFormatTag.TAG_XREF.getTag()),
        hasAlternativeId("http://www.geneontology.org/formats/oboInOwl#", "hasAlternativeId", "has_alternative_id", OBOFormatConstants.OboFormatTag.TAG_ALT_ID.getTag()),
        IRI_OIO_inSubset("http://www.geneontology.org/formats/oboInOwl#", "inSubset", "in_subset", OBOFormatConstants.OboFormatTag.TAG_SUBSET.getTag()),
        IRI_OIO_hasScope("http://www.geneontology.org/formats/oboInOwl#", "hasScope", "has_scope", OBOFormatConstants.OboFormatTag.TAG_SCOPE.getTag()),
        IRI_OIO_hasBroadSynonym("http://www.geneontology.org/formats/oboInOwl#", "hasBroadSynonym", "has_broad_synonym", OBOFormatConstants.OboFormatTag.TAG_BROAD.getTag()),
        IRI_OIO_hasNarrowSynonym("http://www.geneontology.org/formats/oboInOwl#", "hasNarrowSynonym", "has_narrow_synonym", OBOFormatConstants.OboFormatTag.TAG_NARROW.getTag()),
        IRI_OIO_hasExactSynonym("http://www.geneontology.org/formats/oboInOwl#", "hasExactSynonym", "has_exact_synonym", OBOFormatConstants.OboFormatTag.TAG_EXACT.getTag()),
        IRI_OIO_hasRelatedSynonym("http://www.geneontology.org/formats/oboInOwl#", "hasRelatedSynonym", "has_related_synonym", OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag()),
        hasSynonymType("http://www.geneontology.org/formats/oboInOwl#", "hasSynonymType", "has_synonym_type", OBOFormatConstants.OboFormatTag.TAG_HAS_SYNONYM_TYPE.getTag()),
        IRI_OIO_Subset("http://www.geneontology.org/formats/oboInOwl#", "SubsetProperty", "subset_property", OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag()),
        IRI_OIO_SynonymType("http://www.geneontology.org/formats/oboInOwl#", "SynonymTypeProperty", "synonym_type_property", OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag()),
        IRI_OIO_NamespaceIdRule("http://www.geneontology.org/formats/oboInOwl#", "NamespaceIdRule", "namespace-id-rule", OBOFormatConstants.OboFormatTag.TAG_NAMESPACE_ID_RULE.getTag()),
        IRI_OIO_LogicalDefinitionViewRelation("http://www.geneontology.org/formats/oboInOwl#", "logical-definition-view-relation", "logical-definition-view-relation", OBOFormatConstants.OboFormatTag.TAG_LOGICAL_DEFINITION_VIEW_RELATION.getTag());

        final IRI iri;
        final String namespace;
        final String shortName;
        final String label;
        final String mappedTag;

        private Obo2OWLVocabulary(String namespce, String shortName, String label, String mappedTag) {
            this.iri = IRI.create((String)namespce, (String)shortName);
            this.shortName = shortName;
            this.namespace = namespce;
            this.label = label;
            this.mappedTag = mappedTag;
        }

        public static String format(Date d) {
            return OBOFormatConstants.headerDateFormat().format(d);
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public IRI getIRI() {
            return this.iri;
        }

        public String getLabel() {
            return this.label;
        }

        public String getMappedTag() {
            return this.mappedTag;
        }

        public boolean sameIRI(@Nullable OWLEntity e) {
            if (e == null) {
                return false;
            }
            return this.iri.equals((Object)e.getIRI());
        }
    }
}

