/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.obolibrary.macro.AbstractMacroExpansionVisitor;
import org.obolibrary.macro.ManchesterSyntaxTool;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OntologyAxiomPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionGCIVisitor {
    protected static final Logger LOG = LoggerFactory.getLogger((String)MacroExpansionGCIVisitor.class.getName());
    protected final OWLOntology inputOntology;
    private final OWLOntologyManager outputManager;
    private final OWLOntology outputOntology;
    protected final ManchesterSyntaxTool manchesterSyntaxTool;
    protected final boolean shouldAddExpansionMarker;
    protected boolean preserveAnnotationsWhenExpanding = false;

    public MacroExpansionGCIVisitor(OWLOntology inputOntology, OWLOntologyManager outputManager, boolean preserveAnnotationsWhenExpanding) {
        this(outputManager, inputOntology, false);
        this.preserveAnnotationsWhenExpanding = preserveAnnotationsWhenExpanding;
    }

    public MacroExpansionGCIVisitor(OWLOntologyManager outputManager, OWLOntology inputOntology, boolean shouldAddExpansionMarker) {
        this.inputOntology = inputOntology;
        this.shouldAddExpansionMarker = shouldAddExpansionMarker;
        this.manchesterSyntaxTool = new ManchesterSyntaxTool(inputOntology);
        this.outputManager = outputManager;
        try {
            this.outputOntology = outputManager.createOntology(inputOntology.getOntologyID());
        }
        catch (Exception ex) {
            throw new OWLRuntimeException(ex);
        }
    }

    protected void output(OWLAxiom axiom) {
        if (axiom == null) {
            LOG.error("no axiom");
            return;
        }
        AddAxiom addAx = new AddAxiom(this.outputOntology, axiom);
        try {
            this.outputManager.applyChange(addAx);
        }
        catch (Exception e) {
            LOG.error("COULD NOT TRANSLATE AXIOM", (Throwable)e);
        }
    }

    public OWLOntology createGCIOntology() {
        MacroExpansions expansions = new MacroExpansions();
        this.outputManager.addAxioms(this.outputOntology, expansions.getNewAxioms());
        this.outputManager.removeAxioms(this.outputOntology, expansions.getRmAxioms());
        return this.outputOntology;
    }

    public boolean shouldPreserveAnnotationsWhenExpanding() {
        return this.preserveAnnotationsWhenExpanding;
    }

    public void setPreserveAnnotationsWhenExpanding(boolean preserveAnnotationsWhenExpanding) {
        this.preserveAnnotationsWhenExpanding = preserveAnnotationsWhenExpanding;
    }

    public void dispose() {
        this.manchesterSyntaxTool.dispose();
    }

    private class MacroExpansions {
        protected Set<OWLAxiom> newAxioms = new HashSet<OWLAxiom>();
        private Set<OWLAxiom> rmAxioms = new HashSet<OWLAxiom>();
        GCIVisitor visitor;

        public MacroExpansions() {
            OWLAxiom oWLAxiom;
            this.visitor = new GCIVisitor(MacroExpansionGCIVisitor.this.inputOntology);
            for (OWLSubClassOfAxiom oWLSubClassOfAxiom : MacroExpansionGCIVisitor.this.inputOntology.getAxioms(AxiomType.SUBCLASS_OF)) {
                oWLAxiom = this.visitor.visit(oWLSubClassOfAxiom);
            }
            for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : MacroExpansionGCIVisitor.this.inputOntology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
                oWLAxiom = this.visitor.visit(oWLEquivalentClassesAxiom);
            }
            for (OWLClassAssertionAxiom oWLClassAssertionAxiom : MacroExpansionGCIVisitor.this.inputOntology.getAxioms(AxiomType.CLASS_ASSERTION)) {
                oWLAxiom = this.visitor.visit(oWLClassAssertionAxiom);
            }
            for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : MacroExpansionGCIVisitor.this.inputOntology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
                if (!this.expand(oWLAnnotationAssertionAxiom)) continue;
            }
        }

        public Set<OWLAxiom> getNewAxioms() {
            return this.newAxioms;
        }

        public Set<OWLAxiom> getRmAxioms() {
            return this.rmAxioms;
        }

        private boolean expand(OWLAnnotationAssertionAxiom ax) {
            OWLAnnotationProperty prop = ax.getProperty();
            boolean didExpansion = false;
            String expandTo = (String)this.visitor.expandAssertionToMap.get(prop.getIRI());
            if (expandTo != null) {
                LOG.info("Template to Expand {}", (Object)expandTo);
                expandTo = expandTo.replaceAll("\\?X", MacroExpansionGCIVisitor.this.manchesterSyntaxTool.getId((IRI)ax.getSubject()));
                expandTo = expandTo.replaceAll("\\?Y", MacroExpansionGCIVisitor.this.manchesterSyntaxTool.getId((IRI)ax.getValue()));
                LOG.info("Expanding {}", (Object)expandTo);
                try {
                    Set<OntologyAxiomPair> setAxp = MacroExpansionGCIVisitor.this.manchesterSyntaxTool.parseManchesterExpressionFrames(expandTo);
                    for (OntologyAxiomPair axp : setAxp) {
                        OWLAxiom axiom = axp.getAxiom();
                        if (MacroExpansionGCIVisitor.this.shouldPreserveAnnotationsWhenExpanding()) {
                            Set<OWLAnnotation> annotationsWithOptionalExpansionMarker = this.visitor.getAnnotationsWithOptionalExpansionMarker(ax);
                            axiom = axiom.getAnnotatedAxiom(annotationsWithOptionalExpansionMarker);
                        }
                        this.newAxioms.add(axiom);
                        didExpansion = true;
                    }
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return didExpansion;
        }

        private class GCIVisitor
        extends AbstractMacroExpansionVisitor {
            final Set<OWLAnnotation> expansionMarkingAnnotations;

            GCIVisitor(OWLOntology inputOntology) {
                super(inputOntology, MacroExpansionGCIVisitor.this.shouldAddExpansionMarker);
                this.expansionMarkingAnnotations = MacroExpansionGCIVisitor.this.shouldAddExpansionMarker ? Collections.singleton(this.expansionMarkerAnnotation) : EMPTY_ANNOTATIONS;
            }

            @Override
            protected OWLClassExpression expandOWLObjSomeVal(OWLClassExpression filler, OWLObjectPropertyExpression p) {
                OWLClassExpression gciRHS = this.expandObject(filler, p);
                if (gciRHS != null) {
                    OWLObjectSomeValuesFrom gciLHS = this.dataFactory.getOWLObjectSomeValuesFrom(p, filler);
                    OWLEquivalentClassesAxiom ax = this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)gciLHS, gciRHS, this.expansionMarkingAnnotations);
                    MacroExpansions.this.newAxioms.add(ax);
                }
                return gciRHS;
            }

            @Override
            protected OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue desc, OWLIndividual filler, OWLObjectPropertyExpression p) {
                OWLClassExpression gciRHS = this.expandObject(filler, p);
                if (gciRHS != null) {
                    OWLObjectHasValue gciLHS = this.dataFactory.getOWLObjectHasValue(p, filler);
                    OWLEquivalentClassesAxiom ax = this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)gciLHS, gciRHS, this.expansionMarkingAnnotations);
                    MacroExpansions.this.newAxioms.add(ax);
                }
                return gciRHS;
            }

            private OWLClassExpression expandObject(Object filler, OWLObjectPropertyExpression p) {
                OWLClassExpression result = null;
                IRI iri = ((OWLObjectProperty)p).getIRI();
                IRI templateVal = null;
                if (this.expandExpressionMap.containsKey(iri)) {
                    OWLIndividual ind;
                    Set<OWLIndividual> inds;
                    if (filler instanceof OWLObjectOneOf && (inds = ((OWLObjectOneOf)filler).getIndividuals()).size() == 1 && (ind = inds.iterator().next()) instanceof OWLNamedIndividual) {
                        templateVal = ((OWLNamedObject)((Object)ind)).getIRI();
                    }
                    if (filler instanceof OWLNamedObject) {
                        templateVal = ((OWLNamedObject)filler).getIRI();
                    }
                    if (templateVal != null) {
                        String tStr = (String)this.expandExpressionMap.get(iri);
                        String exStr = tStr.replaceAll("\\?Y", MacroExpansionGCIVisitor.this.manchesterSyntaxTool.getId(templateVal));
                        try {
                            result = MacroExpansionGCIVisitor.this.manchesterSyntaxTool.parseManchesterExpression(exStr);
                        }
                        catch (OWLParserException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                return result;
            }
        }
    }
}

