/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.renderer;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.util.CollectionFactory;

public class ParserException
extends OWLParserException {
    private static final long serialVersionUID = 40000L;
    private String currentToken;
    private final int lineNumber;
    private final int columnNumber;
    private final List<String> tokenSequence;
    private boolean classNameExpected = false;
    private boolean objectPropertyNameExpected = false;
    private boolean dataPropertyNameExpected = false;
    private boolean individualNameExpected = false;
    private boolean datatypeNameExpected = false;
    private boolean integerExpected = false;
    private boolean annotationPropertyExpected = false;
    private boolean ontologyNameExpected = false;
    private final Set<String> expectedKeywords = new LinkedHashSet<String>();
    private final int startPos;

    public ParserException(String message, List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, boolean ontologyNameExpected, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyExpected, boolean integerExpected, Set<String> expectedKeywords) {
        this(message, tokenSequence, startPos, lineNumber, columnNumber, classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, annotationPropertyExpected, expectedKeywords);
        this.ontologyNameExpected = ontologyNameExpected;
        this.integerExpected = integerExpected;
    }

    public ParserException(List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, boolean ontologyNameExpected, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyExpected, boolean integerExpected, Set<String> expectedKeywords) {
        this(tokenSequence, startPos, lineNumber, columnNumber, classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, annotationPropertyExpected, expectedKeywords);
        this.ontologyNameExpected = ontologyNameExpected;
        this.integerExpected = integerExpected;
    }

    public ParserException(String message, List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyExpected, @Nullable Set<String> expectedKeywords) {
        super(message);
        this.currentToken = tokenSequence.iterator().next();
        this.currentToken = tokenSequence.iterator().next();
        this.tokenSequence = tokenSequence;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.classNameExpected = classNameExpected;
        this.objectPropertyNameExpected = objectPropertyNameExpected;
        this.dataPropertyNameExpected = dataPropertyNameExpected;
        this.individualNameExpected = individualNameExpected;
        this.datatypeNameExpected = datatypeNameExpected;
        this.annotationPropertyExpected = annotationPropertyExpected;
        if (expectedKeywords != null) {
            this.expectedKeywords.addAll(expectedKeywords);
        }
        this.startPos = startPos;
    }

    public ParserException(List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyExpected, @Nullable Set<String> expectedKeywords) {
        this.currentToken = tokenSequence.iterator().next();
        this.currentToken = tokenSequence.iterator().next();
        this.tokenSequence = tokenSequence;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.classNameExpected = classNameExpected;
        this.objectPropertyNameExpected = objectPropertyNameExpected;
        this.dataPropertyNameExpected = dataPropertyNameExpected;
        this.individualNameExpected = individualNameExpected;
        this.datatypeNameExpected = datatypeNameExpected;
        this.annotationPropertyExpected = annotationPropertyExpected;
        if (expectedKeywords != null) {
            this.expectedKeywords.addAll(expectedKeywords);
        }
        this.startPos = startPos;
    }

    public ParserException(String message, List<String> tokenSeqence, int startPos, int lineNumber, int columnNumber, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyExpected, String ... keywords) {
        this(message, tokenSeqence, startPos, lineNumber, columnNumber, classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, annotationPropertyExpected, CollectionFactory.createSet(keywords));
    }

    public ParserException(List<String> tokenSeqence, int startPos, int lineNumber, int columnNumber, boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyExpected, String ... keywords) {
        this(tokenSeqence, startPos, lineNumber, columnNumber, classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, annotationPropertyExpected, CollectionFactory.createSet(keywords));
    }

    public ParserException(String message, List<String> tokenSequence, int lineNumber, int columnNumber, boolean integerExpected, int startPos) {
        this(message, tokenSequence, startPos, lineNumber, columnNumber, false, false, false, false, false, false, new HashSet<String>());
        this.integerExpected = integerExpected;
    }

    public ParserException(List<String> tokenSequence, int lineNumber, int columnNumber, boolean integerExpected, int startPos) {
        this(tokenSequence, startPos, lineNumber, columnNumber, false, false, false, false, false, false, new HashSet<String>());
        this.integerExpected = integerExpected;
    }

    public ParserException(String message, List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, String ... keywords) {
        this(message, tokenSequence, startPos, lineNumber, columnNumber, false, false, false, false, false, false, keywords);
    }

    public ParserException(List<String> tokenSequence, int startPos, int lineNumber, int columnNumber, String ... keywords) {
        this(tokenSequence, startPos, lineNumber, columnNumber, false, false, false, false, false, false, keywords);
    }

    public ParserException(ParserException delegate) {
        this(delegate.getMessage(), delegate.tokenSequence, delegate.startPos, delegate.lineNumber, delegate.columnNumber, delegate.ontologyNameExpected, delegate.classNameExpected, delegate.objectPropertyNameExpected, delegate.dataPropertyNameExpected, delegate.individualNameExpected, delegate.datatypeNameExpected, delegate.annotationPropertyExpected, delegate.integerExpected, delegate.expectedKeywords);
    }

    public List<String> getTokenSequence() {
        return this.tokenSequence;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public boolean isClassNameExpected() {
        return this.classNameExpected;
    }

    public boolean isObjectPropertyNameExpected() {
        return this.objectPropertyNameExpected;
    }

    public boolean isDataPropertyNameExpected() {
        return this.dataPropertyNameExpected;
    }

    public boolean isIndividualNameExpected() {
        return this.individualNameExpected;
    }

    public boolean isDatatypeNameExpected() {
        return this.datatypeNameExpected;
    }

    public boolean isAnnotationPropertyNameExpected() {
        return this.annotationPropertyExpected;
    }

    public boolean isOntologyNameExpected() {
        return this.ontologyNameExpected;
    }

    public Set<String> getExpectedKeywords() {
        return this.expectedKeywords;
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean isIntegerExpected() {
        return this.integerExpected;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Encountered ");
        sb.append(this.currentToken);
        sb.append(" at line ");
        sb.append(this.lineNumber);
        sb.append(" column ");
        sb.append(this.columnNumber);
        sb.append(". Expected one of:\n");
        if (this.ontologyNameExpected) {
            sb.append("\tOntology name\n");
        }
        if (this.classNameExpected) {
            sb.append("\tClass name\n");
        }
        if (this.objectPropertyNameExpected) {
            sb.append("\tObject property name\n");
        }
        if (this.dataPropertyNameExpected) {
            sb.append("\tData property name\n");
        }
        if (this.individualNameExpected) {
            sb.append("\tIndividual name\n");
        }
        if (this.datatypeNameExpected) {
            sb.append("\tDatatype name\n");
        }
        if (this.annotationPropertyExpected) {
            sb.append("\tAnnotation property\n");
        }
        if (this.integerExpected) {
            sb.append("\tInteger\n");
        }
        for (String kw : this.expectedKeywords) {
            sb.append('\t');
            sb.append(kw);
            sb.append('\n');
        }
        return sb.toString();
    }
}

