/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLObjectDesharer
implements OWLObjectVisitorEx<OWLObject> {
    private final OWLDataFactory df;

    public OWLObjectDesharer(OWLOntologyManager m) {
        this.df = m.getOWLDataFactory();
    }

    public <O extends OWLObject> O deshareObject(O object) {
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        return this.get(object);
    }

    private Set<OWLAnnotation> anns(HasAnnotations axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        return this.list(axiom.getAnnotations());
    }

    @Override
    public OWLAsymmetricObjectPropertyAxiom visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.anns(axiom));
    }

    @Override
    public OWLClassAssertionAxiom visit(OWLClassAssertionAxiom axiom) {
        return this.df.getOWLClassAssertionAxiom(this.get(axiom.getClassExpression()), this.get(axiom.getIndividual()), this.anns(axiom));
    }

    @Override
    public OWLDataPropertyAssertionAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
        return this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.get(axiom.getProperty()), this.get(axiom.getSubject()), (OWLLiteral)this.get(axiom.getObject()), this.anns(axiom));
    }

    @Override
    public OWLDataPropertyDomainAxiom visit(OWLDataPropertyDomainAxiom axiom) {
        return this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.get(axiom.getProperty()), this.get(axiom.getDomain()), this.anns(axiom));
    }

    @Override
    public OWLDataPropertyRangeAxiom visit(OWLDataPropertyRangeAxiom axiom) {
        return this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.get(axiom.getProperty()), (OWLDataRange)this.get(axiom.getRange()), this.anns(axiom));
    }

    @Override
    public OWLSubDataPropertyOfAxiom visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.get((OWLObject)axiom.getSubProperty()), (OWLDataPropertyExpression)this.get((OWLObject)axiom.getSuperProperty()), this.anns(axiom));
    }

    @Override
    public OWLDeclarationAxiom visit(OWLDeclarationAxiom axiom) {
        return this.df.getOWLDeclarationAxiom(this.get(axiom.getEntity()), this.anns(axiom));
    }

    @Override
    public OWLDifferentIndividualsAxiom visit(OWLDifferentIndividualsAxiom axiom) {
        return this.df.getOWLDifferentIndividualsAxiom(this.list(axiom.getIndividuals()), this.anns(axiom));
    }

    @Override
    public OWLDisjointClassesAxiom visit(OWLDisjointClassesAxiom axiom) {
        return this.df.getOWLDisjointClassesAxiom(this.list(axiom.getClassExpressions()), this.anns(axiom));
    }

    @Override
    public OWLDisjointDataPropertiesAxiom visit(OWLDisjointDataPropertiesAxiom axiom) {
        return this.df.getOWLDisjointDataPropertiesAxiom(this.list(axiom.getProperties()), this.anns(axiom));
    }

    @Override
    public OWLDisjointObjectPropertiesAxiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return this.df.getOWLDisjointObjectPropertiesAxiom(this.list(axiom.getProperties()), this.anns(axiom));
    }

    @Override
    public OWLDisjointUnionAxiom visit(OWLDisjointUnionAxiom axiom) {
        return this.df.getOWLDisjointUnionAxiom(this.get(axiom.getOWLClass()), this.list(axiom.getClassExpressions()), this.anns(axiom));
    }

    @Override
    public OWLAnnotationAssertionAxiom visit(OWLAnnotationAssertionAxiom axiom) {
        return this.df.getOWLAnnotationAssertionAxiom(this.get(axiom.getProperty()), this.get(axiom.getSubject()), this.get(axiom.getValue()), this.anns(axiom));
    }

    @Override
    public OWLEquivalentClassesAxiom visit(OWLEquivalentClassesAxiom axiom) {
        return this.df.getOWLEquivalentClassesAxiom(this.list(axiom.getClassExpressions()), this.anns(axiom));
    }

    @Override
    public OWLEquivalentDataPropertiesAxiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return this.df.getOWLEquivalentDataPropertiesAxiom(this.list(axiom.getProperties()), this.anns(axiom));
    }

    @Override
    public OWLEquivalentObjectPropertiesAxiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return this.df.getOWLEquivalentObjectPropertiesAxiom(this.list(axiom.getProperties()), this.anns(axiom));
    }

    @Override
    public OWLFunctionalDataPropertyAxiom visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.get(axiom.getProperty()), this.anns(axiom));
    }

    @Override
    public OWLFunctionalObjectPropertyAxiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.anns(axiom));
    }

    @Override
    public OWLInverseFunctionalObjectPropertyAxiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.anns(axiom));
    }

    @Override
    public OWLInverseObjectPropertiesAxiom visit(OWLInverseObjectPropertiesAxiom axiom) {
        return this.df.getOWLInverseObjectPropertiesAxiom(this.get(axiom.getFirstProperty()), this.get(axiom.getSecondProperty()), this.anns(axiom));
    }

    @Override
    public OWLIrreflexiveObjectPropertyAxiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.anns(axiom));
    }

    @Override
    public OWLNegativeDataPropertyAssertionAxiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.get(axiom.getProperty()), this.get(axiom.getSubject()), (OWLLiteral)this.get(axiom.getObject()), this.anns(axiom));
    }

    @Override
    public OWLNegativeObjectPropertyAssertionAxiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.get(axiom.getSubject()), (OWLIndividual)this.get(axiom.getObject()), this.anns(axiom));
    }

    @Override
    public OWLObjectPropertyAssertionAxiom visit(OWLObjectPropertyAssertionAxiom axiom) {
        return this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.get(axiom.getSubject()), (OWLIndividual)this.get(axiom.getObject()), this.anns(axiom));
    }

    @Override
    public OWLSubPropertyChainOfAxiom visit(OWLSubPropertyChainOfAxiom axiom) {
        List<OWLObjectPropertyExpression> chain = this.asList(axiom.getPropertyChain());
        return this.df.getOWLSubPropertyChainOfAxiom(chain, this.get(axiom.getSuperProperty()), this.anns(axiom));
    }

    @Override
    public OWLObjectPropertyDomainAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.get(axiom.getDomain()), this.anns(axiom));
    }

    @Override
    public OWLObjectPropertyRangeAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), (OWLClassExpression)this.get(axiom.getRange()), this.anns(axiom));
    }

    @Override
    public OWLSubObjectPropertyOfAxiom visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.get((OWLObject)axiom.getSubProperty()), (OWLObjectPropertyExpression)this.get((OWLObject)axiom.getSuperProperty()), this.anns(axiom));
    }

    @Override
    public OWLReflexiveObjectPropertyAxiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.anns(axiom));
    }

    @Override
    public OWLSameIndividualAxiom visit(OWLSameIndividualAxiom axiom) {
        return this.df.getOWLSameIndividualAxiom(this.list(axiom.getIndividuals()), this.anns(axiom));
    }

    @Override
    public OWLSubClassOfAxiom visit(OWLSubClassOfAxiom axiom) {
        return this.df.getOWLSubClassOfAxiom(this.get(axiom.getSubClass()), this.get(axiom.getSuperClass()), this.anns(axiom));
    }

    @Override
    public OWLSymmetricObjectPropertyAxiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.anns(axiom));
    }

    @Override
    public OWLTransitiveObjectPropertyAxiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.get(axiom.getProperty()), this.anns(axiom));
    }

    @Override
    public OWLClass visit(OWLClass ce) {
        return ce;
    }

    @Override
    public OWLDataAllValuesFrom visit(OWLDataAllValuesFrom ce) {
        return this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.get(ce.getProperty()), (OWLDataRange)this.get(ce.getFiller()));
    }

    @Override
    public OWLDataExactCardinality visit(OWLDataExactCardinality ce) {
        return this.df.getOWLDataExactCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.get(ce.getProperty()), (OWLDataRange)this.get(ce.getFiller()));
    }

    @Override
    public OWLDataMaxCardinality visit(OWLDataMaxCardinality ce) {
        return this.df.getOWLDataMaxCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.get(ce.getProperty()), (OWLDataRange)this.get(ce.getFiller()));
    }

    @Override
    public OWLDataMinCardinality visit(OWLDataMinCardinality ce) {
        return this.df.getOWLDataMinCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.get(ce.getProperty()), (OWLDataRange)this.get(ce.getFiller()));
    }

    @Override
    public OWLDataSomeValuesFrom visit(OWLDataSomeValuesFrom ce) {
        return this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.get(ce.getProperty()), (OWLDataRange)this.get(ce.getFiller()));
    }

    @Override
    public OWLDataHasValue visit(OWLDataHasValue ce) {
        return this.df.getOWLDataHasValue((OWLDataPropertyExpression)this.get(ce.getProperty()), (OWLLiteral)this.get((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLObjectAllValuesFrom visit(OWLObjectAllValuesFrom ce) {
        return this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.get(ce.getProperty()), (OWLClassExpression)this.get(ce.getFiller()));
    }

    @Override
    public OWLObjectComplementOf visit(OWLObjectComplementOf ce) {
        return this.df.getOWLObjectComplementOf(this.get(ce.getOperand()));
    }

    @Override
    public OWLObjectExactCardinality visit(OWLObjectExactCardinality ce) {
        return this.df.getOWLObjectExactCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.get(ce.getProperty()), (OWLClassExpression)this.get(ce.getFiller()));
    }

    @Override
    public OWLObjectIntersectionOf visit(OWLObjectIntersectionOf ce) {
        return this.df.getOWLObjectIntersectionOf(this.list(ce.getOperands()));
    }

    @Override
    public OWLObjectMaxCardinality visit(OWLObjectMaxCardinality ce) {
        return this.df.getOWLObjectMaxCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.get(ce.getProperty()), (OWLClassExpression)this.get(ce.getFiller()));
    }

    @Override
    public OWLObjectMinCardinality visit(OWLObjectMinCardinality ce) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.get(ce.getProperty());
        return this.df.getOWLObjectMinCardinality(ce.getCardinality(), prop, (OWLClassExpression)this.get(ce.getFiller()));
    }

    @Override
    public OWLObjectOneOf visit(OWLObjectOneOf ce) {
        return this.df.getOWLObjectOneOf(this.list(ce.getIndividuals()));
    }

    @Override
    public OWLObjectHasSelf visit(OWLObjectHasSelf ce) {
        return this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)this.get(ce.getProperty()));
    }

    @Override
    public OWLObjectSomeValuesFrom visit(OWLObjectSomeValuesFrom ce) {
        return this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.get(ce.getProperty()), (OWLClassExpression)this.get(ce.getFiller()));
    }

    @Override
    public OWLObjectUnionOf visit(OWLObjectUnionOf ce) {
        return this.df.getOWLObjectUnionOf(this.list(ce.getOperands()));
    }

    @Override
    public OWLObjectHasValue visit(OWLObjectHasValue ce) {
        return this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.get(ce.getProperty()), (OWLIndividual)this.get((OWLObject)ce.getFiller()));
    }

    @Override
    public OWLDataComplementOf visit(OWLDataComplementOf node) {
        return this.df.getOWLDataComplementOf(this.get(node.getDataRange()));
    }

    @Override
    public OWLDataOneOf visit(OWLDataOneOf node) {
        return this.df.getOWLDataOneOf(this.list(node.getValues()));
    }

    @Override
    public OWLDatatype visit(OWLDatatype node) {
        return node;
    }

    @Override
    public OWLDatatypeRestriction visit(OWLDatatypeRestriction node) {
        return this.df.getOWLDatatypeRestriction(this.get(node.getDatatype()), this.list(node.getFacetRestrictions()));
    }

    @Override
    public OWLFacetRestriction visit(OWLFacetRestriction node) {
        return this.df.getOWLFacetRestriction(node.getFacet(), this.get(node.getFacetValue()));
    }

    @Override
    public OWLLiteral visit(OWLLiteral node) {
        return node;
    }

    @Override
    public OWLDataProperty visit(OWLDataProperty property) {
        return property;
    }

    @Override
    public OWLObjectProperty visit(OWLObjectProperty property) {
        return property;
    }

    @Override
    public OWLObjectInverseOf visit(OWLObjectInverseOf property) {
        OWLObjectPropertyExpression inverse = property.getInverse();
        if (inverse.isAnonymous()) {
            return this.df.getOWLObjectInverseOf(this.get(property.getNamedProperty()));
        }
        return this.df.getOWLObjectInverseOf(this.get(inverse.asOWLObjectProperty()));
    }

    @Override
    public OWLNamedIndividual visit(OWLNamedIndividual individual) {
        return individual;
    }

    @Override
    public OWLOntology visit(OWLOntology ontology) {
        return ontology;
    }

    @Override
    public SWRLRule visit(SWRLRule rule) {
        return this.df.getSWRLRule(this.list(rule.getBody()), this.list(rule.getHead()), this.anns(rule));
    }

    @Override
    public SWRLClassAtom visit(SWRLClassAtom node) {
        return this.df.getSWRLClassAtom(this.get(node.getPredicate()), (SWRLIArgument)this.get((OWLObject)node.getArgument()));
    }

    @Override
    public SWRLDataRangeAtom visit(SWRLDataRangeAtom node) {
        return this.df.getSWRLDataRangeAtom(this.get(node.getPredicate()), (SWRLDArgument)this.get((OWLObject)node.getArgument()));
    }

    @Override
    public SWRLObjectPropertyAtom visit(SWRLObjectPropertyAtom node) {
        return this.df.getSWRLObjectPropertyAtom(this.get(node.getPredicate()), (SWRLIArgument)this.get((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.get((OWLObject)node.getSecondArgument()));
    }

    @Override
    public SWRLDataPropertyAtom visit(SWRLDataPropertyAtom node) {
        return this.df.getSWRLDataPropertyAtom(this.get(node.getPredicate()), (SWRLIArgument)this.get((OWLObject)node.getFirstArgument()), (SWRLDArgument)this.get((OWLObject)node.getSecondArgument()));
    }

    @Override
    public SWRLBuiltInAtom visit(SWRLBuiltInAtom node) {
        return this.df.getSWRLBuiltInAtom(node.getPredicate(), this.asList(node.getArguments()));
    }

    @Override
    public SWRLDifferentIndividualsAtom visit(SWRLDifferentIndividualsAtom node) {
        return this.df.getSWRLDifferentIndividualsAtom((SWRLIArgument)this.get((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.get((OWLObject)node.getSecondArgument()));
    }

    @Override
    public SWRLSameIndividualAtom visit(SWRLSameIndividualAtom node) {
        return this.df.getSWRLSameIndividualAtom((SWRLIArgument)this.get((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.get((OWLObject)node.getSecondArgument()));
    }

    @Override
    public SWRLVariable visit(SWRLVariable node) {
        return this.df.getSWRLVariable(this.get(node.getIRI()));
    }

    @Override
    public SWRLIndividualArgument visit(SWRLIndividualArgument node) {
        return this.df.getSWRLIndividualArgument(this.get(node.getIndividual()));
    }

    @Override
    public SWRLLiteralArgument visit(SWRLLiteralArgument node) {
        return this.df.getSWRLLiteralArgument(this.get(node.getLiteral()));
    }

    @Override
    public OWLHasKeyAxiom visit(OWLHasKeyAxiom axiom) {
        return this.df.getOWLHasKeyAxiom(this.get(axiom.getClassExpression()), this.list(axiom.getPropertyExpressions()), this.anns(axiom));
    }

    @Override
    public OWLDataIntersectionOf visit(OWLDataIntersectionOf node) {
        return this.df.getOWLDataIntersectionOf(this.list(node.getOperands()));
    }

    @Override
    public OWLDataUnionOf visit(OWLDataUnionOf node) {
        return this.df.getOWLDataUnionOf(this.list(node.getOperands()));
    }

    @Override
    public OWLAnnotationProperty visit(OWLAnnotationProperty property) {
        return property;
    }

    @Override
    public OWLAnnotationPropertyDomainAxiom visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return this.df.getOWLAnnotationPropertyDomainAxiom(this.get(axiom.getProperty()), this.get(axiom.getDomain()), this.anns(axiom));
    }

    @Override
    public OWLAnnotationPropertyRangeAxiom visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return this.df.getOWLAnnotationPropertyRangeAxiom(this.get(axiom.getProperty()), this.get(axiom.getRange()), this.anns(axiom));
    }

    @Override
    public OWLSubAnnotationPropertyOfAxiom visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return this.df.getOWLSubAnnotationPropertyOfAxiom(this.get(axiom.getSubProperty()), this.get(axiom.getSuperProperty()), this.anns(axiom));
    }

    @Override
    public OWLAnnotation visit(OWLAnnotation node) {
        return this.df.getOWLAnnotation(this.get(node.getProperty()), this.get(node.getValue()), this.list(node.getAnnotations()));
    }

    @Override
    public OWLAnonymousIndividual visit(OWLAnonymousIndividual individual) {
        return individual;
    }

    @Override
    public IRI visit(IRI iri) {
        return iri;
    }

    @Override
    public OWLDatatypeDefinitionAxiom visit(OWLDatatypeDefinitionAxiom axiom) {
        return this.df.getOWLDatatypeDefinitionAxiom(this.get(axiom.getDatatype()), this.get(axiom.getDataRange()), this.anns(axiom));
    }

    protected <O extends OWLObject> Set<O> list(Collection<O> objects) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        for (OWLObject o : objects) {
            toReturn.add(this.get(o));
        }
        return toReturn;
    }

    protected <O extends OWLObject> List<O> asList(Collection<O> objects) {
        ArrayList<OWLObject> toReturn = new ArrayList<OWLObject>();
        for (OWLObject o : objects) {
            toReturn.add(this.get(o));
        }
        return toReturn;
    }

    protected <O extends OWLObject> O get(O o) {
        return (O)o.accept(this);
    }
}

