/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.FJTask;
import java.util.concurrent.FJWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.Mock;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TLRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.UnsafeAccess;
import java.util.concurrent.Utils;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import sun.misc.Unsafe;

class FJPool
extends AbstractExecutorService {
    static final int SWIDTH = 16;
    static final int SMASK = 65535;
    static final int MAX_CAP = Short.MAX_VALUE;
    static final int SQMASK = 126;
    static final int UNSIGNALLED = Integer.MIN_VALUE;
    static final int SS_SEQ = 65536;
    static final int QLOCK = 1;
    static final int OWNED = 1;
    static final int FIFO = 65536;
    static final int SHUTDOWN = 262144;
    static final int TERMINATED = 524288;
    static final int STOP = Integer.MIN_VALUE;
    static final int QUIET = 0x40000000;
    static final int DORMANT = -1073741824;
    static final int POLL_LIMIT = 1024;
    static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    static final RuntimePermission modifyThreadPermission;
    static final FJPool common;
    static final int COMMON_PARALLELISM;
    private static final int COMMON_MAX_SPARES;
    private static final long DEFAULT_KEEPALIVE = 60000L;
    private static final long TIMEOUT_SLOP = 20L;
    private static final int DEFAULT_COMMON_MAX_SPARES = 256;
    private static final int SEED_INCREMENT = -1640531527;
    private static final long SP_MASK = 0xFFFFFFFFL;
    private static final long UC_MASK = -4294967296L;
    private static final int RC_SHIFT = 48;
    private static final long RC_UNIT = 0x1000000000000L;
    private static final long RC_MASK = -281474976710656L;
    private static final int TC_SHIFT = 32;
    private static final long TC_UNIT = 0x100000000L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long ADD_WORKER = 0x800000000000L;
    volatile long pad00;
    volatile long pad01;
    volatile long pad02;
    volatile long pad03;
    volatile long pad04;
    volatile long pad05;
    volatile long pad06;
    volatile long pad07;
    volatile long pad08;
    volatile long pad09;
    volatile long pad0a;
    volatile long pad0b;
    volatile long pad0c;
    volatile long pad0d;
    volatile long pad0e;
    volatile long pad0f;
    volatile long ctl;
    volatile long pad10;
    volatile long pad11;
    volatile long pad12;
    volatile long pad13;
    volatile long pad14;
    volatile long pad15;
    volatile long pad16;
    volatile long pad17;
    volatile long pad18;
    volatile long pad19;
    volatile long pad1a;
    volatile long pad1b;
    volatile long pad1c;
    volatile long pad1d;
    volatile long pad1e;
    volatile long stealCount;
    final long keepAlive;
    int indexSeed;
    final int bounds;
    volatile int mode;
    WorkQueue[] workQueues;
    final String workerNamePrefix;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final Predicate<? super FJPool> saturate;
    private static final Unsafe U;
    private static final long CTL;
    private static final long MODE;
    private static final int ABASE;
    private static final int ASHIFT;
    private static final Class<?> ACTCLASS;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    static AccessControlContext contextWithPermissions(Permission ... perms) {
        Permissions permissions = new Permissions();
        for (Permission perm : perms) {
            permissions.add(perm);
        }
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    static long getAndAddLong(Object o, long offset, long delta) {
        long v;
        while (!U.compareAndSwapLong(o, offset, v = U.getLongVolatile(o, offset), v + delta)) {
        }
        return v;
    }

    static Object getAndSetObject(Object o, long offset, Object newValue) {
        Object v;
        while (!U.compareAndSwapObject(o, offset, v = U.getObjectVolatile(o, offset), newValue)) {
        }
        return v;
    }

    private boolean createWorker() {
        ForkJoinWorkerThreadFactory fac = this.factory;
        Throwable ex = null;
        FJWorkerThread wt = null;
        try {
            if (fac != null && (wt = fac.newThread(this)) != null) {
                wt.start();
                return true;
            }
        }
        catch (Throwable rex) {
            ex = rex;
        }
        this.deregisterWorker(wt, ex);
        return false;
    }

    private void tryAddWorker(long c) {
        do {
            long nc = 0xFFFF000000000000L & c + 0x1000000000000L | 0xFFFF00000000L & c + 0x100000000L;
            if (this.ctl != c || !U.compareAndSwapLong(this, CTL, c, nc)) continue;
            this.createWorker();
            break;
        } while (((c = this.ctl) & 0x800000000000L) != 0L && (int)c == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WorkQueue registerWorker(FJWorkerThread wt) {
        wt.setDaemon(true);
        Thread.UncaughtExceptionHandler handler = this.ueh;
        if (handler != null) {
            wt.setUncaughtExceptionHandler(handler);
        }
        WorkQueue w = new WorkQueue(this, wt);
        int tid = 0;
        int fifo = this.mode & 0x10000;
        String prefix = this.workerNamePrefix;
        String lock = prefix;
        if (lock != null) {
            String string = lock;
            synchronized (string) {
                int n;
                WorkQueue[] ws = this.workQueues;
                int s = this.indexSeed += -1640531527;
                if (ws != null && (n = ws.length) > 1) {
                    int id;
                    WorkQueue q;
                    int m = n - 1;
                    tid = s & m;
                    int i = m & (s << 1 | 1);
                    int probes = n >>> 1;
                    while ((q = ws[i]) != null && q.phase != 0x40000000) {
                        if (--probes == 0) {
                            i = n | 1;
                            break;
                        }
                        i = i + 2 & m;
                    }
                    w.phase = w.id = (id = i | fifo | s & 0x3FFE0000);
                    if (i < n) {
                        ws[i] = w;
                    } else {
                        int an = n << 1;
                        WorkQueue[] as = new WorkQueue[an];
                        as[i] = w;
                        int am = an - 1;
                        for (int j = 0; j < n; ++j) {
                            WorkQueue v = ws[j];
                            if (v != null) {
                                as[v.id & am & 0x7E] = v;
                            }
                            if (++j >= n) break;
                            as[j] = ws[j];
                        }
                        this.workQueues = as;
                    }
                }
            }
            wt.setName(prefix.concat(Integer.toString(tid)));
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(FJWorkerThread wt, Throwable ex) {
        WorkQueue w = null;
        int phase = 0;
        if (wt != null && (w = wt.workQueue) != null) {
            String lock = this.workerNamePrefix;
            long ns = (long)w.nsteals & 0xFFFFFFFFL;
            int idx = w.id & 0xFFFF;
            if (lock != null) {
                String string = lock;
                synchronized (string) {
                    WorkQueue[] ws = this.workQueues;
                    if (this.workQueues != null && ws.length > idx && ws[idx] == w) {
                        ws[idx] = null;
                    }
                    this.stealCount += ns;
                }
            }
            phase = w.phase;
        }
        if (phase != 0x40000000) {
            long c;
            while (!U.compareAndSwapLong(this, CTL, c = this.ctl, 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & c)) {
            }
        }
        if (w != null) {
            w.cancelAll();
        }
        if (!this.tryTerminate(false, false) && w != null && w.array != null) {
            this.signalWork();
        }
        if (ex == null) {
            FJTask.helpExpungeStaleExceptions();
        } else {
            FJTask.rethrow(ex);
        }
    }

    final void signalWork() {
        long c;
        while ((c = this.ctl) < 0L) {
            WorkQueue v;
            int i;
            int sp = (int)c;
            if (sp == 0) {
                if ((c & 0x800000000000L) == 0L) break;
                this.tryAddWorker(c);
                break;
            }
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || ws.length <= (i = sp & 0xFFFF) || (v = ws[i]) == null) break;
            int np = sp & Integer.MAX_VALUE;
            int vp = v.phase;
            long nc = (long)v.stackPred & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & c + 0x1000000000000L;
            FJWorkerThread vt = v.owner;
            if (sp != vp || !U.compareAndSwapLong(this, CTL, c, nc)) continue;
            v.phase = np;
            if (v.source >= 0) break;
            LockSupport.unpark(vt);
            break;
        }
    }

    private int tryCompensate(WorkQueue w) {
        long nc;
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        short t = (short)(c >>> 32);
        if (t >= 0) {
            int n;
            if (ws == null || (n = ws.length) <= 0 || w == null) {
                return 0;
            }
            int sp = (int)c;
            if (sp != 0) {
                WorkQueue v = ws[sp & n - 1];
                int wp = w.phase;
                long uc = 0xFFFFFFFF00000000L & (wp < 0 ? c + 0x1000000000000L : c);
                int np = sp & Integer.MAX_VALUE;
                if (v != null) {
                    int vp = v.phase;
                    FJWorkerThread vt = v.owner;
                    long nc2 = (long)v.stackPred & 0xFFFFFFFFL | uc;
                    if (vp == sp && U.compareAndSwapLong(this, CTL, c, nc2)) {
                        v.phase = np;
                        if (v.source < 0) {
                            LockSupport.unpark(vt);
                        }
                        return wp < 0 ? -1 : 1;
                    }
                }
                return 0;
            }
            if ((int)(c >> 48) - (short)(this.bounds & 0xFFFF) > 0) {
                long nc3 = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFFFFFFFFFFL & c;
                return U.compareAndSwapLong(this, CTL, c, nc3) ? 1 : 0;
            }
            int md = this.mode;
            int pc = md & 0xFFFF;
            int tc = pc + t;
            int bc = 0;
            boolean unstable = false;
            for (int i = 1; i < n; i += 2) {
                Thread.State ts;
                WorkQueue q = ws[i];
                if (q == null) continue;
                if (q.source == 0) {
                    unstable = true;
                    break;
                }
                --tc;
                FJWorkerThread wt = q.owner;
                if (wt == null || (ts = wt.getState()) != Thread.State.BLOCKED && ts != Thread.State.WAITING) continue;
                ++bc;
            }
            if (unstable || tc != 0 || this.ctl != c) {
                return 0;
            }
            if (t + pc >= Short.MAX_VALUE || t >= this.bounds >>> 16) {
                Predicate<? super FJPool> sat = this.saturate;
                if (sat != null && sat.test(this)) {
                    return -1;
                }
                if (bc < pc) {
                    Thread.yield();
                    return 0;
                }
                throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
            }
        }
        return U.compareAndSwapLong(this, CTL, c, nc = c + 0x100000000L & 0xFFFF00000000L | c & 0xFFFF0000FFFFFFFFL) && this.createWorker() ? 1 : 0;
    }

    final void runWorker(WorkQueue w) {
        w.growArray();
        int r = w.id ^ TLRandom.nextSecondarySeed();
        if (r == 0) {
            r = 1;
        }
        int lastSignalId = 0;
        block0: while (true) {
            int n;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null) break;
            boolean nonempty = false;
            int m = n - 1;
            for (int j = n = ws.length; j > 0; --j) {
                int b;
                WorkQueue q;
                int i = r & m;
                if (i >= 0 && i < n && (q = ws[i]) != null && (b = q.base) - q.top < 0) {
                    int al;
                    FJTask<?>[] a = q.array;
                    if (q.array != null && (al = a.length) > 0) {
                        int qid = q.id;
                        int index = al - 1 & b;
                        long offset = ((long)index << ASHIFT) + (long)ABASE;
                        FJTask t = (FJTask)U.getObjectVolatile(a, offset);
                        if (t != null && b++ == q.base && U.compareAndSwapObject(a, offset, t, null)) {
                            q.base = b;
                            if (q.base - q.top < 0 && qid != lastSignalId) {
                                this.signalWork();
                            }
                            w.source = lastSignalId = qid;
                            t.doExec();
                            if ((w.id & 0x10000) != 0) {
                                w.localPollAndExec(1024);
                            } else {
                                w.localPopAndExec(1024);
                            }
                            FJWorkerThread thread = w.owner;
                            ++w.nsteals;
                            w.source = 0;
                            if (thread != null) {
                                thread.afterTopLevelExec();
                            }
                        }
                        nonempty = true;
                        continue;
                    }
                }
                if (nonempty) break;
                ++r;
            }
            if (nonempty) {
                r ^= r << 13;
                r ^= r >>> 17;
                r ^= r << 5;
                continue;
            }
            lastSignalId = 0;
            int phase = w.phase;
            if (phase >= 0) {
                long nc;
                long c;
                int np = w.phase = phase + 65536 | Integer.MIN_VALUE;
                do {
                    c = this.ctl;
                    w.stackPred = (int)c;
                } while (!U.compareAndSwapLong(this, CTL, c, nc = c - 0x1000000000000L & 0xFFFFFFFF00000000L | 0xFFFFFFFFL & (long)np));
                continue;
            }
            int pred = w.stackPred;
            w.source = -1073741824;
            int steps = 0;
            while (true) {
                if (w.phase >= 0) {
                    w.source = 0;
                    continue block0;
                }
                int md = this.mode;
                if (md < 0) {
                    return;
                }
                long c = this.ctl;
                int rc = (md & 0xFFFF) + (int)(c >> 48);
                if (rc <= 0 && (md & 0x40000) != 0 && this.tryTerminate(false, false)) {
                    return;
                }
                if ((++steps & 1) == 0) {
                    Thread.interrupted();
                    continue;
                }
                if (rc <= 0 && pred != 0 && phase == (int)c) {
                    long nc;
                    long d = this.keepAlive + System.currentTimeMillis();
                    LockSupport.parkUntil(this, d);
                    if (this.ctl != c || d - System.currentTimeMillis() > 20L || !U.compareAndSwapLong(this, CTL, c, nc = 0xFFFFFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & (long)pred)) continue;
                    w.phase = 0x40000000;
                    return;
                }
                LockSupport.park(this);
            }
            break;
        }
    }

    final int awaitJoin(WorkQueue w, FJTask<?> task, long deadline) {
        int s = 0;
        if (w != null && task != null) {
            w.tryRemoveAndExec(task);
            int src = w.source;
            int id = w.id;
            s = task.status;
            while (s >= 0) {
                long ms;
                boolean nonempty = false;
                int r = TLRandom.nextSecondarySeed() | 1;
                WorkQueue[] ws = this.workQueues;
                if (this.workQueues != null) {
                    int n = ws.length;
                    int m = n - 1;
                    for (int j = -n; j < n; j += 2) {
                        int al;
                        int b;
                        WorkQueue q;
                        int i = r + j & m;
                        if (i < 0 || i >= n || (q = ws[i]) == null || q.source != id || (b = q.base) - q.top >= 0) continue;
                        FJTask<?>[] a = q.array;
                        if (q.array == null || (al = a.length) <= 0) continue;
                        int qid = q.id;
                        int index = al - 1 & b;
                        long offset = ((long)index << ASHIFT) + (long)ABASE;
                        FJTask t = (FJTask)U.getObjectVolatile(a, offset);
                        if (t != null && b++ == q.base && id == q.source && U.compareAndSwapObject(a, offset, t, null)) {
                            q.base = b;
                            w.source = qid;
                            t.doExec();
                            w.source = src;
                        }
                        nonempty = true;
                        break;
                    }
                }
                if ((s = task.status) < 0) break;
                if (nonempty) continue;
                if (deadline == 0L) {
                    ms = 0L;
                } else {
                    long ns = deadline - System.nanoTime();
                    if (ns <= 0L) break;
                    ms = TimeUnit.NANOSECONDS.toMillis(ns);
                    if (ms <= 0L) {
                        ms = 1L;
                    }
                }
                int block = this.tryCompensate(w);
                if (block != 0) {
                    task.internalWait(ms);
                    FJPool.getAndAddLong(this, CTL, block > 0 ? 0x1000000000000L : 0L);
                }
                s = task.status;
            }
        }
        return s;
    }

    final void helpQuiescePool(WorkQueue w) {
        int prevSrc = w.source;
        int fifo = w.id & 0x10000;
        int source = prevSrc;
        int released = -1;
        while (true) {
            if (fifo != 0) {
                w.localPollAndExec(0);
            } else {
                w.localPopAndExec(0);
            }
            if (released == -1 && w.phase >= 0) {
                released = 1;
            }
            boolean quiet = true;
            boolean empty = true;
            int r = TLRandom.nextSecondarySeed();
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null) {
                int n;
                int m = n - 1;
                for (int j = n = ws.length; j > 0; --j) {
                    WorkQueue q;
                    int i = r - j & m;
                    if (i < 0 || i >= n || (q = ws[i]) == null) continue;
                    int b = q.base;
                    if (b - q.top < 0) {
                        int al;
                        FJTask<?>[] a = q.array;
                        if (q.array != null && (al = a.length) > 0) {
                            int index;
                            long offset;
                            FJTask t;
                            int qid = q.id;
                            if (released == 0) {
                                released = 1;
                                FJPool.getAndAddLong(this, CTL, 0x1000000000000L);
                            }
                            if ((t = (FJTask)U.getObjectVolatile(a, offset = ((long)(index = al - 1 & b) << ASHIFT) + (long)ABASE)) != null && b++ == q.base && U.compareAndSwapObject(a, offset, t, null)) {
                                q.base = b;
                                w.source = source = q.id;
                                t.doExec();
                                w.source = source = prevSrc;
                            }
                            empty = false;
                            quiet = false;
                            break;
                        }
                    }
                    if ((q.source & 0x40000000) != 0) continue;
                    quiet = false;
                }
            }
            if (quiet) {
                if (released == 0) {
                    FJPool.getAndAddLong(this, CTL, 0x1000000000000L);
                }
                break;
            }
            if (!empty) continue;
            if (source != 0x40000000) {
                source = 0x40000000;
                w.source = 0x40000000;
            }
            if (released != 1) continue;
            released = 0;
            FJPool.getAndAddLong(this, CTL, -281474976710656L);
        }
        w.source = prevSrc;
    }

    private FJTask<?> pollScan(boolean submissionsOnly) {
        block0: while ((this.mode & Integer.MIN_VALUE) == 0) {
            int step;
            int origin;
            int n;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (n = ws.length) <= 0) break;
            int m = n - 1;
            int r = TLRandom.nextSecondarySeed();
            int h = r >>> 16;
            if (submissionsOnly) {
                origin = r & 0xFFFFFFFE & m;
                step = h & 0xFFFFFFFE | 2;
            } else {
                origin = r & m;
                step = h | 1;
            }
            int k = origin;
            int oldSum = 0;
            int checkSum = 0;
            while (true) {
                WorkQueue q;
                if ((q = ws[k]) != null) {
                    int b = q.base;
                    checkSum += b;
                    if (b - q.top < 0) {
                        int al;
                        FJTask<?>[] a = q.array;
                        if (q.array != null && (al = a.length) > 0) {
                            int index = al - 1 & b;
                            long offset = ((long)index << ASHIFT) + (long)ABASE;
                            FJTask t = (FJTask)U.getObjectVolatile(a, offset);
                            if (t == null || b++ != q.base || !U.compareAndSwapObject(a, offset, t, null)) continue block0;
                            q.base = b;
                            return t;
                        }
                    }
                }
                if ((k = k + step & m) != origin) continue;
                if (oldSum == (oldSum = checkSum)) break block0;
                checkSum = 0;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void externalPush(FJTask<?> task) {
        int r = TLRandom.getProbe();
        if (r == 0) {
            TLRandom.localInit();
            r = TLRandom.getProbe();
        }
        while (true) {
            int n;
            int md = this.mode;
            WorkQueue[] ws = this.workQueues;
            if ((md & 0x40000) != 0 || ws == null || (n = ws.length) <= 0) {
                throw new RejectedExecutionException();
            }
            boolean push = false;
            boolean grow = false;
            WorkQueue q = ws[n - 1 & r & 0x7E];
            if (q == null) {
                String lock = this.workerNamePrefix;
                int qid = (r | 0x40000000) & 0xFFFEFFFE;
                q = new WorkQueue(this, null);
                q.id = qid;
                q.source = 0x40000000;
                q.phase = 1;
                if (lock != null) {
                    String string = lock;
                    synchronized (string) {
                        int i;
                        ws = this.workQueues;
                        if (this.workQueues != null && (n = ws.length) > 0 && ws[i = qid & n - 1 & 0x7E] == null) {
                            ws[i] = q;
                            grow = true;
                            push = true;
                        }
                    }
                }
            } else if (q.tryLockSharedQueue()) {
                int d;
                int al;
                int b = q.base;
                int s = q.top;
                FJTask<?>[] a = q.array;
                if (q.array != null && (al = a.length) > 0 && al - 1 + (d = b - s) > 0) {
                    a[al - 1 & s] = task;
                    q.top = s + 1;
                    q.phase = 0;
                    if (d < 0 && q.base - s < -1) {
                        break;
                    }
                } else {
                    grow = true;
                }
                push = true;
            }
            if (push) {
                if (grow) {
                    try {
                        int al;
                        q.growArray();
                        int s = q.top;
                        FJTask<?>[] a = q.array;
                        if (q.array != null && (al = a.length) > 0) {
                            a[al - 1 & s] = task;
                            q.top = s + 1;
                        }
                    }
                    finally {
                        q.phase = 0;
                    }
                }
                this.signalWork();
                break;
            }
            r = TLRandom.advanceProbe(r);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> FJTask<T> externalSubmit(FJTask<T> task) {
        Utils.requireNonNull(task);
        Thread t = Thread.currentThread();
        if (t instanceof FJWorkerThread) {
            WorkQueue q;
            FJWorkerThread w = (FJWorkerThread)t;
            if (w.pool == this && (q = w.workQueue) != null) {
                q.push(task);
                return task;
            }
        }
        this.externalPush(task);
        return task;
    }

    final boolean tryExternalUnpush(FJTask<?> task) {
        WorkQueue w;
        int n;
        int r = TLRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        return this.workQueues != null && (n = ws.length) > 0 && (w = ws[n - 1 & r & 0x7E]) != null && w.trySharedUnpush(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryTerminate(boolean now, boolean enable) {
        long oldSum;
        int md;
        while (((md = this.mode) & 0x40000) == 0) {
            if (!enable || this == common) {
                return false;
            }
            U.compareAndSwapInt(this, MODE, md, md | 0x40000);
        }
        while (((md = this.mode) & Integer.MIN_VALUE) == 0) {
            if (!now) {
                long checkSum;
                WorkQueue[] ws;
                oldSum = 0L;
                do {
                    boolean running = false;
                    checkSum = this.ctl;
                    ws = this.workQueues;
                    if ((md & 0xFFFF) + (int)(checkSum >> 48) > 0) {
                        running = true;
                    } else if (ws != null) {
                        for (int i = 0; i < ws.length; ++i) {
                            WorkQueue w = ws[i];
                            if (w == null) continue;
                            int s = w.source;
                            int p = w.phase;
                            int d = w.id;
                            int b = w.base;
                            if (b != w.top || (d & 1) == 1 && (s >= 0 || p >= 0)) {
                                running = true;
                                break;
                            }
                            checkSum += ((long)s << 48) + ((long)p << 32) + ((long)b << 16) + (long)d;
                        }
                    }
                    md = this.mode;
                    if ((md & Integer.MIN_VALUE) != 0) break;
                    if (!running) continue;
                    return false;
                } while (this.workQueues != ws || oldSum != (oldSum = checkSum));
            }
            if ((md & Integer.MIN_VALUE) != 0) continue;
            U.compareAndSwapInt(this, MODE, md, md | Integer.MIN_VALUE);
        }
        while (((md = this.mode) & 0x80000) == 0) {
            long checkSum;
            WorkQueue[] ws;
            oldSum = 0L;
            do {
                checkSum = this.ctl;
                ws = this.workQueues;
                if (this.workQueues == null) continue;
                for (int i = 0; i < ws.length; ++i) {
                    WorkQueue w = ws[i];
                    if (w == null) continue;
                    FJWorkerThread wt = w.owner;
                    w.cancelAll();
                    if (wt != null) {
                        try {
                            wt.interrupt();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    checkSum += ((long)w.phase << 32) + (long)w.base;
                }
            } while (((md = this.mode) & 0x80000) == 0 && (this.workQueues != ws || oldSum != (oldSum = checkSum)));
            if ((md & 0x80000) != 0 || (md & 0xFFFF) + (short)(this.ctl >>> 32) > 0) break;
            if (!U.compareAndSwapInt(this, MODE, md, md | 0x80000)) continue;
            FJPool fJPool = this;
            synchronized (fJPool) {
                this.notifyAll();
                break;
            }
        }
        return true;
    }

    private static Object newInstanceFromSystemProperty(String property) throws Exception {
        String className = System.getProperty(property);
        return className == null ? null : ClassLoader.getSystemClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    FJPool(byte forCommonPoolOnly) {
        int parallelism = -1;
        ForkJoinWorkerThreadFactory fac = null;
        Thread.UncaughtExceptionHandler handler = null;
        try {
            String pp = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            if (pp != null) {
                parallelism = Integer.parseInt(pp);
            }
            fac = (ForkJoinWorkerThreadFactory)FJPool.newInstanceFromSystemProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            handler = (Thread.UncaughtExceptionHandler)FJPool.newInstanceFromSystemProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
        }
        catch (Exception pp) {
            // empty catch block
        }
        if (fac == null) {
            fac = defaultForkJoinWorkerThreadFactory;
        }
        if (parallelism < 0 && (parallelism = Runtime.getRuntime().availableProcessors() - 1) <= 0) {
            parallelism = 1;
        }
        if (parallelism > Short.MAX_VALUE) {
            parallelism = Short.MAX_VALUE;
        }
        long c = (long)(-parallelism) << 32 & 0xFFFF00000000L | (long)(-parallelism) << 48 & 0xFFFF000000000000L;
        int b = 1 - parallelism & 0xFFFF | COMMON_MAX_SPARES << 16;
        int n = parallelism > 1 ? parallelism - 1 : 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n = n + 1 << 1;
        this.workerNamePrefix = "ForkJoinPool.commonPool-worker-";
        this.workQueues = new WorkQueue[n];
        this.factory = fac;
        this.ueh = handler;
        this.saturate = null;
        this.keepAlive = 60000L;
        this.bounds = b;
        this.mode = parallelism;
        this.ctl = c;
    }

    static FJPool commonPool() {
        return common;
    }

    @Override
    public void execute(Runnable task) {
        Utils.requireNonNull(task);
        FJTask job = task instanceof FJTask ? (FJTask)((Object)task) : new FJTask.RunnableExecuteAction(task);
        this.externalSubmit(job);
    }

    public <T> FJTask<T> submit(Callable<T> task) {
        return this.externalSubmit(new FJTask.AdaptedCallable<T>(task));
    }

    public <T> FJTask<T> submit(Runnable task, T result) {
        return this.externalSubmit(new FJTask.AdaptedRunnable<T>(task, result));
    }

    public FJTask<?> submit(Runnable task) {
        Utils.requireNonNull(task);
        return this.externalSubmit(task instanceof FJTask ? (FJTask)((Object)task) : new FJTask.AdaptedRunnableAction(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        try {
            for (Callable<T> t : tasks) {
                FJTask.AdaptedCallable<T> f = new FJTask.AdaptedCallable<T>(t);
                futures.add(f);
                this.externalSubmit(f);
            }
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ((FJTask)futures.get(i)).quietlyJoin();
            }
            return futures;
        }
        catch (Throwable t) {
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ((Future)futures.get(i)).cancel(false);
            }
            throw t;
        }
    }

    static int getCommonPoolParallelism() {
        return COMMON_PARALLELISM;
    }

    public boolean isQuiescent() {
        long c;
        int tc;
        do {
            c = this.ctl;
            int md = this.mode;
            int pc = md & 0xFFFF;
            tc = pc + (short)(c >>> 32);
            int rc = pc + (int)(c >> 48);
            if ((md & 0x80080000) != 0) {
                return true;
            }
            if (rc > 0) {
                return false;
            }
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null) continue;
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue v = ws[i];
                if (v == null) continue;
                if ((v.source & 0x40000000) == 0) {
                    return false;
                }
                --tc;
            }
        } while (tc != 0 || this.ctl != c);
        return true;
    }

    public String toString() {
        long qt = 0L;
        long qs = 0L;
        int rc = 0;
        long st = this.stealCount;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                int size = w.queueSize();
                if ((i & 1) == 0) {
                    qs += (long)size;
                    continue;
                }
                qt += (long)size;
                st += (long)w.nsteals & 0xFFFFFFFFL;
                if (!w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        int md = this.mode;
        int pc = md & 0xFFFF;
        long c = this.ctl;
        int tc = pc + (short)(c >>> 32);
        int ac = pc + (int)(c >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = (md & 0x80000) != 0 ? "Terminated" : ((md & Integer.MIN_VALUE) != 0 ? "Terminating" : ((md & 0x40000) != 0 ? "Shutting down" : "Running"));
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    @Override
    public void shutdown() {
        FJPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        FJPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return (this.mode & 0x80000) != 0;
    }

    @Override
    public boolean isShutdown() {
        return (this.mode & 0x40000) != 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(timeout, unit);
            return false;
        }
        long nanos = unit.toNanos(timeout);
        if (this.isTerminated()) {
            return true;
        }
        if (nanos <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + nanos;
        FJPool fJPool = this;
        synchronized (fJPool) {
            while (true) {
                if (this.isTerminated()) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
                this.wait(millis > 0L ? millis : 1L);
                nanos = deadline - System.nanoTime();
            }
        }
    }

    public boolean awaitQuiescence(long timeout, TimeUnit unit) {
        long nanos = unit.toNanos(timeout);
        Thread thread = Thread.currentThread();
        if (thread instanceof FJWorkerThread) {
            FJWorkerThread wt = (FJWorkerThread)thread;
            if (wt.pool == this) {
                this.helpQuiescePool(wt.workQueue);
                return true;
            }
        }
        long startTime = System.nanoTime();
        while (true) {
            FJTask<?> t;
            if ((t = this.pollScan(false)) != null) {
                t.doExec();
                continue;
            }
            if (this.isQuiescent()) {
                return true;
            }
            if (System.nanoTime() - startTime > nanos) {
                return false;
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t instanceof FJWorkerThread) {
            WorkQueue w;
            FJWorkerThread wt = (FJWorkerThread)t;
            FJPool p = wt.pool;
            if (p != null && (w = wt.workQueue) != null) {
                while (!blocker.isReleasable()) {
                    int block = p.tryCompensate(w);
                    if (block == 0) continue;
                    try {
                        while (!blocker.isReleasable() && !blocker.block()) {
                        }
                        FJPool.getAndAddLong(p, CTL, block > 0 ? 0x1000000000000L : 0L);
                    }
                    catch (Throwable throwable) {
                        FJPool.getAndAddLong(p, CTL, block > 0 ? 0x1000000000000L : 0L);
                        throw throwable;
                    }
                    return;
                }
                return;
            }
        }
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    /*
     * Unable to fully structure code
     */
    static void helpAsyncBlocker(Executor e, ManagedBlocker blocker) {
        block5: {
            block7: {
                block6: {
                    if (blocker == null || !(e instanceof FJPool)) break block5;
                    p = (FJPool)e;
                    thread = Thread.currentThread();
                    if (!(thread instanceof FJWorkerThread)) break block6;
                    wt = (FJWorkerThread)thread;
                    if (wt.pool != p) break block6;
                    w = wt.workQueue;
                    break block7;
                }
                if ((r = TLRandom.getProbe()) == 0) ** GOTO lbl-1000
                ws = p.workQueues;
                if (p.workQueues != null && (n = ws.length) > 0) {
                    w = ws[n - 1 & r & 126];
                } else lbl-1000:
                // 2 sources

                {
                    w = null;
                }
            }
            if (w != null) {
                while (true) {
                    b = w.base;
                    s = w.top;
                    a = w.array;
                    if (w.array == null || (d = b - s) >= 0 || (al = a.length) <= 0) break;
                    index = al - 1 & b;
                    offset = ((long)index << FJPool.ASHIFT) + (long)FJPool.ABASE;
                    t = (FJTask)FJPool.U.getObjectVolatile(a, offset);
                    if (blocker.isReleasable()) break;
                    if (b++ != w.base) continue;
                    if (t == null) {
                        if (d != -1) continue;
                        break;
                    }
                    if (!FJPool.isInstanceOfAsynCompTask(t)) break;
                    if (!FJPool.U.compareAndSwapObject(a, offset, t, null)) continue;
                    w.base = b;
                    t.doExec();
                }
            }
        }
    }

    static boolean isInstanceOfAsynCompTask(FJTask<?> t) {
        Class<?> asynCompTaskClz;
        if (t != null && (asynCompTaskClz = ACTCLASS) != null) {
            return asynCompTaskClz.isAssignableFrom(t.getClass());
        }
        return false;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new FJTask.AdaptedRunnable<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FJTask.AdaptedCallable<T>(callable);
    }

    static {
        U = UnsafeAccess.unsafe;
        ACTCLASS = CompletableFuture.AsynchronousCompletionTask.class;
        try {
            CTL = U.objectFieldOffset(FJPool.class.getDeclaredField("ctl"));
            MODE = U.objectFieldOffset(FJPool.class.getDeclaredField("mode"));
            ABASE = U.arrayBaseOffset(FJTask[].class);
            int scale = U.arrayIndexScale(FJTask[].class);
            if ((scale & scale - 1) != 0) {
                throw new ExceptionInInitializerError("array index scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        int commonMaxSpares = 256;
        try {
            String p = System.getProperty("java.util.concurrent.ForkJoinPool.common.maximumSpares");
            if (p != null) {
                commonMaxSpares = Integer.parseInt(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMMON_MAX_SPARES = commonMaxSpares;
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        common = AccessController.doPrivileged(new PrivilegedAction<FJPool>(){

            @Override
            public FJPool run() {
                return new FJPool(0);
            }
        });
        COMMON_PARALLELISM = Math.max(FJPool.common.mode & 0xFFFF, 1);
    }

    static final class MemBar {
        private static final Mock x = new Mock();
        private static final Unsafe U = UnsafeAccess.unsafe;
        private static final long OFF;

        static void loadFence() {
            U.getIntVolatile(x, OFF);
        }

        static void storeFence() {
            U.putOrderedInt(x, OFF, 0);
        }

        static void fullFence() {
            U.putIntVolatile(x, OFF, 0);
        }

        private MemBar() {
        }

        static {
            try {
                OFF = U.objectFieldOffset(Mock.class.getDeclaredField("v"));
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile long pad00;
        volatile long pad01;
        volatile long pad02;
        volatile long pad03;
        volatile long pad04;
        volatile long pad05;
        volatile long pad06;
        volatile long pad07;
        volatile long pad08;
        volatile long pad09;
        volatile long pad0a;
        volatile long pad0b;
        volatile long pad0c;
        volatile long pad0d;
        volatile long pad0e;
        volatile long pad0f;
        volatile int phase;
        int stackPred;
        int nsteals;
        int id;
        volatile int source;
        volatile int base;
        int top;
        FJTask<?>[] array;
        final FJPool pool;
        final FJWorkerThread owner;
        volatile Object pad10;
        volatile Object pad11;
        volatile Object pad12;
        volatile Object pad13;
        volatile Object pad14;
        volatile Object pad15;
        volatile Object pad16;
        volatile Object pad17;
        volatile Object pad18;
        volatile Object pad19;
        volatile Object pad1a;
        volatile Object pad1b;
        volatile Object pad1c;
        volatile Object pad1d;
        volatile Object pad1e;
        volatile Object pad1f;
        private static final Unsafe U = UnsafeAccess.unsafe;
        private static final long PHASE;
        private static final int ABASE;
        private static final int ASHIFT;

        WorkQueue(FJPool pool, FJWorkerThread owner) {
            this.pool = pool;
            this.owner = owner;
            this.top = 4096;
            this.base = 4096;
        }

        final int queueSize() {
            int n = this.base - this.top;
            return n >= 0 ? 0 : -n;
        }

        final void push(FJTask<?> task) {
            int al;
            int s = this.top;
            FJTask<?>[] a = this.array;
            if (this.array != null && (al = a.length) > 0) {
                int index = al - 1 & s;
                long offset = ((long)index << ASHIFT) + (long)ABASE;
                FJPool p = this.pool;
                this.top = s + 1;
                U.putOrderedObject(a, offset, task);
                int d = this.base - s;
                if (d == 0 && p != null) {
                    MemBar.fullFence();
                    p.signalWork();
                } else if (d + al == 1) {
                    this.growArray();
                }
            }
        }

        final FJTask<?>[] growArray() {
            int b;
            int t;
            int oldMask;
            int size;
            FJTask<?>[] oldA = this.array;
            int oldSize = oldA != null ? oldA.length : 0;
            int n = size = oldSize > 0 ? oldSize << 1 : 8192;
            if (size < 8192 || size > 0x4000000) {
                throw new RejectedExecutionException("Queue capacity exceeded");
            }
            this.array = new FJTask[size];
            FJTask[] a = this.array;
            if (oldA != null && (oldMask = oldSize - 1) > 0 && (t = this.top) - (b = this.base) > 0) {
                int mask = size - 1;
                do {
                    int index;
                    long offset;
                    FJTask x;
                    if ((x = (FJTask)U.getObjectVolatile(oldA, offset = ((long)(index = b & oldMask) << ASHIFT) + (long)ABASE)) == null || !U.compareAndSwapObject(oldA, offset, x, null)) continue;
                    a[b & mask] = x;
                } while (++b != t);
                MemBar.storeFence();
            }
            return a;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final FJTask<?> poll() {
            while (true) {
                int al;
                int d;
                int b = this.base;
                int s = this.top;
                FJTask<?>[] a = this.array;
                if (this.array == null || (d = b - s) >= 0 || (al = a.length) <= 0) return null;
                int index = al - 1 & b;
                long offset = ((long)index << ASHIFT) + (long)ABASE;
                FJTask t = (FJTask)U.getObjectVolatile(a, offset);
                if (b++ != this.base) continue;
                if (t != null) {
                    if (!U.compareAndSwapObject(a, offset, t, null)) continue;
                    this.base = b;
                    return t;
                }
                if (d == -1) return null;
            }
        }

        final boolean tryUnpush(FJTask<?> task) {
            int index;
            long offset;
            int al;
            int b = this.base;
            int s = this.top;
            FJTask<?>[] a = this.array;
            if (this.array != null && b != s && (al = a.length) > 0 && U.compareAndSwapObject(a, offset = ((long)(index = al - 1 & --s) << ASHIFT) + (long)ABASE, task, null)) {
                this.top = s;
                MemBar.storeFence();
                return true;
            }
            return false;
        }

        final void cancelAll() {
            FJTask<?> t;
            while ((t = this.poll()) != null) {
                FJTask.cancelIgnoringExceptions(t);
            }
        }

        final void localPopAndExec(int limit) {
            do {
                int index;
                long offset;
                FJTask t;
                int al;
                int b = this.base;
                int s = this.top;
                FJTask<?>[] a = this.array;
                if (this.array == null || b == s || (al = a.length) <= 0 || (t = (FJTask)FJPool.getAndSetObject(a, offset = ((long)(index = al - 1 & --s) << ASHIFT) + (long)ABASE, null)) == null) break;
                this.top = s;
                MemBar.storeFence();
                t.doExec();
            } while (limit == 0 || --limit != 0);
        }

        final void localPollAndExec(int limit) {
            int polls = 0;
            while (true) {
                int index;
                long offset;
                FJTask t;
                int al;
                int d;
                int b = this.base;
                int s = this.top;
                FJTask<?>[] a = this.array;
                if (this.array == null || (d = b - s) >= 0 || (al = a.length) <= 0) break;
                if ((t = (FJTask)FJPool.getAndSetObject(a, offset = ((long)(index = al - 1 & b++) << ASHIFT) + (long)ABASE, null)) != null) {
                    this.base = b;
                    t.doExec();
                    if (limit == 0 || ++polls != limit) continue;
                    break;
                }
                if (d == -1) break;
                polls = 0;
            }
        }

        final void tryRemoveAndExec(FJTask<?> task) {
            int s = this.top;
            if (this.base - s < 0) {
                int wal;
                FJTask<?>[] wa = this.array;
                if (this.array != null && (wal = wa.length) > 0) {
                    int index;
                    long offset;
                    FJTask t;
                    int ns;
                    int m = wal - 1;
                    int i = ns = s - 1;
                    while ((t = (FJTask)U.getObject(wa, offset = (long)(((index = i & m) << ASHIFT) + ABASE))) != null) {
                        if (t == task) {
                            if (!U.compareAndSwapObject(wa, offset, t, null)) break;
                            this.top = ns;
                            for (int j = i; j != ns; ++j) {
                                int pindex = j + 1 & m;
                                long pOffset = (pindex << ASHIFT) + ABASE;
                                FJTask f = (FJTask)U.getObject(wa, pOffset);
                                U.putObjectVolatile(wa, pOffset, null);
                                int jindex = j & m;
                                long jOffset = (jindex << ASHIFT) + ABASE;
                                U.putOrderedObject(wa, jOffset, f);
                            }
                            MemBar.storeFence();
                            t.doExec();
                            break;
                        }
                        --i;
                    }
                }
            }
        }

        final boolean tryLockSharedQueue() {
            return U.compareAndSwapInt(this, PHASE, 0, 1);
        }

        final boolean trySharedUnpush(FJTask<?> task) {
            int index;
            long offset;
            FJTask t;
            int al;
            boolean popped = false;
            int s = this.top - 1;
            FJTask<?>[] a = this.array;
            if (this.array != null && (al = a.length) > 0 && (t = (FJTask)U.getObject(a, offset = ((long)(index = al - 1 & s) << ASHIFT) + (long)ABASE)) == task && U.compareAndSwapInt(this, PHASE, 0, 1)) {
                if (this.top == s + 1 && this.array == a && U.compareAndSwapObject(a, offset, task, null)) {
                    popped = true;
                    this.top = s;
                }
                U.putOrderedInt(this, PHASE, 0);
            }
            return popped;
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s;
            FJWorkerThread wt = this.owner;
            return wt != null && (s = wt.getState()) != Thread.State.BLOCKED && s != Thread.State.WAITING && s != Thread.State.TIMED_WAITING;
        }

        static {
            try {
                PHASE = U.objectFieldOffset(WorkQueue.class.getDeclaredField("phase"));
                ABASE = U.arrayBaseOffset(FJTask[].class);
                int scale = U.arrayIndexScale(FJTask[].class);
                if ((scale & scale - 1) != 0) {
                    throw new ExceptionInInitializerError("array index scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext ACC = FJPool.contextWithPermissions(new RuntimePermission("getClassLoader"));

        @Override
        public final FJWorkerThread newThread(final FJPool pool) {
            return AccessController.doPrivileged(new PrivilegedAction<FJWorkerThread>(){

                @Override
                public FJWorkerThread run() {
                    return new FJWorkerThread(pool, ClassLoader.getSystemClassLoader());
                }
            }, ACC);
        }

        DefaultForkJoinWorkerThreadFactory() {
        }
    }

    static interface ForkJoinWorkerThreadFactory {
        public FJWorkerThread newThread(FJPool var1);
    }
}

