/*
 * Copyright 2021 Stefan Zobel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package math.rng;

/**
 * A generator of uniform pseudorandom values applicable for use in (among other
 * contexts) isolated parallel computations that may generate subtasks.
 */
public interface SplittablePseudoRandom extends PseudoRandom {

    /**
     * Constructs and returns a new SplittablePseudoRandom instance that shares
     * no mutable state with the current instance. However, with very high
     * probability, the values collectively generated by the two instances have
     * the same statistical properties as if the same quantity of values were
     * generated by a single thread using a single {@code
     * SplittablePseudoRandom} instance. Instances of SplittablePseudoRandom are
     * <em>not</em> thread-safe. They are designed to be split, not shared,
     * across threads.
     * 
     * @return a new SplittablePseudoRandom instance that shares no mutable
     *         state with the current instance
     */
    SplittablePseudoRandom split();
}
