/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.core;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.spals.appbuilder.config.message.MessageConsumerConfig;
import net.spals.appbuilder.message.core.AutoValue_MessageConsumerCallback_Key;

public interface MessageConsumerCallback<P> {
    public String getTag();

    public Class<P> getPayloadType();

    public void processMessage(MessageConsumerConfig var1, P var2);

    public static Map<Class<?>, MessageConsumerCallback<?>> loadCallbacksForTag(String tag, Set<MessageConsumerCallback<?>> callbackSet) {
        Preconditions.checkNotNull((Object)tag, (Object)"Cannot load consumer callback for null tag");
        return callbackSet.stream().filter(callback -> tag.equals(callback.getTag())).collect(Collectors.toMap(MessageConsumerCallback::getPayloadType, Function.identity()));
    }

    public static Map<String, MessageConsumerCallback<?>> loadCallbacksForType(Class<?> payloadType, Set<MessageConsumerCallback<?>> callbackSet) {
        Preconditions.checkNotNull(payloadType, (Object)"Cannot load consumer callback for null payload type");
        return callbackSet.stream().filter(callback -> payloadType.equals(callback.getPayloadType())).collect(Collectors.toMap(MessageConsumerCallback::getTag, Function.identity()));
    }

    public static Collector<MessageConsumerCallback<?>, ?, Map<Key, MessageConsumerCallback<?>>> mapCollector() {
        Function<MessageConsumerCallback, Key> keyMapper = consumerCallback -> Key.create(consumerCallback);
        return Collectors.toMap(keyMapper, Function.identity());
    }

    public static String unregisteredCallbackMessage(String tag, Class<?> payloadType) {
        return "Received payload type " + payloadType + " for consumer " + tag + " , but no callback is registered";
    }

    public static abstract class Key {
        public static Key create(MessageConsumerCallback<?> consumerCallback) {
            return Key.create(consumerCallback.getTag(), consumerCallback.getPayloadType());
        }

        public static Key create(String tag, Class<?> payloadType) {
            return new AutoValue_MessageConsumerCallback_Key(tag, payloadType);
        }

        public abstract String getTag();

        public abstract Class<?> getPayloadType();
    }
}

