/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.core.blockingqueue;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import net.spals.appbuilder.annotations.config.ServiceConfig;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.config.message.MessageProducerConfig;
import net.spals.appbuilder.message.core.blockingqueue.BlockingQueueMessage;
import net.spals.appbuilder.message.core.producer.MessageProducerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoBindInMap(baseClass=MessageProducerPlugin.class, key="blockingQueue")
class BlockingQueueMessageProducerPlugin
implements MessageProducerPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingQueueMessageProducerPlugin.class);
    private final BlockingQueue<BlockingQueueMessage> blockingMessageQueue;
    private final Optional<Long> offerTimeout;
    private final Optional<TimeUnit> offerTimeoutUnit;

    @Inject
    BlockingQueueMessageProducerPlugin(@ServiceConfig Config serviceConfig, @Named(value="message.blockingQueue") BlockingQueue<BlockingQueueMessage> blockingMessageQueue) {
        this.blockingMessageQueue = blockingMessageQueue;
        this.offerTimeout = Optional.of(serviceConfig).filter(config -> config.hasPath("messageProducer.blockingQueue.offerTimeout")).map(config -> config.getLong("messageProducer.blockingQueue.offerTimeout"));
        this.offerTimeoutUnit = Optional.of(serviceConfig).filter(config -> config.hasPath("messageProducer.blockingQueue.offerTimeoutUnit")).map(config -> (TimeUnit)config.getEnum(TimeUnit.class, "messageProducer.blockingQueue.offerTimeoutUnit"));
        Preconditions.checkState((this.offerTimeout.isPresent() == this.offerTimeoutUnit.isPresent() ? 1 : 0) != 0, (Object)"messageProducer.blockingQueue.offerTimeout and messageProducer.blockingQueue.offerTimeoutUnit must both have values");
    }

    @Override
    public void sendMessage(MessageProducerConfig producerConfig, byte[] serializedPayload) throws IOException {
        BlockingQueueMessage message = new BlockingQueueMessage.Builder().setSerializedPayload(serializedPayload).setTag(producerConfig.getTag()).build();
        try {
            if (this.offerTimeout.isPresent()) {
                this.blockingMessageQueue.offer(message, this.offerTimeout.get(), this.offerTimeoutUnit.get());
            } else {
                this.blockingMessageQueue.offer(message);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interupted while sending message on blcoking queue", (Throwable)e);
        }
    }
}

