/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.core.blockingqueue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.spals.appbuilder.message.core.blockingqueue.BlockingQueueMessage;

abstract class BlockingQueueMessage_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private byte[] serializedPayload;
    private String tag;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    BlockingQueueMessage_Builder() {
    }

    public static BlockingQueueMessage.Builder from(BlockingQueueMessage value) {
        return new BlockingQueueMessage.Builder().mergeFrom(value);
    }

    public BlockingQueueMessage.Builder setSerializedPayload(byte[] serializedPayload) {
        this.serializedPayload = (byte[])Preconditions.checkNotNull((Object)serializedPayload);
        this._unsetProperties.remove((Object)Property.SERIALIZED_PAYLOAD);
        return (BlockingQueueMessage.Builder)this;
    }

    public BlockingQueueMessage.Builder mapSerializedPayload(UnaryOperator<byte[]> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setSerializedPayload((byte[])mapper.apply(this.getSerializedPayload()));
    }

    public byte[] getSerializedPayload() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SERIALIZED_PAYLOAD) ? 1 : 0) != 0, (Object)"serializedPayload not set");
        return this.serializedPayload;
    }

    public BlockingQueueMessage.Builder setTag(String tag) {
        this.tag = (String)Preconditions.checkNotNull((Object)tag);
        this._unsetProperties.remove((Object)Property.TAG);
        return (BlockingQueueMessage.Builder)this;
    }

    public BlockingQueueMessage.Builder mapTag(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setTag((String)mapper.apply(this.getTag()));
    }

    public String getTag() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TAG) ? 1 : 0) != 0, (Object)"tag not set");
        return this.tag;
    }

    public BlockingQueueMessage.Builder mergeFrom(BlockingQueueMessage value) {
        BlockingQueueMessage.Builder _defaults = new BlockingQueueMessage.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.SERIALIZED_PAYLOAD) || !Objects.equals(value.getSerializedPayload(), ((BlockingQueueMessage_Builder)_defaults).getSerializedPayload())) {
            this.setSerializedPayload(value.getSerializedPayload());
        }
        if (_defaults._unsetProperties.contains((Object)Property.TAG) || !Objects.equals(value.getTag(), ((BlockingQueueMessage_Builder)_defaults).getTag())) {
            this.setTag(value.getTag());
        }
        return (BlockingQueueMessage.Builder)this;
    }

    public BlockingQueueMessage.Builder mergeFrom(BlockingQueueMessage.Builder template) {
        BlockingQueueMessage.Builder base = template;
        BlockingQueueMessage.Builder _defaults = new BlockingQueueMessage.Builder();
        if (!(base._unsetProperties.contains((Object)Property.SERIALIZED_PAYLOAD) || !_defaults._unsetProperties.contains((Object)Property.SERIALIZED_PAYLOAD) && Objects.equals(template.getSerializedPayload(), ((BlockingQueueMessage_Builder)_defaults).getSerializedPayload()))) {
            this.setSerializedPayload(template.getSerializedPayload());
        }
        if (!(base._unsetProperties.contains((Object)Property.TAG) || !_defaults._unsetProperties.contains((Object)Property.TAG) && Objects.equals(template.getTag(), ((BlockingQueueMessage_Builder)_defaults).getTag()))) {
            this.setTag(template.getTag());
        }
        return (BlockingQueueMessage.Builder)this;
    }

    public BlockingQueueMessage.Builder clear() {
        BlockingQueueMessage.Builder _defaults = new BlockingQueueMessage.Builder();
        this.serializedPayload = _defaults.serializedPayload;
        this.tag = _defaults.tag;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (BlockingQueueMessage.Builder)this;
    }

    public BlockingQueueMessage build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public BlockingQueueMessage buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements BlockingQueueMessage {
        private final byte[] serializedPayload;
        private final String tag;
        private final EnumSet<Property> _unsetProperties;

        Partial(BlockingQueueMessage_Builder builder) {
            this.serializedPayload = builder.serializedPayload;
            this.tag = builder.tag;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public byte[] getSerializedPayload() {
            if (this._unsetProperties.contains((Object)Property.SERIALIZED_PAYLOAD)) {
                throw new UnsupportedOperationException("serializedPayload not set");
            }
            return this.serializedPayload;
        }

        @Override
        public String getTag() {
            if (this._unsetProperties.contains((Object)Property.TAG)) {
                throw new UnsupportedOperationException("tag not set");
            }
            return this.tag;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.serializedPayload, other.serializedPayload) && Objects.equals(this.tag, other.tag) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.serializedPayload, this.tag, this._unsetProperties);
        }

        public String toString() {
            return "partial BlockingQueueMessage{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.SERIALIZED_PAYLOAD) ? "serializedPayload=" + this.serializedPayload : null), !this._unsetProperties.contains((Object)Property.TAG) ? "tag=" + this.tag : null, new Object[0]) + "}";
        }
    }

    private static final class Value
    implements BlockingQueueMessage {
        private final byte[] serializedPayload;
        private final String tag;

        private Value(BlockingQueueMessage_Builder builder) {
            this.serializedPayload = builder.serializedPayload;
            this.tag = builder.tag;
        }

        @Override
        public byte[] getSerializedPayload() {
            return this.serializedPayload;
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.serializedPayload, other.serializedPayload) && Objects.equals(this.tag, other.tag);
        }

        public int hashCode() {
            return Objects.hash(this.serializedPayload, this.tag);
        }

        public String toString() {
            return "BlockingQueueMessage{serializedPayload=" + this.serializedPayload + ", tag=" + this.tag + "}";
        }
    }

    private static enum Property {
        SERIALIZED_PAYLOAD("serializedPayload"),
        TAG("tag");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

