/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.core.blockingqueue;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.spals.appbuilder.annotations.config.ServiceConfig;
import net.spals.appbuilder.annotations.service.AutoBindModule;
import net.spals.appbuilder.message.core.blockingqueue.BlockingQueueMessage;

@AutoBindModule
class BlockingQueueModule
extends AbstractModule {
    private final Integer queueSize;

    @Inject
    BlockingQueueModule(@ServiceConfig Config serviceConfig) {
        this.queueSize = Optional.of(serviceConfig).filter(config -> config.hasPath("message.blockingQueue.size")).map(config -> config.getInt("message.blockingQueue.size")).orElse(Integer.MAX_VALUE);
    }

    protected void configure() {
        this.binder().bind((TypeLiteral)new TypeLiteral<BlockingQueue<BlockingQueueMessage>>(){}).annotatedWith((Annotation)Names.named((String)"message.blockingQueue")).toInstance(new LinkedBlockingQueue(this.queueSize));
    }
}

