/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.core.consumer;

import com.google.inject.Inject;
import com.typesafe.config.ConfigException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.spals.appbuilder.annotations.service.AutoBindSingleton;
import net.spals.appbuilder.config.message.MessageConsumerConfig;
import net.spals.appbuilder.message.core.MessageConsumer;
import net.spals.appbuilder.message.core.consumer.MessageConsumerPlugin;
import net.spals.appbuilder.model.core.ModelSerializer;

@AutoBindSingleton(baseClass=MessageConsumer.class)
class DefaultMessageConsumer
implements MessageConsumer {
    private final Map<String, MessageConsumerConfig> consumerConfigMap;
    private final Map<String, ModelSerializer> serializerMap;
    private final Map<String, MessageConsumerPlugin> consumerPluginMap;

    @Inject
    DefaultMessageConsumer(Map<String, MessageConsumerConfig> consumerConfigMap, Map<String, ModelSerializer> serializerMap, Map<String, MessageConsumerPlugin> consumerPluginMap) {
        this.consumerConfigMap = consumerConfigMap;
        this.serializerMap = serializerMap;
        this.consumerPluginMap = consumerPluginMap;
    }

    @Override
    @PostConstruct
    public void start() {
        this.consumerConfigMap.entrySet().stream().filter(consumerConfigEntry -> ((MessageConsumerConfig)consumerConfigEntry.getValue()).isActive()).forEach(consumerConfigEntry -> {
            String tag = (String)consumerConfigEntry.getKey();
            MessageConsumerConfig consumerConfig = (MessageConsumerConfig)consumerConfigEntry.getValue();
            MessageConsumerPlugin consumerPlugin = Optional.ofNullable(this.consumerPluginMap.get(consumerConfig.getSource())).orElseThrow(() -> new ConfigException.BadValue(tag + ".consumer.source", "No message consumer plugin found for source: " + consumerConfig.getSource()));
            ModelSerializer serializer = Optional.ofNullable(this.serializerMap.get(consumerConfig.getFormat())).orElseThrow(() -> new ConfigException.BadValue(tag + ".consumer.format", "No message formatter plugin found for format: " + consumerConfig.getFormat()));
            consumerPlugin.start(consumerConfig, serializer);
        });
    }

    @Override
    @PreDestroy
    public void stop() {
        this.consumerConfigMap.entrySet().stream().filter(consumerConfigEntry -> ((MessageConsumerConfig)consumerConfigEntry.getValue()).isActive()).forEach(consumerConfigEntry -> {
            MessageConsumerConfig consumerConfig = (MessageConsumerConfig)consumerConfigEntry.getValue();
            MessageConsumerPlugin consumerPlugin = this.consumerPluginMap.get(consumerConfig.getSource());
            consumerPlugin.stop(consumerConfig);
        });
    }
}

