/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.core.producer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.typesafe.config.ConfigException;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import net.spals.appbuilder.annotations.service.AutoBindSingleton;
import net.spals.appbuilder.config.message.MessageProducerConfig;
import net.spals.appbuilder.message.core.MessageProducer;
import net.spals.appbuilder.message.core.producer.MessageProducerPlugin;
import net.spals.appbuilder.model.core.ModelSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoBindSingleton(baseClass=MessageProducer.class)
class DefaultMessageProducer
implements MessageProducer {
    private final Map<String, MessageProducerConfig> producerConfigMap;
    private final Map<String, ModelSerializer> serializerMap;
    private final Map<String, MessageProducerPlugin> producerPluginMap;

    @Inject
    DefaultMessageProducer(Map<String, MessageProducerConfig> producerConfigMap, Map<String, ModelSerializer> serializerMap, Map<String, MessageProducerPlugin> producerPluginMap) {
        this.producerConfigMap = producerConfigMap;
        this.serializerMap = serializerMap;
        this.producerPluginMap = producerPluginMap;
    }

    @Override
    public void sendMessage(String tag, Object payload) {
        byte[] serializedPayload;
        Preconditions.checkNotNull((Object)tag, (Object)"Cannot send Message with null tag");
        Preconditions.checkNotNull((Object)payload, (Object)"Cannot send Message with null payload");
        MessageProducerConfig producerConfig = this.loadProducerConfig(tag);
        Logger logger = this.loadLogger(producerConfig);
        ModelSerializer modelSerializer = this.loadModelSerializer(producerConfig);
        MessageProducerPlugin messageProducerPlugin = this.loadMessageProducerPlugin(producerConfig);
        try {
            serializedPayload = modelSerializer.serialize(payload);
        }
        catch (IOException e) {
            logger.error("Error while serializing message payload with " + producerConfig.getFormat(), (Throwable)e);
            return;
        }
        try {
            messageProducerPlugin.sendMessage(producerConfig, serializedPayload);
        }
        catch (IOException e) {
            logger.error("Error while sending message to " + producerConfig.getDestination(), (Throwable)e);
            return;
        }
    }

    Logger loadLogger(MessageProducerConfig producerConfig) {
        return LoggerFactory.getLogger((String)(DefaultMessageProducer.class.getName() + "[" + producerConfig.getTag() + "]"));
    }

    ModelSerializer loadModelSerializer(MessageProducerConfig producerConfig) {
        return Optional.ofNullable(this.serializerMap.get(producerConfig.getFormat())).orElseThrow(() -> new ConfigException.BadValue(producerConfig.getTag() + ".producer.format", "No model serializer plugin found for format: " + producerConfig.getFormat()));
    }

    MessageProducerPlugin loadMessageProducerPlugin(MessageProducerConfig producerConfig) {
        return Optional.ofNullable(this.producerPluginMap.get(producerConfig.getDestination())).orElseThrow(() -> new ConfigException.BadValue(producerConfig.getTag() + ".producer.destination", "No message producer plugin found for destination: " + producerConfig.getDestination()));
    }

    MessageProducerConfig loadProducerConfig(String tag) {
        return Optional.ofNullable(this.producerConfigMap.get(tag)).orElseThrow(() -> new IllegalArgumentException("No MessageProducerConfig found for tag '" + tag + "'"));
    }
}

