/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.bootstrap.spring4;

import net.stickycode.bootstrap.StickyBootstrap;
import net.stickycode.bootstrap.spring4.StickyScopeMetadataResolver;
import net.stickycode.stereotype.StickyComponent;
import net.stickycode.stereotype.StickyDomain;
import net.stickycode.stereotype.StickyPlugin;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;

public class Spring4StickyBootstrap
implements StickyBootstrap {
    private GenericApplicationContext context;

    public Spring4StickyBootstrap() {
        this.context = new GenericApplicationContext();
        this.scan("net.stickycode");
    }

    public Spring4StickyBootstrap(GenericApplicationContext context) {
        this.context = context;
        this.scan("net.stickycode");
    }

    public Spring4StickyBootstrap(String ... paths) {
        this(new GenericApplicationContext());
        if (paths != null && paths.length > 0) {
            this.scan(paths);
        }
    }

    public StickyBootstrap scan(String ... paths) {
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)this.context, false);
        scanner.setScopeMetadataResolver((ScopeMetadataResolver)new StickyScopeMetadataResolver());
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(StickyComponent.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(StickyDomain.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(StickyPlugin.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Component.class));
        scanner.scan(paths);
        return this;
    }

    public AutowireCapableBeanFactory getAutowirer() {
        if (!this.context.isActive()) {
            this.context.refresh();
        }
        return this.context.getAutowireCapableBeanFactory();
    }

    public StickyBootstrap inject(Object value) {
        this.getAutowirer().autowireBean(value);
        return this;
    }

    public <T> T find(Class<T> type) {
        return (T)this.context.getBean(type);
    }
}

