/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.crm.ports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.tangly.bus.core.Address;
import net.tangly.bus.core.Comment;
import net.tangly.bus.core.Entity;
import net.tangly.bus.core.EntityImp;
import net.tangly.bus.core.HasComments;
import net.tangly.bus.core.HasEditableQualifiers;
import net.tangly.bus.core.HasId;
import net.tangly.bus.core.HasOid;
import net.tangly.bus.core.HasQualifiers;
import net.tangly.bus.core.HasTags;
import net.tangly.bus.core.PhoneNr;
import net.tangly.bus.core.Tag;
import net.tangly.bus.crm.Activity;
import net.tangly.bus.crm.ActivityCode;
import net.tangly.bus.crm.BankConnection;
import net.tangly.bus.crm.Contract;
import net.tangly.bus.crm.CrmEntity;
import net.tangly.bus.crm.Employee;
import net.tangly.bus.crm.GenderCode;
import net.tangly.bus.crm.Interaction;
import net.tangly.bus.crm.InteractionCode;
import net.tangly.bus.crm.LegalEntity;
import net.tangly.bus.crm.NaturalEntity;
import net.tangly.bus.crm.Subject;
import net.tangly.bus.invoices.Product;
import net.tangly.bus.providers.InstanceProviderInMemory;
import net.tangly.bus.providers.Provider;
import net.tangly.commons.lang.ReflectionUtilities;
import net.tangly.commons.lang.Strings;
import net.tangly.commons.logger.EventData;
import net.tangly.crm.ports.Crm;
import net.tangly.gleam.model.TsvEntity;
import net.tangly.gleam.model.TsvProperty;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrmTsvHdl {
    public static final String OID = "oid";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String FROM_DATE = "fromDate";
    public static final String TO_DATE = "toDate";
    public static final String TEXT = "text";
    public static final String FIRSTNAME = "firstname";
    public static final String LASTNAME = "lastname";
    private static final String STREET = "street";
    private static final String POSTCODE = "postcode";
    private static final String LOCALITY = "locality";
    private static final String REGION = "region";
    private static final String COUNTRY = "country";
    private static final String IBAN = "iban";
    private static final String BIC = "bic";
    private static final String INSTITUTE = "institute";
    private static final String OWNED_BY = "ownedBy";
    private static final String CREATED = "created";
    private static final String AUTHOR = "author";
    private static final String TAGS = "tags";
    private static final CSVFormat FORMAT = CSVFormat.TDF.withFirstRecordAsHeader().withIgnoreHeaderCase(true).withRecordSeparator('\n');
    private static final Logger logger = LoggerFactory.getLogger(CrmTsvHdl.class);
    private final Crm crm;

    public CrmTsvHdl(@NotNull Crm crm) {
        this.crm = crm;
    }

    public void importComments(@NotNull Path path) {
        InstanceProviderInMemory comments = new InstanceProviderInMemory();
        this.importEntities(path, (TsvEntity)CrmTsvHdl.createTsvComment(), (Provider)comments);
        this.crm.naturalEntities().getAll().forEach(arg_0 -> this.lambda$importComments$0((Provider)comments, arg_0));
        this.crm.legalEntities().getAll().forEach(arg_0 -> this.lambda$importComments$1((Provider)comments, arg_0));
        this.crm.employees().getAll().forEach(arg_0 -> this.lambda$importComments$2((Provider)comments, arg_0));
        this.crm.contracts().getAll().forEach(arg_0 -> this.lambda$importComments$3((Provider)comments, arg_0));
        this.crm.subjects().getAll().forEach(arg_0 -> this.lambda$importComments$4((Provider)comments, arg_0));
        this.crm.interactions().getAll().forEach(arg_0 -> this.lambda$importComments$5((Provider)comments, arg_0));
        this.crm.activities().getAll().forEach(arg_0 -> this.lambda$importComments$6((Provider)comments, arg_0));
    }

    public void exportComments(@NotNull Path path) {
        InstanceProviderInMemory comments = new InstanceProviderInMemory();
        this.crm.naturalEntities().getAll().forEach(arg_0 -> CrmTsvHdl.lambda$exportComments$7((Provider)comments, arg_0));
        this.crm.legalEntities().getAll().forEach(arg_0 -> CrmTsvHdl.lambda$exportComments$8((Provider)comments, arg_0));
        this.crm.employees().getAll().forEach(arg_0 -> CrmTsvHdl.lambda$exportComments$9((Provider)comments, arg_0));
        this.crm.contracts().getAll().forEach(arg_0 -> CrmTsvHdl.lambda$exportComments$10((Provider)comments, arg_0));
        this.crm.subjects().getAll().forEach(arg_0 -> CrmTsvHdl.lambda$exportComments$11((Provider)comments, arg_0));
        this.crm.interactions().getAll().forEach(arg_0 -> CrmTsvHdl.lambda$exportComments$12((Provider)comments, arg_0));
        this.crm.activities().getAll().forEach(arg_0 -> CrmTsvHdl.lambda$exportComments$13((Provider)comments, arg_0));
        this.exportEntities(path, (TsvEntity)CrmTsvHdl.createTsvComment(), (Provider)comments);
    }

    public void importNaturalEntities(@NotNull Path path) {
        this.importEntities(path, (TsvEntity)CrmTsvHdl.createTsvNaturalEntity(), (Provider)this.crm.naturalEntities());
    }

    public void exportNaturalEntities(@NotNull Path path) {
        this.exportEntities(path, (TsvEntity)CrmTsvHdl.createTsvNaturalEntity(), (Provider)this.crm.naturalEntities());
    }

    public void importLegalEntities(@NotNull Path path) {
        this.importEntities(path, (TsvEntity)CrmTsvHdl.createTsvLegalEntity(), (Provider)this.crm.legalEntities());
    }

    public void exportLegalEntities(@NotNull Path path) {
        this.exportEntities(path, (TsvEntity)CrmTsvHdl.createTsvLegalEntity(), (Provider)this.crm.legalEntities());
    }

    public void importEmployees(@NotNull Path path) {
        this.importEntities(path, (TsvEntity)this.createTsvEmployee(), (Provider)this.crm.employees());
    }

    public void exportEmployees(@NotNull Path path) {
        this.exportEntities(path, (TsvEntity)this.createTsvEmployee(), (Provider)this.crm.employees());
    }

    public void importContracts(@NotNull Path path) {
        this.importEntities(path, (TsvEntity)this.createTsvContract(), (Provider)this.crm.contracts());
    }

    public void exportContracts(@NotNull Path path) {
        this.exportEntities(path, (TsvEntity)this.createTsvContract(), (Provider)this.crm.contracts());
    }

    public void importProducts(@NotNull Path path) {
        this.importEntities(path, (TsvEntity)CrmTsvHdl.createTsvProduct(), (Provider)this.crm.products());
    }

    public void exportProducts(@NotNull Path path) {
        this.exportEntities(path, (TsvEntity)CrmTsvHdl.createTsvProduct(), (Provider)this.crm.products());
    }

    public void importSubjects(@NotNull Path path) {
        this.importEntities(path, (TsvEntity)this.createTsvSubject(), (Provider)this.crm.subjects());
    }

    public void exportSubjects(@NotNull Path path) {
        this.exportEntities(path, (TsvEntity)this.createTsvSubject(), (Provider)this.crm.subjects());
    }

    public void importInteractions(@NotNull Path path) {
        this.importEntities(path, (TsvEntity)CrmTsvHdl.createTsvInteraction(), (Provider)this.crm.interactions());
    }

    public void exportInteractions(@NotNull Path path) {
        this.exportEntities(path, (TsvEntity)CrmTsvHdl.createTsvInteraction(), (Provider)this.crm.interactions());
    }

    public void importActivities(@NotNull Path path) {
        this.importEntities(path, (TsvEntity)CrmTsvHdl.createTsvActivity(), (Provider)this.crm.activities());
    }

    public void exportActivities(@NotNull Path path) {
        this.exportEntities(path, (TsvEntity)CrmTsvHdl.createTsvActivity(), (Provider)this.crm.activities());
    }

    <T> void importEntities(@NotNull Path path, @NotNull TsvEntity<T> tsvEntity, Provider<T> provider) {
        try (BufferedReader in = new BufferedReader(Files.newBufferedReader(path, StandardCharsets.UTF_8));){
            int counter = 0;
            for (CSVRecord record : FORMAT.parse((Reader)in)) {
                Object entity = tsvEntity.imports(record);
                provider.update(entity);
                ++counter;
                EventData.log((String)"import", (String)"net.tangly.ports", (EventData.Status)EventData.Status.SUCCESS, (String)(tsvEntity.clazz().getSimpleName() + " imported"), Map.of("filename", path, "entity", entity));
            }
            EventData.log((String)"import", (String)"net.tangly.ports", (EventData.Status)EventData.Status.SUCCESS, (String)"imported from TSV file", Map.of("filename", path, "counter", counter));
        }
        catch (IOException e) {
            EventData.log((String)"import", (String)"net.tangly.ports", (EventData.Status)EventData.Status.FAILURE, (String)"Entities imported from TSV file", Map.of("filename", path), (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    <T> void exportEntities(@NotNull Path path, @NotNull TsvEntity<T> tsvEntity, @NotNull Provider<T> provider) {
        try (CSVPrinter out = new CSVPrinter((Appendable)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]), FORMAT);){
            int counter = 0;
            tsvEntity.headers().forEach(e -> TsvProperty.print((CSVPrinter)out, (Object)e));
            out.println();
            for (Object entity : provider.getAll()) {
                tsvEntity.exports(entity, out);
                out.println();
                ++counter;
                EventData.log((String)"export", (String)"net.tangly.ports", (EventData.Status)EventData.Status.SUCCESS, (String)(tsvEntity.clazz().getSimpleName() + " exported to TSV file"), Map.of("filename", path, "entity", entity));
            }
            EventData.log((String)"export", (String)"net.tangly.ports", (EventData.Status)EventData.Status.SUCCESS, (String)"exported to TSV file", Map.of("filename", path, "counter", counter));
        }
        catch (IOException e2) {
            EventData.log((String)"export", (String)"net.tangly.ports", (EventData.Status)EventData.Status.FAILURE, (String)"Entities exported to TSV file", Map.of("filename", path), (Throwable)e2);
            throw new UncheckedIOException(e2);
        }
    }

    static <T extends Entity> List<TsvProperty<T, ?>> createTsvEntityFields() {
        ArrayList fields = new ArrayList();
        fields.add(TsvProperty.of((String)OID, HasOid::oid, (entity, value) -> ReflectionUtilities.set((Object)entity, (String)OID, (Object)value), Long::parseLong));
        fields.add(TsvProperty.ofString((String)ID, HasId::id, HasEditableQualifiers::id));
        fields.add(TsvProperty.ofString((String)NAME, HasQualifiers::name, HasEditableQualifiers::name));
        fields.add(TsvProperty.of((String)FROM_DATE, Entity::fromDate, Entity::fromDate, (Function)TsvProperty.CONVERT_DATE_FROM));
        fields.add(TsvProperty.of((String)TO_DATE, Entity::toDate, Entity::toDate, (Function)TsvProperty.CONVERT_DATE_FROM));
        fields.add(TsvProperty.ofString((String)TEXT, HasQualifiers::text, HasEditableQualifiers::text));
        return fields;
    }

    static TsvEntity<Comment> createTsvComment() {
        Function<CSVRecord, Comment> imports = record -> Comment.of((LocalDateTime)LocalDateTime.parse(CrmTsvHdl.get(record, CREATED)), (long)Long.parseLong(CrmTsvHdl.get(record, OWNED_BY)), (String)CrmTsvHdl.get(record, AUTHOR), (String)CrmTsvHdl.get(record, TEXT), (Tag[])new Tag[0]);
        ArrayList<TsvProperty> fields = new ArrayList<TsvProperty>();
        fields.add(TsvProperty.of((String)OID, Comment::oid, (entity, value) -> ReflectionUtilities.set((Object)entity, (String)OID, (Object)value), Long::parseLong));
        fields.add(TsvProperty.ofLong((String)OWNED_BY, Comment::ownedBy, null));
        fields.add(TsvProperty.of((String)CREATED, Comment::created, null, o -> o != null ? LocalDateTime.parse(o) : null));
        fields.add(TsvProperty.ofString((String)AUTHOR, Comment::author, null));
        fields.add(TsvProperty.ofString((String)TEXT, Comment::text, null));
        fields.add(TsvProperty.ofString((String)TAGS, HasTags::rawTags, HasTags::rawTags));
        return TsvEntity.of(Comment.class, fields, imports);
    }

    static TsvEntity<NaturalEntity> createTsvNaturalEntity() {
        List fields = CrmTsvHdl.createTsvEntityFields();
        fields.add(TsvProperty.ofString((String)LASTNAME, NaturalEntity::lastname, NaturalEntity::lastname));
        fields.add(TsvProperty.ofString((String)FIRSTNAME, NaturalEntity::firstname, NaturalEntity::firstname));
        fields.add(TsvProperty.of((String)"gender", NaturalEntity::gender, NaturalEntity::gender, e -> Enum.valueOf(GenderCode.class, e), Enum::name));
        fields.add(CrmTsvHdl.createAddressMapping("home"));
        fields.add(TsvProperty.ofString((String)"crm:email-home", e -> e.email("home").orElse(""), (e, p) -> e.email("home", p)));
        fields.add(TsvProperty.ofString((String)"crm:phone-mobile", e -> e.phoneNr("mobile").map(PhoneNr::number).orElse(""), (e, p) -> e.phoneNr("mobile", p)));
        fields.add(CrmTsvHdl.tagProperty("crm:im-linkedIn"));
        fields.add(CrmTsvHdl.tagProperty("crm:site-home"));
        return TsvEntity.of(NaturalEntity.class, fields, NaturalEntity::new);
    }

    static TsvEntity<LegalEntity> createTsvLegalEntity() {
        List fields = CrmTsvHdl.createTsvEntityFields();
        fields.add(TsvProperty.ofString((String)"crm:vat-number", LegalEntity::vatNr, LegalEntity::vatNr));
        fields.add(CrmTsvHdl.tagProperty("crm:im-linkedIn"));
        fields.add(CrmTsvHdl.tagProperty("crm:email-work"));
        fields.add(CrmTsvHdl.tagProperty("crm:site-work"));
        fields.add(TsvProperty.ofString((String)"crm:phone-work", e -> e.phoneNr("work").map(PhoneNr::number).orElse(""), (e, p) -> e.phoneNr("work", p)));
        fields.add(CrmTsvHdl.createAddressMapping("work"));
        return TsvEntity.of(LegalEntity.class, fields, LegalEntity::new);
    }

    TsvEntity<Employee> createTsvEmployee() {
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(TsvProperty.of((String)OID, EntityImp::oid, (entity, value) -> ReflectionUtilities.set((Object)entity, (String)OID, (Object)value), Long::parseLong));
        fields.add(TsvProperty.ofString((String)ID, EntityImp::id, HasEditableQualifiers::id));
        fields.add(TsvProperty.of((String)FROM_DATE, EntityImp::fromDate, Entity::fromDate, (Function)TsvProperty.CONVERT_DATE_FROM));
        fields.add(TsvProperty.of((String)TO_DATE, EntityImp::toDate, EntityImp::toDate, (Function)TsvProperty.CONVERT_DATE_FROM));
        fields.add(TsvProperty.ofString((String)TEXT, EntityImp::text, EntityImp::text));
        fields.add(TsvProperty.of((String)"personOid", Employee::person, Employee::person, e -> this.findNaturalEntityByOid((String)e).orElse(null), CrmTsvHdl.convertFoidTo()));
        fields.add(TsvProperty.of((String)"organizationOid", Employee::organization, Employee::organization, e -> this.findLegalEntityByOid((String)e).orElse(null), CrmTsvHdl.convertFoidTo()));
        fields.add(CrmTsvHdl.tagProperty("crm:title"));
        fields.add(CrmTsvHdl.tagProperty("crm:email-work"));
        fields.add(TsvProperty.ofString((String)"crm:phone-work", e -> e.phoneNr("work").map(PhoneNr::number).orElse(""), (e, p) -> e.phoneNr("work", p)));
        return TsvEntity.of(Employee.class, fields, Employee::new);
    }

    TsvEntity<Contract> createTsvContract() {
        List fields = CrmTsvHdl.createTsvEntityFields();
        fields.add(TsvProperty.of(CrmTsvHdl.createTsvBankConnection(), Contract::bankConnection, Contract::bankConnection));
        fields.add(TsvProperty.ofBigDecimal((String)"amountWithoutVat", Contract::amountWithoutVat, Contract::amountWithoutVat));
        fields.add(TsvProperty.of((String)"sellerOid", Contract::seller, Contract::seller, e -> this.findLegalEntityByOid((String)e).orElse(null), CrmTsvHdl.convertFoidTo()));
        fields.add(TsvProperty.of((String)"selleeOid", Contract::sellee, Contract::sellee, e -> this.findLegalEntityByOid((String)e).orElse(null), CrmTsvHdl.convertFoidTo()));
        return TsvEntity.of(Contract.class, fields, Contract::new);
    }

    static TsvEntity<Product> createTsvProduct() {
        Function<CSVRecord, Product> imports = record -> new Product(CrmTsvHdl.get(record, ID), CrmTsvHdl.get(record, NAME), CrmTsvHdl.get(record, TEXT), (BigDecimal)TsvProperty.CONVERT_BIGDECIMAL_FROM.apply(CrmTsvHdl.get(record, "unitPrice")), CrmTsvHdl.get(record, "unit"), (BigDecimal)TsvProperty.CONVERT_BIGDECIMAL_FROM.apply(CrmTsvHdl.get(record, "vatRate")));
        ArrayList<TsvProperty> fields = new ArrayList<TsvProperty>();
        fields.add(TsvProperty.ofString((String)ID, Product::id, null));
        fields.add(TsvProperty.ofString((String)NAME, Product::name, null));
        fields.add(TsvProperty.ofString((String)TEXT, Product::text, null));
        fields.add(TsvProperty.ofBigDecimal((String)"unitPrice", Product::unitPrice, null));
        fields.add(TsvProperty.ofString((String)"unit", Product::unit, null));
        fields.add(TsvProperty.ofBigDecimal((String)"vatRate", Product::vatRate, null));
        return TsvEntity.of(Product.class, fields, imports);
    }

    TsvEntity<Subject> createTsvSubject() {
        List fields = CrmTsvHdl.createTsvEntityFields();
        fields.add(TsvProperty.of((String)"userOid", Subject::user, Subject::user, e -> this.findNaturalEntityByOid((String)e).orElse(null), CrmTsvHdl.convertFoidTo()));
        fields.add(TsvProperty.ofString((String)"gravatarEmail", Subject::gravatarEmail, Subject::gravatarEmail));
        fields.add(TsvProperty.ofString((String)"passwordSalt", Subject::passwordSalt, Subject::passwordSalt));
        fields.add(TsvProperty.ofString((String)"passwordHash", Subject::passwordHash, Subject::passwordHash));
        fields.add(TsvProperty.ofString((String)"gmailUsername", Subject::gmailUsername, Subject::gmailUsername));
        fields.add(TsvProperty.ofString((String)"gmailPassword", Subject::gmailPassword, Subject::gmailPassword));
        return TsvEntity.of(Subject.class, fields, Subject::new);
    }

    static TsvEntity<Interaction> createTsvInteraction() {
        List fields = CrmTsvHdl.createTsvEntityFields();
        fields.add(TsvProperty.of((String)"state", Interaction::state, Interaction::state, e -> Enum.valueOf(InteractionCode.class, e), Enum::name));
        fields.add(TsvProperty.ofBigDecimal((String)"potential", Interaction::potential, Interaction::potential));
        fields.add(TsvProperty.ofBigDecimal((String)"probability", Interaction::probability, Interaction::probability));
        return TsvEntity.of(Interaction.class, fields, Interaction::new);
    }

    static TsvEntity<Activity> createTsvActivity() {
        List fields = CrmTsvHdl.createTsvEntityFields();
        fields.add(TsvProperty.of((String)"code", Activity::code, Activity::code, e -> Enum.valueOf(ActivityCode.class, e), Enum::name));
        fields.add(TsvProperty.ofInt((String)"durationInMinutes", Activity::durationInMinutes, Activity::durationInMinutes));
        fields.add(TsvProperty.ofString((String)"details", Activity::details, Activity::details));
        return TsvEntity.of(Activity.class, fields, Activity::new);
    }

    static TsvEntity<BankConnection> createTsvBankConnection() {
        Function<CSVRecord, BankConnection> imports = record -> {
            BankConnection connection = new BankConnection(CrmTsvHdl.get(record, IBAN), CrmTsvHdl.get(record, BIC), CrmTsvHdl.get(record, INSTITUTE));
            if (!connection.isValid()) {
                logger.atWarn().log("Invalid bank connection {}", (Object)connection);
            }
            return connection;
        };
        ArrayList<TsvProperty> fields = new ArrayList<TsvProperty>();
        fields.add(TsvProperty.ofString((String)IBAN, BankConnection::iban, null));
        fields.add(TsvProperty.ofString((String)BIC, BankConnection::bic, null));
        fields.add(TsvProperty.ofString((String)INSTITUTE, BankConnection::institute, null));
        return TsvEntity.of(BankConnection.class, fields, imports);
    }

    static TsvEntity<Address> createTsvAddress() {
        Function<CSVRecord, Address> imports = record -> Address.builder().street(CrmTsvHdl.get(record, STREET)).postcode(CrmTsvHdl.get(record, POSTCODE)).locality(CrmTsvHdl.get(record, LOCALITY)).region(CrmTsvHdl.get(record, REGION)).country(CrmTsvHdl.get(record, COUNTRY)).build();
        ArrayList<TsvProperty> fields = new ArrayList<TsvProperty>();
        fields.add(TsvProperty.ofString((String)STREET, Address::street, null));
        fields.add(TsvProperty.ofString((String)"extended", Address::extended, null));
        fields.add(TsvProperty.ofString((String)POSTCODE, Address::postcode, null));
        fields.add(TsvProperty.ofString((String)LOCALITY, Address::locality, null));
        fields.add(TsvProperty.ofString((String)REGION, Address::region, null));
        fields.add(TsvProperty.ofString((String)COUNTRY, Address::country, null));
        return TsvEntity.of(Address.class, fields, imports);
    }

    <T extends HasComments & HasOid> void addComments(T entity, Provider<Comment> comments) {
        entity.addAll((Iterable)comments.getAll().stream().filter(o -> o.ownedBy() == ((HasOid)entity).oid()).collect(Collectors.toList()));
    }

    static <T extends HasTags> TsvProperty<T, String> tagProperty(String tagName) {
        return TsvProperty.ofString((String)tagName, e -> e.tag(tagName).orElse(""), (e, p) -> e.tag(tagName, p));
    }

    static <T extends CrmEntity> TsvProperty<T, Address> createAddressMapping(@NotNull String tag) {
        return TsvProperty.of(CrmTsvHdl.createTsvAddress(), e -> e.address(tag).orElse(null), (e, p) -> e.address(tag, p));
    }

    static <T extends HasOid> Function<T, Object> convertFoidTo() {
        return u -> u != null ? Long.toString(u.oid()) : "";
    }

    private static String get(@NotNull CSVRecord record, @NotNull String column) {
        return Strings.emptyToNull((String)record.get(column));
    }

    private Optional<NaturalEntity> findNaturalEntityByOid(String identifier) {
        return identifier != null ? this.crm.naturalEntities().find(Long.parseLong(identifier)) : Optional.empty();
    }

    private Optional<LegalEntity> findLegalEntityByOid(String identifier) {
        return identifier != null ? this.crm.legalEntities().find(Long.parseLong(identifier)) : Optional.empty();
    }

    private static /* synthetic */ void lambda$exportComments$13(Provider comments, Activity o) {
        comments.updateAll((Iterable)o.comments());
    }

    private static /* synthetic */ void lambda$exportComments$12(Provider comments, Interaction o) {
        comments.updateAll((Iterable)o.comments());
    }

    private static /* synthetic */ void lambda$exportComments$11(Provider comments, Subject o) {
        comments.updateAll((Iterable)o.comments());
    }

    private static /* synthetic */ void lambda$exportComments$10(Provider comments, Contract o) {
        comments.updateAll((Iterable)o.comments());
    }

    private static /* synthetic */ void lambda$exportComments$9(Provider comments, Employee o) {
        comments.updateAll((Iterable)o.comments());
    }

    private static /* synthetic */ void lambda$exportComments$8(Provider comments, LegalEntity o) {
        comments.updateAll((Iterable)o.comments());
    }

    private static /* synthetic */ void lambda$exportComments$7(Provider comments, NaturalEntity o) {
        comments.updateAll((Iterable)o.comments());
    }

    private /* synthetic */ void lambda$importComments$6(Provider comments, Activity e) {
        this.addComments(e, (Provider<Comment>)comments);
    }

    private /* synthetic */ void lambda$importComments$5(Provider comments, Interaction e) {
        this.addComments(e, (Provider<Comment>)comments);
    }

    private /* synthetic */ void lambda$importComments$4(Provider comments, Subject e) {
        this.addComments(e, (Provider<Comment>)comments);
    }

    private /* synthetic */ void lambda$importComments$3(Provider comments, Contract e) {
        this.addComments(e, (Provider<Comment>)comments);
    }

    private /* synthetic */ void lambda$importComments$2(Provider comments, Employee e) {
        this.addComments(e, (Provider<Comment>)comments);
    }

    private /* synthetic */ void lambda$importComments$1(Provider comments, LegalEntity e) {
        this.addComments(e, (Provider<Comment>)comments);
    }

    private /* synthetic */ void lambda$importComments$0(Provider comments, NaturalEntity e) {
        this.addComments(e, (Provider<Comment>)comments);
    }
}

