/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.crm.ports;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.tangly.bus.invoices.Invoice;
import net.tangly.crm.ports.Crm;
import net.tangly.crm.ports.CrmTsvHdl;
import net.tangly.invoices.ports.InvoiceJson;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CrmWorkflows {
    public static final String COMMENTS_TSV = "comments.tsv";
    public static final String LEGAL_ENTITIES_TSV = "legal-entities.tsv";
    public static final String NATURAL_ENTITIES_TSV = "natural-entities.tsv";
    public static final String EMPLOYEES_TSV = "employees.tsv";
    public static final String CONTRACTS_TSV = "contracts.tsv";
    public static final String PRODUCTS_TSV = "products.tsv";
    public static final String INTERACTIONS_TSV = "interactions.tsv";
    public static final String ACTIVITIES_TSV = "activities.tsv";
    public static final String SUBJECTS_TSV = "subjects.tsv";
    public static final String INVOICES = "invoices";
    public static final String JSON_EXT = ".json";
    public static final String INVOICE_NAME_PATTERN = "\\d{4}-\\d{4}-.*";
    private static final Logger logger = LoggerFactory.getLogger(CrmWorkflows.class);
    private final Crm crm;

    public CrmWorkflows(@NotNull Crm crm) {
        this.crm = crm;
    }

    public void importCrmEntities(@NotNull Path directory) {
        CrmTsvHdl handler = new CrmTsvHdl(this.crm);
        handler.importLegalEntities(directory.resolve(LEGAL_ENTITIES_TSV));
        handler.importNaturalEntities(directory.resolve(NATURAL_ENTITIES_TSV));
        handler.importEmployees(directory.resolve(EMPLOYEES_TSV));
        handler.importContracts(directory.resolve(CONTRACTS_TSV));
        handler.importProducts(directory.resolve(PRODUCTS_TSV));
        handler.importInteractions(directory.resolve(INTERACTIONS_TSV));
        handler.importActivities(directory.resolve(ACTIVITIES_TSV));
        handler.importSubjects(directory.resolve(SUBJECTS_TSV));
        handler.importComments(directory.resolve(COMMENTS_TSV));
        Path invoicesFolder = directory.resolve(INVOICES);
        if (Files.exists(invoicesFolder, new LinkOption[0])) {
            this.importInvoices(invoicesFolder);
        } else {
            logger.atWarn().log("Invoices folder {} does not exist", (Object)invoicesFolder);
        }
    }

    public void importInvoices(@NotNull Path directory) {
        InvoiceJson invoiceJson = new InvoiceJson(this.crm);
        try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
            stream.filter(file -> !Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().endsWith(JSON_EXT)).forEach(o -> {
                Invoice invoice = invoiceJson.imports((Path)o, Collections.emptyMap());
                if (invoice != null) {
                    this.crm.invoices().update((Object)invoice);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void exportCrmEntities(@NotNull Path directory) {
        CrmTsvHdl handler = new CrmTsvHdl(this.crm);
        handler.exportLegalEntities(directory.resolve(LEGAL_ENTITIES_TSV));
        handler.exportNaturalEntities(directory.resolve(NATURAL_ENTITIES_TSV));
        handler.exportEmployees(directory.resolve(EMPLOYEES_TSV));
        handler.exportProducts(directory.resolve(PRODUCTS_TSV));
        handler.exportContracts(directory.resolve(CONTRACTS_TSV));
        handler.exportInteractions(directory.resolve(INTERACTIONS_TSV));
        handler.exportActivities(directory.resolve(ACTIVITIES_TSV));
        handler.exportSubjects(directory.resolve(SUBJECTS_TSV));
        handler.exportComments(directory.resolve(COMMENTS_TSV));
        this.exportInvoices(directory);
    }

    public void exportInvoices(@NotNull Path directory) {
        InvoiceJson invoiceJson = new InvoiceJson(this.crm);
        Path invoicesPath = directory.resolve(INVOICES);
        Pattern pattern = Pattern.compile(INVOICE_NAME_PATTERN);
        this.crm.invoices().getAll().forEach(o -> {
            Path invoicePath;
            Matcher matcher = pattern.matcher(o.name());
            Path path = invoicePath = matcher.matches() ? invoicesPath.resolve(o.name().substring(0, 4)) : invoicesPath;
            if (Files.notExists(invoicePath, new LinkOption[0])) {
                try {
                    Files.createDirectories(invoicePath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            invoiceJson.exports((Invoice)o, invoicePath.resolve(o.name() + JSON_EXT), Collections.emptyMap());
        });
    }
}

