/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.invoices.ports;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import net.codecrete.qrbill.generator.Strings;
import net.tangly.bus.crm.LegalEntity;
import net.tangly.bus.invoices.Invoice;
import net.tangly.bus.invoices.InvoiceLine;
import net.tangly.commons.utilities.AsciiDocHelper;
import net.tangly.invoices.ports.InvoiceGenerator;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceAsciiDoc
implements InvoiceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceAsciiDoc.class);
    private static final BigDecimal HUNDRED = new BigDecimal("100");

    @Override
    public void exports(@NotNull Invoice invoice, @NotNull Path invoicePath, @NotNull Map<String, Object> properties) {
        try (PrintWriter writer = new PrintWriter(invoicePath.toFile(), StandardCharsets.UTF_8);){
            AsciiDocHelper helper = new AsciiDocHelper(writer);
            writer.println("image::trefoil.svg[100,100,align=\"center\"]");
            writer.println();
            helper.header("Invoice", 2);
            helper.tableHeader(null, "frame=\"none\", grid=\"none\", options=\"noheader\", stripes=\"none\", cols=\"2,4,2\"", new String[0]);
            helper.tableRow(new String[]{InvoiceAsciiDoc.addressText(invoice.invoicingEntity()), "", InvoiceAsciiDoc.addressText(invoice.invoicedEntity())});
            helper.tableEnd();
            helper.tableHeader(null, "stripes=\"none\", options=\"noheader\", cols=\"4,2,4,2\"", new String[0]);
            helper.tableRow(new String[]{"Invoice Number", invoice.id(), "Invoice Date", invoice.invoicedDate().toString()});
            helper.tableRow(new String[]{"", "", "Invoice Due Date", invoice.dueDate().toString()});
            helper.tableEnd();
            writer.println("*" + invoice.text() + "*");
            writer.println();
            helper.tableHeader(null, "options=\"header\", grid=\"none\", frame=\"none\", stripes=\"none\", cols=\"4,^1, >1,>1\"", new String[]{"Position", "Quantity", "Price", "Amount (CHF)"});
            invoice.lines().stream().sorted(Comparator.comparingInt(InvoiceLine::position)).forEach(o -> helper.tableRow(new String[]{o.isAggregate() ? AsciiDocHelper.italics((String)o.text()) : o.text(), o.isItem() ? AsciiDocHelper.format((BigDecimal)o.quantity()) : "", AsciiDocHelper.format((BigDecimal)o.unitPrice()), o.isAggregate() ? AsciiDocHelper.italics((String)AsciiDocHelper.format((BigDecimal)o.amount())) : AsciiDocHelper.format((BigDecimal)o.amount())}));
            InvoiceAsciiDoc.createVatDeclarations(helper, invoice);
            helper.tableEnd();
            writer.println();
            helper.tableHeader(null, "frame=\"none\",grid=\"none\", options=\"noheader\", cols=\"2,4\"", new String[0]);
            helper.tableRow(new String[]{"Bank Connection", "IBAN: " + invoice.invoicingConnection().iban() + AsciiDocHelper.NEWLINE + "BIC: " + invoice.invoicingConnection().bic() + " (" + invoice.invoicingConnection().institute() + ")"});
            helper.tableEnd();
            helper.tableHeader(null, "frame=\"none\",grid=\"none\", options=\"noheader\", cols=\"2,4\"", new String[0]);
            helper.tableRow(new String[]{"Company ID:", invoice.invoicedEntity().id()});
            helper.tableRow(new String[]{"Company VAT Number:", invoice.invoicedEntity().vatNr()});
            helper.tableEnd();
            if (!Strings.isNullOrEmpty((String)invoice.paymentConditions())) {
                writer.append("Payment Conditions").append(" ").append(invoice.paymentConditions()).println();
            }
        }
        catch (Exception e) {
            logger.atError().setCause((Throwable)e).log("Error during invoice asciiDoc generation {}", (Object)invoicePath);
        }
        InvoiceAsciiDoc.createPdf(invoicePath);
    }

    private static void createVatDeclarations(AsciiDocHelper helper, Invoice invoice) {
        helper.tableRow(new String[]{"", "", "", ""});
        helper.tableRow(new String[]{"Total without VAT", "", "", AsciiDocHelper.format((BigDecimal)invoice.amountWithoutVat())});
        if (invoice.hasMultipleVatRates()) {
            String vats = invoice.vatAmounts().entrySet().stream().map(o -> ((BigDecimal)o.getKey()).multiply(HUNDRED).stripTrailingZeros().toPlainString() + "% : " + ((BigDecimal)o.getValue()).stripTrailingZeros().toPlainString()).collect(Collectors.joining(", ", "(", ")"));
            helper.tableRow(new String[]{AsciiDocHelper.italics((String)("VAT Amount " + vats)), "", "", AsciiDocHelper.italics((String)AsciiDocHelper.format((BigDecimal)invoice.vat()))});
        } else {
            helper.tableRow(new String[]{AsciiDocHelper.italics((String)"VAT Amount"), "", AsciiDocHelper.italics((String)((BigDecimal)invoice.uniqueVatRate().orElseThrow()).multiply(HUNDRED).stripTrailingZeros().toPlainString()) + "%", AsciiDocHelper.italics((String)AsciiDocHelper.format((BigDecimal)invoice.vat()))});
        }
        helper.tableRow(new String[]{AsciiDocHelper.bold((String)"Total"), "", "", AsciiDocHelper.bold((String)AsciiDocHelper.format((BigDecimal)invoice.amountWithVat()))});
    }

    private static void createPdf(@NotNull Path invoicePath) {
        try (Asciidoctor asciidoctor = Asciidoctor.Factory.create();){
            Map options = OptionsBuilder.options().inPlace(true).backend("pdf").asMap();
            asciidoctor.convertFile(invoicePath.toFile(), options);
        }
    }

    private static String addressText(@NotNull LegalEntity entity) {
        StringBuilder text = new StringBuilder();
        entity.address("crm:address-work").ifPresent(address -> text.append(entity.name()).append(AsciiDocHelper.NEWLINE).append((String)(Strings.isNullOrEmpty((String)address.extended()) ? "" : address.extended() + AsciiDocHelper.NEWLINE)).append((String)(Strings.isNullOrEmpty((String)address.street()) ? "" : address.street() + AsciiDocHelper.NEWLINE)).append((String)(Strings.isNullOrEmpty((String)address.poBox()) ? "" : address.poBox() + AsciiDocHelper.NEWLINE)).append(address.postcode()).append(" ").append(address.locality()));
        return text.toString();
    }
}

