/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.invoices.ports;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.tangly.bus.core.Address;
import net.tangly.bus.core.EntityImp;
import net.tangly.bus.crm.BankConnection;
import net.tangly.bus.crm.Contract;
import net.tangly.bus.crm.LegalEntity;
import net.tangly.bus.invoices.Invoice;
import net.tangly.bus.invoices.InvoiceItem;
import net.tangly.bus.invoices.InvoiceLine;
import net.tangly.bus.invoices.Product;
import net.tangly.bus.invoices.Subtotal;
import net.tangly.commons.logger.EventData;
import net.tangly.commons.utilities.JsonUtilities;
import net.tangly.crm.ports.Crm;
import net.tangly.gleam.model.JsonArray;
import net.tangly.gleam.model.JsonEntity;
import net.tangly.gleam.model.JsonProperty;
import net.tangly.invoices.ports.InvoiceGenerator;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceJson
implements InvoiceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceJson.class);
    private final Crm crm;

    public InvoiceJson(@NotNull Crm crm) {
        this.crm = crm;
    }

    @Override
    public void exports(@NotNull Invoice invoice, @NotNull Path path, @NotNull Map<String, Object> properties) {
        JsonEntity<Invoice> entity = this.createJsonInvoice();
        JSONObject invoiceJson = entity.exports((Object)invoice);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(invoiceJson.toString(4));
            EventData.log((String)"export", (String)"net.tangly.ports", (EventData.Status)EventData.Status.SUCCESS, (String)"Invoice exported to JSON file", Map.of("filename", path, "entity", invoice));
        }
        catch (IOException e) {
            EventData.log((String)"export", (String)"net.tangly.ports", (EventData.Status)EventData.Status.FAILURE, (String)"Invoice exported to JSON file", Map.of("filename", path), (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    public Invoice imports(@NotNull Path path, @NotNull Map<String, Object> properties) {
        Invoice invoice;
        block9: {
            JsonEntity<Invoice> entity = this.createJsonInvoice();
            invoice = null;
            if (JsonUtilities.isValid((Path)path, (String)"invoice-schema.json")) {
                try (BufferedReader in = new BufferedReader(Files.newBufferedReader(path, StandardCharsets.UTF_8));){
                    JSONObject jsonInvoice = new JSONObject(new JSONTokener((Reader)in));
                    invoice = (Invoice)entity.imports(jsonInvoice);
                    if (!invoice.isValid()) {
                        logger.atWarn().log("Invoice {} is invalid", (Object)invoice.name());
                    }
                    EventData.log((String)"import", (String)"net.tangly.ports", (EventData.Status)EventData.Status.SUCCESS, (String)"Invoice imported", Map.of("filename", path, "entity", invoice));
                    break block9;
                }
                catch (IOException e) {
                    EventData.log((String)"import", (String)"net.tangly.ports", (EventData.Status)EventData.Status.FAILURE, (String)"Error during import of JSON file", Map.of("filename", path), (Throwable)e);
                    throw new UncheckedIOException(e);
                }
            }
            EventData.log((String)"import", (String)"net.tangly.ports", (EventData.Status)EventData.Status.FAILURE, (String)"Invalid JSON schema of JSON file", Map.of("filename", path));
        }
        return invoice;
    }

    public JsonEntity<Invoice> createJsonInvoice() {
        JsonEntity<LegalEntity> jsonLegalEntity = this.createJsonLegalEntity();
        JsonEntity<Address> jsonAddress = InvoiceJson.createJsonAddress();
        JsonEntity<BankConnection> jsonBankConnection = InvoiceJson.createJsonBankConnection();
        JsonEntity<Contract> jsonContract = this.createJsonContract();
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(JsonProperty.ofString((String)"id", Invoice::id, Invoice::id));
        fields.add(JsonProperty.ofString((String)"name", Invoice::name, Invoice::name));
        fields.add(JsonProperty.ofString((String)"text", Invoice::text, Invoice::text));
        fields.add(JsonProperty.ofType((String)"invoicingEntity", Invoice::invoicingEntity, Invoice::invoicingEntity, jsonLegalEntity));
        fields.add(JsonProperty.ofType((String)"invoicingAddress", Invoice::invoicingAddress, Invoice::invoicingAddress, jsonAddress));
        fields.add(JsonProperty.ofType((String)"invoicingConnection", Invoice::invoicingConnection, Invoice::invoicingConnection, jsonBankConnection));
        fields.add(JsonProperty.of((String)"contractId", Invoice::contract, Invoice::contract, o -> o.has("contractId") ? (Contract)this.crm.contracts().findBy(EntityImp::id, (Object)o.getString("contractId")).orElse(null) : null, (u, o) -> o.put("contractId", (Object)u.id())));
        fields.add(JsonProperty.ofType((String)"invoicedEntity", Invoice::invoicedEntity, Invoice::invoicedEntity, jsonLegalEntity));
        fields.add(JsonProperty.ofType((String)"invoicedAddress", Invoice::invoicedAddress, Invoice::invoicedAddress, jsonAddress));
        fields.add(JsonProperty.ofLocalDate((String)"deliveryDate", Invoice::deliveryDate, Invoice::deliveryDate));
        fields.add(JsonProperty.ofLocalDate((String)"invoiceDate", Invoice::invoicedDate, Invoice::invoicedDate));
        fields.add(JsonProperty.ofLocalDate((String)"dueDate", Invoice::dueDate, Invoice::dueDate));
        fields.add(JsonProperty.ofCurrency((String)"currency", Invoice::currency, Invoice::currency));
        fields.add(JsonProperty.ofString((String)"text", Invoice::text, Invoice::text));
        fields.add(JsonProperty.ofString((String)"paymentConditions", Invoice::paymentConditions, Invoice::paymentConditions));
        fields.add(this.createPositions());
        return JsonEntity.of(fields, Invoice::new);
    }

    public static JsonEntity<BankConnection> createJsonBankConnection() {
        Function<JSONObject, BankConnection> imports = object -> {
            BankConnection connection = new BankConnection(InvoiceJson.get("iban", object), InvoiceJson.get("bic", object), InvoiceJson.get("institute", object));
            return connection.isValid() ? connection : null;
        };
        ArrayList<JsonProperty> fields = new ArrayList<JsonProperty>();
        fields.add(JsonProperty.ofString((String)"iban", BankConnection::iban, null));
        fields.add(JsonProperty.ofString((String)"bic", BankConnection::bic, null));
        fields.add(JsonProperty.ofString((String)"institute", BankConnection::institute, null));
        return JsonEntity.of(fields, imports);
    }

    public static JsonEntity<Address> createJsonAddress() {
        Function<JSONObject, Address> imports = object -> new Address(InvoiceJson.get("street", object), InvoiceJson.get("extended", object), InvoiceJson.get("poBox", object), InvoiceJson.get("postCode", object), InvoiceJson.get("locality", object), InvoiceJson.get("region", object), InvoiceJson.get("country", object));
        ArrayList<JsonProperty> fields = new ArrayList<JsonProperty>();
        fields.add(JsonProperty.ofString((String)"street", Address::street, null));
        fields.add(JsonProperty.ofString((String)"extended", Address::extended, null));
        fields.add(JsonProperty.ofString((String)"poBox", Address::poBox, null));
        fields.add(JsonProperty.ofString((String)"postCode", Address::postcode, null));
        fields.add(JsonProperty.ofString((String)"locality", Address::locality, null));
        fields.add(JsonProperty.ofString((String)"region", Address::region, null));
        fields.add(JsonProperty.ofString((String)"country", Address::country, null));
        return JsonEntity.of(fields, imports);
    }

    public JsonEntity<Product> createJsonProduct() {
        ArrayList<JsonProperty> fields = new ArrayList<JsonProperty>();
        fields.add(JsonProperty.ofString((String)"id", Product::id, null));
        fields.add(JsonProperty.ofString((String)"description", Product::text, null));
        fields.add(JsonProperty.ofBigDecimal((String)"unitPrice", Product::unitPrice, null));
        fields.add(JsonProperty.ofString((String)"unit", Product::unit, null));
        fields.add(JsonProperty.ofBigDecimal((String)"vatRate", Product::vatRate, null));
        return JsonEntity.of(fields, this::importProduct);
    }

    public JsonEntity<Contract> createJsonContract() {
        Function<JSONObject, Contract> imports = object -> {
            long oid = object.getLong("contractOid");
            return this.crm.contracts().getAll().stream().filter(o -> oid == o.oid()).findAny().orElse(null);
        };
        ArrayList<JsonProperty> fields = new ArrayList<JsonProperty>();
        fields.add(JsonProperty.ofLong((String)"contractOid", EntityImp::oid, null));
        return JsonEntity.of(fields, imports);
    }

    public JsonEntity<LegalEntity> createJsonLegalEntity() {
        Function<JSONObject, LegalEntity> imports = object -> {
            String id = InvoiceJson.get("id", object);
            return id != null ? (LegalEntity)this.crm.legalEntities().getAll().stream().filter(o -> id.equals(o.id())).findAny().orElse(null) : null;
        };
        ArrayList<JsonProperty> fields = new ArrayList<JsonProperty>();
        fields.add(JsonProperty.ofString((String)"id", EntityImp::id, null));
        fields.add(JsonProperty.ofString((String)"name", EntityImp::name, null));
        fields.add(JsonProperty.ofString((String)"text", EntityImp::text, null));
        fields.add(JsonProperty.ofLocalDate((String)"fromDate", EntityImp::fromDate, null));
        fields.add(JsonProperty.ofLocalDate((String)"toDate", EntityImp::toDate, null));
        fields.add(JsonProperty.ofString((String)"vatNr", LegalEntity::vatNr, null));
        return JsonEntity.of(fields, imports);
    }

    public JsonEntity<InvoiceItem> createJsonInvoiceItem() {
        Function<JSONObject, InvoiceItem> imports = object -> new InvoiceItem(object.getInt("position"), this.importProduct((JSONObject)object.get("product")), object.getString("text"), object.getBigDecimal("quantity"));
        ArrayList<JsonProperty> fields = new ArrayList<JsonProperty>();
        fields.add(JsonProperty.ofInt((String)"position", InvoiceItem::position, null));
        fields.add(JsonProperty.ofType((String)"product", InvoiceItem::product, null, this.createJsonProduct()));
        fields.add(JsonProperty.ofString((String)"text", InvoiceItem::text, null));
        fields.add(JsonProperty.ofBigDecimal((String)"quantity", InvoiceItem::quantity, null));
        return JsonEntity.of(fields, imports);
    }

    public JsonEntity<Subtotal> createJsonSubtotal() {
        BiFunction<JSONObject, Object, Subtotal> imports = (object, entity) -> {
            Invoice invoice = (Invoice)entity;
            ArrayList<InvoiceLine> lines = new ArrayList<InvoiceLine>();
            JSONArray itemsPosition = object.getJSONArray("items");
            for (Object value : itemsPosition) {
                int position = (Integer)value;
                lines.add(invoice.lines().stream().filter(o -> position == o.position()).findAny().orElseThrow());
            }
            return new Subtotal(object.getInt("position"), object.getString("text"), lines);
        };
        BiFunction<Subtotal, Object, JSONObject> exports = (subtotal, entity) -> {
            JSONObject subtotalJson = new JSONObject();
            subtotalJson.put("position", subtotal != null ? Integer.valueOf(subtotal.position()) : null);
            subtotalJson.put("text", (Object)(subtotal != null ? subtotal.text() : null));
            JSONArray itemsPosition = new JSONArray();
            if (subtotal != null) {
                subtotal.items().forEach(o -> itemsPosition.put(o.position()));
            }
            subtotalJson.put("items", (Object)itemsPosition);
            return subtotalJson;
        };
        return JsonEntity.of(imports, exports);
    }

    public Product importProduct(JSONObject object) {
        String id = InvoiceJson.get("id", object);
        return this.crm.products().getAll().stream().filter(o -> o.id().equals(id)).findAny().orElse(null);
    }

    public JsonArray<Invoice, InvoiceLine> createPositions() {
        JsonEntity<Subtotal> jsonSubtotal = this.createJsonSubtotal();
        JsonEntity<InvoiceItem> jsonInvoiceItem = this.createJsonInvoiceItem();
        Function<JSONObject, JsonEntity> importSelector = o -> {
            if (o.has("items")) {
                return jsonSubtotal;
            }
            return jsonInvoiceItem;
        };
        Function<Object, JsonEntity> exportSelector = o -> {
            if (o instanceof InvoiceItem) {
                return jsonInvoiceItem;
            }
            if (o instanceof Subtotal) {
                return jsonSubtotal;
            }
            return null;
        };
        return new JsonArray("items", Invoice::lines, Invoice::add, importSelector, exportSelector);
    }

    private static String get(String key, JSONObject object) {
        return object.has(key) ? object.getString(key) : null;
    }
}

