/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.invoices.ports;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.codecrete.qrbill.canvas.Canvas;
import net.codecrete.qrbill.canvas.PDFCanvas;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.BillFormat;
import net.codecrete.qrbill.generator.GraphicsFormat;
import net.codecrete.qrbill.generator.Language;
import net.codecrete.qrbill.generator.OutputSize;
import net.codecrete.qrbill.generator.Payments;
import net.codecrete.qrbill.generator.QRBill;
import net.codecrete.qrbill.generator.SwicoBillInformation;
import net.tangly.bus.crm.LegalEntity;
import net.tangly.bus.invoices.Invoice;
import net.tangly.invoices.ports.InvoiceGenerator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceQrCode
implements InvoiceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceQrCode.class);
    private static final BigDecimal HUNDRED = new BigDecimal("100");
    private static final Pattern ISO11649ReferenceFormat = Pattern.compile("[^A-Za-z0-9]");

    @Override
    public void exports(@NotNull Invoice invoice, @NotNull Path invoicePath, @NotNull Map<String, Object> properties) {
        Bill bill = new Bill();
        bill.setFormat(InvoiceQrCode.createBillFormat());
        bill.setVersion(Bill.Version.V2_0);
        bill.setCreditor(InvoiceQrCode.create(invoice.invoicingEntity()));
        bill.setDebtor(InvoiceQrCode.create(invoice.invoicedEntity()));
        bill.setAccount(invoice.invoicingConnection().iban());
        bill.setAmount(invoice.amountWithVat());
        bill.setCurrency(invoice.currency().getCurrencyCode());
        bill.setBillInformation(InvoiceQrCode.createSwicoBillInformation(invoice).encodeAsText());
        bill.setReference(Payments.createISO11649Reference((String)ISO11649ReferenceFormat.matcher(invoice.id()).replaceAll("")));
        bill.setUnstructuredMessage(invoice.text());
        try (PDFCanvas canvas = new PDFCanvas(invoicePath, -2);){
            QRBill.draw((Bill)bill, (Canvas)canvas);
            canvas.saveAs(invoicePath);
        }
        catch (IOException e) {
            logger.atError().setCause((Throwable)e).log("Error when generating QR code for {}", (Object)invoicePath);
        }
    }

    private static BillFormat createBillFormat() {
        BillFormat format = new BillFormat();
        format.setLanguage(Language.EN);
        format.setOutputSize(OutputSize.A4_PORTRAIT_SHEET);
        format.setGraphicsFormat(GraphicsFormat.SVG);
        return format;
    }

    private static SwicoBillInformation createSwicoBillInformation(@NotNull Invoice invoice) {
        SwicoBillInformation swico = new SwicoBillInformation();
        swico.setInvoiceDate(invoice.invoicedDate());
        swico.setInvoiceNumber(invoice.id());
        swico.setVatNumber(invoice.invoicingEntity().id());
        swico.setCustomerReference(invoice.invoicedEntity().id());
        List details = invoice.vatAmounts().entrySet().stream().filter(o -> ((BigDecimal)o.getValue()).compareTo(BigDecimal.ZERO) != 0).map(o -> new SwicoBillInformation.RateDetail(((BigDecimal)o.getKey()).multiply(HUNDRED).stripTrailingZeros(), ((BigDecimal)o.getValue()).stripTrailingZeros())).collect(Collectors.toList());
        if (!details.isEmpty()) {
            swico.setVatRateDetails(details);
        }
        SwicoBillInformation.PaymentCondition paymentCondition = new SwicoBillInformation.PaymentCondition();
        paymentCondition.setDays(30);
        paymentCondition.setDiscount(BigDecimal.ZERO);
        swico.setPaymentConditions(List.of(paymentCondition));
        return swico;
    }

    private static Address create(@NotNull LegalEntity entity) {
        Address qrAddress = new Address();
        entity.address("work").ifPresent(address -> {
            qrAddress.setName(entity.name());
            qrAddress.setStreet(address.street());
            qrAddress.setHouseNo(null);
            qrAddress.setPostalCode(address.postcode());
            qrAddress.setTown(address.locality());
            qrAddress.setCountryCode(address.country());
        });
        return qrAddress;
    }
}

