/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.invoices.ports;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Date;
import java.util.Map;
import java.util.stream.Collectors;
import net.tangly.bus.core.Address;
import net.tangly.bus.crm.LegalEntity;
import net.tangly.bus.invoices.Invoice;
import net.tangly.bus.invoices.InvoiceItem;
import net.tangly.bus.invoices.Product;
import net.tangly.invoices.ports.InvoiceGenerator;
import org.jetbrains.annotations.NotNull;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableContact;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableProduct;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTransaction;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporter;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporterFromA1Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceZugFerd
implements IZUGFeRDExportableTransaction,
InvoiceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceZugFerd.class);
    private static final BigDecimal HUNDRED = new BigDecimal("100");
    private Invoice invoice;

    @Override
    public void exports(@NotNull Invoice invoice, @NotNull Path invoicePath, @NotNull Map<String, Object> properties) {
        this.invoice = invoice;
        try {
            ZUGFeRDExporter exporter = new ZUGFeRDExporterFromA1Factory().ignorePDFAErrors().setZUGFeRDVersion(2).setProducer("tangly ERP").setCreator(invoice.invoicingEntity().name()).load(invoicePath.toString());
            exporter.PDFattachZugferdFile((IZUGFeRDExportableTransaction)this);
            exporter.export(invoicePath.toString());
        }
        catch (IOException e) {
            logger.atError().setCause((Throwable)e).log("Could not read or write file {}", (Object)invoicePath);
        }
    }

    public String getCurrency() {
        return this.invoice.currency().getCurrencyCode();
    }

    public java.util.Date getDeliveryDate() {
        return Date.valueOf(this.invoice.invoicedDate());
    }

    public java.util.Date getDueDate() {
        return Date.valueOf(this.invoice.dueDate());
    }

    public java.util.Date getIssueDate() {
        return Date.valueOf(this.invoice.invoicedDate());
    }

    public String getNumber() {
        return this.invoice.id();
    }

    public String getOwnCountry() {
        return this.invoice.invoicingEntity().address("work").map(Address::country).orElse(null);
    }

    public String getOwnLocation() {
        return this.invoice.invoicingEntity().address("work").map(Address::locality).orElse(null);
    }

    public String getOwnOrganisationFullPlaintextInfo() {
        return this.invoice.invoicedEntity().name() + " " + (String)this.invoice.invoicingEntity().address("work").map(Address::text).orElse(null);
    }

    public String getOwnOrganisationName() {
        return this.invoice.invoicingEntity().name();
    }

    public String getOwnStreet() {
        return this.invoice.invoicingEntity().address("work").map(Address::street).orElse(null);
    }

    public String getOwnTaxID() {
        return this.invoice.invoicingEntity().id();
    }

    public String getOwnVATID() {
        return this.invoice.invoicingEntity().vatNr();
    }

    public String getOwnZIP() {
        return this.invoice.invoicingEntity().address("work").map(Address::postcode).orElse(null);
    }

    public String getPaymentTermDescription() {
        return this.invoice.paymentConditions();
    }

    public IZUGFeRDExportableContact getRecipient() {
        return new ZugFerdContact(this.invoice.invoicedEntity());
    }

    public String getReferenceNumber() {
        return this.invoice.id();
    }

    public IZUGFeRDAllowanceCharge[] getZFAllowances() {
        return null;
    }

    public IZUGFeRDAllowanceCharge[] getZFCharges() {
        return null;
    }

    public IZUGFeRDExportableItem[] getZFItems() {
        return this.invoice.items().stream().map(ZugFerdItem::new).collect(Collectors.toUnmodifiableList()).toArray(new ZugFerdItem[0]);
    }

    public IZUGFeRDAllowanceCharge[] getZFLogisticsServiceCharges() {
        return null;
    }

    static class ZugFerdContact
    implements IZUGFeRDExportableContact {
        private final LegalEntity entity;

        public ZugFerdContact(@NotNull LegalEntity entity) {
            this.entity = entity;
        }

        public String getName() {
            return this.entity.name();
        }

        public String getVATID() {
            return this.entity.vatNr();
        }

        public String getCountry() {
            return this.entity.address("work").map(Address::country).orElse(null);
        }

        public String getLocation() {
            return this.entity.address("work").map(Address::locality).orElse(null);
        }

        public String getStreet() {
            return this.entity.address("work").map(Address::street).orElse(null);
        }

        public String getZIP() {
            return this.entity.address("work").map(Address::postcode).orElse(null);
        }
    }

    static class ZugFerdItem
    implements IZUGFeRDExportableItem {
        private final InvoiceItem item;

        public ZugFerdItem(@NotNull InvoiceItem item) {
            this.item = item;
        }

        public IZUGFeRDExportableProduct getProduct() {
            return new ZugFerdProduct(this.item.product());
        }

        public IZUGFeRDAllowanceCharge[] getItemAllowances() {
            return new IZUGFeRDAllowanceCharge[0];
        }

        public IZUGFeRDAllowanceCharge[] getItemCharges() {
            return new IZUGFeRDAllowanceCharge[0];
        }

        public BigDecimal getPrice() {
            return this.item.unitPrice();
        }

        public BigDecimal getQuantity() {
            return this.item.quantity();
        }
    }

    static class ZugFerdPayment
    implements IZUGFeRDTradeSettlementPayment {
        private final Invoice invoice;

        public ZugFerdPayment(@NotNull Invoice invoice) {
            this.invoice = invoice;
        }

        public String getOwnBIC() {
            return this.invoice.invoicingConnection().bic();
        }

        public String getOwnBankName() {
            return this.invoice.invoicingConnection().institute();
        }

        public String getOwnIBAN() {
            return this.invoice.invoicingConnection().iban();
        }
    }

    static class ZugFerdProduct
    implements IZUGFeRDExportableProduct {
        private final Product product;

        public ZugFerdProduct(@NotNull Product product) {
            this.product = product;
        }

        public String getUnit() {
            return this.product.unit();
        }

        public String getName() {
            return this.product.id();
        }

        public String getDescription() {
            return this.product.text();
        }

        public BigDecimal getVATPercent() {
            return this.product.vatRate().multiply(HUNDRED);
        }
    }
}

