/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.ledger.ports;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import net.tangly.bus.ledger.Account;
import net.tangly.bus.ledger.AccountEntry;
import net.tangly.bus.ledger.Ledger;
import net.tangly.bus.ledger.Transaction;
import net.tangly.commons.utilities.AsciiDocHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosingReportAsciiDoc {
    private static final Logger log = LoggerFactory.getLogger(ClosingReportAsciiDoc.class);
    private final Ledger ledger;

    public ClosingReportAsciiDoc(Ledger ledger) {
        this.ledger = ledger;
    }

    public void create(LocalDate from, LocalDate to, Path reportPath) {
        try (PrintWriter writer = new PrintWriter(reportPath.toFile(), StandardCharsets.UTF_8);){
            this.create(from, to, writer);
        }
        catch (Exception e) {
            log.error("Error during reporting", (Throwable)e);
        }
    }

    public void create(LocalDate from, LocalDate to, PrintWriter writer) {
        AsciiDocHelper helper = new AsciiDocHelper(writer);
        helper.header("Balance Sheet", 1);
        ClosingReportAsciiDoc.generateResultTableFor(helper, this.ledger.assets(), from, to, "Assets");
        ClosingReportAsciiDoc.generateResultTableFor(helper, this.ledger.liabilities(), from, to, "Liabilities");
        ClosingReportAsciiDoc.generateResultTableFor(helper, this.ledger.profitAndLoss(), from, to, "Profits and Losses");
        helper.tableHeader("VAT", "cols=\"100, >25, >25 , >25\"", new String[]{"Period", "Turnover", "VAT", "Due VAT"});
        this.addVatRows(helper, from.getYear());
        if (from.getYear() != to.getYear()) {
            this.addVatRows(helper, to.getYear());
        }
        helper.tableEnd();
        helper.header("Transactions", 1);
        helper.tableHeader("Transactions", "cols=\"20, 20, 70 , 15, 15, >20, >10\"", new String[]{"Date", "Voucher", "Description", "Debit", "Credit", "Amount", "VAT"});
        this.ledger.transactions(from, to).forEach(o -> ClosingReportAsciiDoc.createTransactionRow(helper, o));
        helper.tableEnd();
    }

    private static void generateResultTableFor(AsciiDocHelper helper, List<Account> accounts, LocalDate from, LocalDate to, String category) {
        helper.header(category, 2);
        helper.tableHeader(category, "cols=\"25, 150, 20, >25, >25\"", new String[]{"Account", "Description", "Kind", "Balance", "Initial Balance"});
        accounts.forEach(o -> ClosingReportAsciiDoc.createBalanceRow(helper, o, from, to));
        helper.tableEnd();
    }

    private void addVatRows(AsciiDocHelper helper, int year) {
        LocalDate periodStart = LocalDate.of(year, Month.JANUARY, 1);
        LocalDate periodEnd = LocalDate.of(year, Month.JUNE, 30);
        BigDecimal earningH1 = this.ledger.computeVatSales(periodStart, periodEnd);
        BigDecimal vatH1 = this.ledger.computeVat(periodStart, periodEnd);
        BigDecimal vatDueH1 = this.ledger.computeDueVat(periodStart, periodEnd);
        periodStart = LocalDate.of(year, Month.JULY, 1);
        periodEnd = LocalDate.of(year, Month.DECEMBER, 31);
        BigDecimal earningH2 = this.ledger.computeVatSales(periodStart, periodEnd);
        BigDecimal vatH2 = this.ledger.computeVat(periodStart, periodEnd);
        BigDecimal vatDueH2 = this.ledger.computeDueVat(periodStart, periodEnd);
        helper.tableRow(new String[]{"First Half Year " + year, AsciiDocHelper.format((BigDecimal)earningH1), AsciiDocHelper.format((BigDecimal)vatH1), AsciiDocHelper.format((BigDecimal)vatDueH1)});
        helper.tableRow(new String[]{"Second Half Year " + year, AsciiDocHelper.format((BigDecimal)earningH2), AsciiDocHelper.format((BigDecimal)vatH2), AsciiDocHelper.format((BigDecimal)vatDueH2)});
        helper.tableRow(new String[]{"Totals Year " + year, AsciiDocHelper.format((BigDecimal)earningH1.add(earningH2)), AsciiDocHelper.format((BigDecimal)vatH1.add(vatH2)), AsciiDocHelper.format((BigDecimal)vatDueH1.add(vatDueH2))});
    }

    private static void createTransactionRow(AsciiDocHelper helper, Transaction transaction) {
        if (transaction.isSplit()) {
            if (transaction.debitSplits().size() > 1) {
                helper.tableRow(new String[]{transaction.date().toString(), transaction.reference(), transaction.text(), "", transaction.creditAccount(), AsciiDocHelper.format((BigDecimal)transaction.amount()), "-"});
                for (AccountEntry entry : transaction.debitSplits()) {
                    helper.tableRow(new String[]{"", "", "", entry.accountId(), "", AsciiDocHelper.format((BigDecimal)transaction.amount()), "-"});
                }
            } else {
                helper.tableRow(new String[]{transaction.date().toString(), transaction.reference(), transaction.text(), transaction.debitAccount(), "", AsciiDocHelper.format((BigDecimal)transaction.amount()), "-"});
                for (AccountEntry entry : transaction.debitSplits()) {
                    helper.tableRow(new String[]{"", "", "", "", entry.accountId(), AsciiDocHelper.format((BigDecimal)transaction.amount()), "-"});
                }
            }
        } else {
            helper.tableRow(new String[]{transaction.date().toString(), transaction.reference(), transaction.text(), transaction.debitAccount(), transaction.creditAccount(), AsciiDocHelper.format((BigDecimal)transaction.amount()), ClosingReportAsciiDoc.vat((AccountEntry)transaction.creditSplits().get(0))});
        }
    }

    private static String vat(AccountEntry entry) {
        return entry.getVat().map(o -> AsciiDocHelper.format((BigDecimal)o.multiply(new BigDecimal(100))) + "%").orElse("");
    }

    private static void createBalanceRow(AsciiDocHelper helper, Account account, LocalDate from, LocalDate to) {
        BigDecimal fromBalance = account.balance(from.minusDays(1L));
        BigDecimal toBalance = account.balance(to);
        if (BigDecimal.ZERO.equals(fromBalance) && BigDecimal.ZERO.equals(toBalance)) {
            return;
        }
        String accountId = account.id().startsWith("E") ? AsciiDocHelper.bold((String)account.id()) : account.id();
        String description = account.id().startsWith("E") ? AsciiDocHelper.bold((String)account.text()) : account.text();
        helper.tableRow(new String[]{accountId, description, account.isAggregate() ? "" : account.kind().name(), AsciiDocHelper.format((BigDecimal)toBalance), AsciiDocHelper.format((BigDecimal)fromBalance)});
    }
}

