/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.ledger.ports;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.tangly.bus.core.Tag;
import net.tangly.bus.ledger.Account;
import net.tangly.bus.ledger.AccountEntry;
import net.tangly.bus.ledger.Ledger;
import net.tangly.bus.ledger.Transaction;
import net.tangly.commons.lang.Strings;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerCsvHdl {
    private static final String AMOUNT = "Amount";
    private static final String SECTION = "Section";
    private static final String GROUP = "Group";
    private static final String ACCOUNT = "Account";
    private static final String DATE = "Date";
    private static final String DESCRIPTION = "Description";
    private static final String DOC = "Doc";
    private static final String BCLASS = "BClass";
    private static final String GR = "Gr";
    private static final String ACCOUNT_DEBIT = "AccountDebit";
    private static final String ACCOUNT_CREDIT = "AccountCredit";
    private static final String VAT_CODE = "VatCode";
    private static final Logger log = LoggerFactory.getLogger(LedgerCsvHdl.class);
    private final Ledger ledger;
    private static final String F1 = "F1";
    private static final String F3 = "F3";
    private static final BigDecimal VAT_F1_VALUE = new BigDecimal("0.08");
    private static final BigDecimal VAT_F3_VALUE = new BigDecimal("0.077");
    private static final BigDecimal VAT_F1_DUE_VALUE = new BigDecimal("0.061");
    private static final BigDecimal VAT_F3_DUE_VALUE = new BigDecimal("0.065");

    public LedgerCsvHdl(@NotNull Ledger ledger) {
        this.ledger = ledger;
    }

    public Ledger ledger() {
        return this.ledger;
    }

    public void importLedgerStructureFromBanana(@NotNull Path path) {
        try (BufferedReader in = new BufferedReader(new FileReader(path.toFile(), StandardCharsets.UTF_8));){
            CSVRecord record;
            Iterator records = CSVFormat.TDF.withFirstRecordAsHeader().parse((Reader)in).iterator();
            Account.AccountGroup currentSection = null;
            CSVRecord cSVRecord = record = records.hasNext() ? (CSVRecord)records.next() : null;
            while (record != null) {
                String section = record.get(SECTION);
                if (section != null && !section.isEmpty()) {
                    currentSection = LedgerCsvHdl.ofGroup(section);
                }
                String accountGroup = record.get(GROUP);
                String id = record.get(ACCOUNT);
                String text = record.get(DESCRIPTION);
                String accountKind = record.get(BCLASS);
                String ownedByGroupId = record.get(GR);
                if (LedgerCsvHdl.isRecordPlanRelevant(text, id, accountGroup)) {
                    if (Strings.isNullOrEmpty((String)accountGroup)) {
                        this.ledger.add(Account.of((int)Integer.parseInt(id), (Account.AccountKind)LedgerCsvHdl.ofKInd(accountKind), (String)text, (String)ownedByGroupId));
                    } else {
                        this.ledger.add(Account.of((String)accountGroup, (Account.AccountGroup)currentSection, (String)text, (String)ownedByGroupId));
                    }
                }
                record = records.hasNext() ? (CSVRecord)records.next() : null;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void importTransactionsLedgerFromBanana(@NotNull Path path) {
        try (BufferedReader in = new BufferedReader(new FileReader(path.toFile(), StandardCharsets.UTF_8));){
            CSVRecord record;
            Iterator records = CSVFormat.TDF.withFirstRecordAsHeader().parse((Reader)in).iterator();
            CSVRecord cSVRecord = record = records.hasNext() ? (CSVRecord)records.next() : null;
            while (record != null) {
                String date = record.get(DATE);
                String reference = record.get(DOC);
                String text = record.get(DESCRIPTION);
                String debitAccount = record.get(ACCOUNT_DEBIT);
                String creditAccount = record.get(ACCOUNT_CREDIT);
                String[] debitValues = debitAccount.split("-");
                String[] creditValues = creditAccount.split("-");
                String amount = record.get(AMOUNT);
                String vatCode = record.get(VAT_CODE);
                try {
                    Transaction transaction;
                    if (LedgerCsvHdl.isPartOfSplitTransaction(record)) {
                        ArrayList<AccountEntry> splits = new ArrayList<AccountEntry>();
                        record = LedgerCsvHdl.importSplits(records, splits);
                        transaction = new Transaction(LocalDate.parse(date), Strings.emptyToNull((String)debitValues[0]), Strings.emptyToNull((String)creditValues[0]), new BigDecimal(amount), splits, text, reference);
                    } else {
                        transaction = new Transaction(LocalDate.parse(date), Strings.emptyToNull((String)debitValues[0]), Strings.emptyToNull((String)creditValues[0]), new BigDecimal(amount), text, reference);
                        record = records.hasNext() ? (CSVRecord)records.next() : null;
                    }
                    LedgerCsvHdl.defineProject(transaction.debitSplits(), debitAccount);
                    LedgerCsvHdl.defineProject(transaction.creditSplits(), creditAccount);
                    LedgerCsvHdl.defineVat(transaction.creditSplits(), vatCode);
                    this.ledger.add(transaction);
                }
                catch (NumberFormatException e) {
                    log.error("not a legal amount {}", (Object)amount, (Object)e);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static CSVRecord importSplits(@NotNull Iterator<CSVRecord> records, List<AccountEntry> splits) {
        CSVRecord record;
        CSVRecord cSVRecord = record = records.hasNext() ? records.next() : null;
        while (LedgerCsvHdl.isPartOfSplitTransaction(record)) {
            String date = record.get(DATE);
            String text = record.get(DESCRIPTION);
            String debitAccount = record.get(ACCOUNT_DEBIT);
            String creditAccount = record.get(ACCOUNT_CREDIT);
            String splitAmount = record.get(AMOUNT);
            AccountEntry entry = null;
            if (!Strings.isNullOrEmpty((String)debitAccount)) {
                String[] debitValues = debitAccount.split("-");
                entry = AccountEntry.debit((String)debitValues[0], (String)date, (String)splitAmount, (String)text);
            } else if (!Strings.isNullOrEmpty((String)creditAccount)) {
                String[] creditValues = creditAccount.split("-");
                entry = AccountEntry.credit((String)creditValues[0], (String)date, (String)splitAmount, (String)text);
            }
            splits.add(entry);
            record = records.hasNext() ? records.next() : null;
        }
        return record;
    }

    private static boolean isRecordPlanRelevant(String description, String accountId, String groupId) {
        return !Strings.isNullOrEmpty((String)description) && (!Strings.isNullOrEmpty((String)accountId) && !accountId.startsWith(":") || !Strings.isNullOrEmpty((String)groupId) && !groupId.equalsIgnoreCase("0"));
    }

    private static void defineVat(@NotNull List<AccountEntry> entries, String code) {
        if (!Strings.isNullOrEmpty((String)code)) {
            switch (code) {
                case "F1": {
                    entries.forEach(o -> {
                        o.add(Tag.of((String)"fin", (String)"vat", (String)VAT_F1_VALUE.toString()));
                        o.add(Tag.of((String)"fin", (String)"vat-due", (String)VAT_F1_DUE_VALUE.toString()));
                    });
                    break;
                }
                case "F3": {
                    entries.forEach(o -> {
                        o.add(Tag.of((String)"fin", (String)"vat", (String)VAT_F3_VALUE.toString()));
                        o.add(Tag.of((String)"fin", (String)"vat-due", (String)VAT_F3_DUE_VALUE.toString()));
                    });
                    break;
                }
                default: {
                    log.info("Unknown VAT code in CSV file {}", (Object)code);
                }
            }
        }
    }

    private static void defineProject(@NotNull List<AccountEntry> entries, String code) {
        String[] values;
        if (!Strings.isNullOrEmpty((String)code) && (values = code.split("-")).length > 1) {
            entries.forEach(o -> o.add(new Tag("fin", "project", values[1])));
        }
    }

    private static Account.AccountGroup ofGroup(String accountGroup) {
        Account.AccountGroup group;
        try {
            group = switch (Integer.parseInt(accountGroup)) {
                case 1 -> Account.AccountGroup.ASSETS;
                case 2 -> Account.AccountGroup.LIABILITIES;
                case 3 -> Account.AccountGroup.EXPENSES;
                case 4 -> Account.AccountGroup.PROFITS_AND_LOSSES;
                default -> null;
            };
        }
        catch (NumberFormatException e) {
            return null;
        }
        return group;
    }

    private static Account.AccountKind ofKInd(String accountKind) {
        Account.AccountKind kind;
        try {
            kind = switch (Integer.parseInt(accountKind)) {
                case 1 -> Account.AccountKind.ASSET;
                case 2 -> Account.AccountKind.LIABILITY;
                case 3 -> Account.AccountKind.EXPENSE;
                case 4 -> Account.AccountKind.INCOME;
                default -> null;
            };
        }
        catch (NumberFormatException e) {
            return null;
        }
        return kind;
    }

    private static boolean isPartOfSplitTransaction(CSVRecord record) {
        return record != null && (Strings.isNullOrEmpty((String)record.get(ACCOUNT_DEBIT)) || Strings.isNullOrEmpty((String)record.get(ACCOUNT_CREDIT)));
    }
}

