/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.ledger.ports;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.tangly.bus.ledger.Ledger;
import net.tangly.ledger.ports.LedgerCsvHdl;
import org.jetbrains.annotations.NotNull;

public class LedgerWorkflows {
    private static final String LEDGER = "ledger";
    private final Ledger ledger = new Ledger();
    private final LedgerCsvHdl handler = new LedgerCsvHdl(this.ledger);

    public Ledger ledger() {
        return this.ledger;
    }

    public void importLedger(@NotNull Path path) {
        Path directory = path.resolve(LEDGER);
        this.handler.importLedgerStructureFromBanana(directory.resolve("swiss-ledger.csv"));
        try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
            stream.filter(file -> !Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().endsWith("-period.tsv")).forEach(this.handler::importTransactionsLedgerFromBanana);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

