/*
 * Decompiled with CFR 0.152.
 */
package net.thimmwork.time.constant;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.thimmwork.time.interval.InstantInterval;
import net.thimmwork.time.interval.LocalDateInterval;
import net.thimmwork.time.interval.LocalDateTimeInterval;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\n \u0014*\u0004\u0018\u00010\u00190\u00198\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u0017R$\u0010 \u001a\n \u0014*\u0004\u0018\u00010\u00190\u00198\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010\u001c\u00a8\u0006#"}, d2={"Lnet/thimmwork/time/constant/Infinity;", "", "()V", "INSTANT_INTERVAL", "Lnet/thimmwork/time/interval/InstantInterval;", "INSTANT_INTERVAL$annotations", "getINSTANT_INTERVAL", "()Lnet/thimmwork/time/interval/InstantInterval;", "LOCAL_DATE_INTERVAL", "Lnet/thimmwork/time/interval/LocalDateInterval;", "LOCAL_DATE_INTERVAL$annotations", "getLOCAL_DATE_INTERVAL", "()Lnet/thimmwork/time/interval/LocalDateInterval;", "LOCAL_DATE_TIME_INTERVAL", "Lnet/thimmwork/time/interval/LocalDateTimeInterval;", "LOCAL_DATE_TIME_INTERVAL$annotations", "getLOCAL_DATE_TIME_INTERVAL", "()Lnet/thimmwork/time/interval/LocalDateTimeInterval;", "MAX_DATE", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "MAX_DATE$annotations", "getMAX_DATE", "()Ljava/time/LocalDate;", "MAX_DATE_TIME", "Ljava/time/LocalDateTime;", "MAX_DATE_TIME$annotations", "getMAX_DATE_TIME", "()Ljava/time/LocalDateTime;", "MIN_DATE", "MIN_DATE$annotations", "getMIN_DATE", "MIN_DATE_TIME", "MIN_DATE_TIME$annotations", "getMIN_DATE_TIME", "time-intervals"})
public final class Infinity {
    private static final LocalDate MIN_DATE;
    private static final LocalDateTime MIN_DATE_TIME;
    private static final LocalDate MAX_DATE;
    private static final LocalDateTime MAX_DATE_TIME;
    @NotNull
    private static final LocalDateInterval LOCAL_DATE_INTERVAL;
    @NotNull
    private static final LocalDateTimeInterval LOCAL_DATE_TIME_INTERVAL;
    @NotNull
    private static final InstantInterval INSTANT_INTERVAL;
    public static final Infinity INSTANCE;

    @JvmStatic
    public static /* synthetic */ void MIN_DATE$annotations() {
    }

    public static final LocalDate getMIN_DATE() {
        return MIN_DATE;
    }

    @JvmStatic
    public static /* synthetic */ void MIN_DATE_TIME$annotations() {
    }

    public static final LocalDateTime getMIN_DATE_TIME() {
        return MIN_DATE_TIME;
    }

    @JvmStatic
    public static /* synthetic */ void MAX_DATE$annotations() {
    }

    public static final LocalDate getMAX_DATE() {
        return MAX_DATE;
    }

    @JvmStatic
    public static /* synthetic */ void MAX_DATE_TIME$annotations() {
    }

    public static final LocalDateTime getMAX_DATE_TIME() {
        return MAX_DATE_TIME;
    }

    @JvmStatic
    public static /* synthetic */ void LOCAL_DATE_INTERVAL$annotations() {
    }

    @NotNull
    public static final LocalDateInterval getLOCAL_DATE_INTERVAL() {
        return LOCAL_DATE_INTERVAL;
    }

    @JvmStatic
    public static /* synthetic */ void LOCAL_DATE_TIME_INTERVAL$annotations() {
    }

    @NotNull
    public static final LocalDateTimeInterval getLOCAL_DATE_TIME_INTERVAL() {
        return LOCAL_DATE_TIME_INTERVAL;
    }

    @JvmStatic
    public static /* synthetic */ void INSTANT_INTERVAL$annotations() {
    }

    @NotNull
    public static final InstantInterval getINSTANT_INTERVAL() {
        return INSTANT_INTERVAL;
    }

    private Infinity() {
    }

    static {
        Infinity infinity;
        INSTANCE = infinity = new Infinity();
        MIN_DATE = LocalDate.of(1970, 1, 1);
        MIN_DATE_TIME = MIN_DATE.atStartOfDay();
        MAX_DATE = LocalDate.of(4000, 12, 31);
        MAX_DATE_TIME = MAX_DATE.atStartOfDay();
        LocalDate localDate = MIN_DATE;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"MIN_DATE");
        LocalDate localDate2 = MAX_DATE;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"MAX_DATE");
        LOCAL_DATE_INTERVAL = new LocalDateInterval(localDate, localDate2);
        LocalDateTime localDateTime = MIN_DATE_TIME;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"MIN_DATE_TIME");
        LocalDateTime localDateTime2 = MAX_DATE_TIME;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime2, (String)"MAX_DATE_TIME");
        LOCAL_DATE_TIME_INTERVAL = new LocalDateTimeInterval(localDateTime, localDateTime2);
        Instant instant = Instant.EPOCH;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.EPOCH");
        Instant instant2 = MAX_DATE.atStartOfDay().toInstant(ZoneOffset.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"MAX_DATE.atStartOfDay().toInstant(ZoneOffset.UTC)");
        INSTANT_INTERVAL = new InstantInterval(instant, instant2);
    }
}

