/*
 * Decompiled with CFR 0.152.
 */
package net.thimmwork.time.interval;

import com.google.common.collect.Range;
import java.time.temporal.Temporal;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b&\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0013\u0010\u0015\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001f\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u00a6\u0004J\u001e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0004J\u0017\u0010\u001a\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0004J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0019\u0010\b\u001a\n \t*\u0004\u0018\u00018\u00008\u00008F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \t*\u0004\u0018\u00018\u00008\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lnet/thimmwork/time/interval/AbstractInterval;", "T", "Ljava/time/temporal/Temporal;", "", "", "interval", "Lcom/google/common/collect/Range;", "(Lcom/google/common/collect/Range;)V", "end", "kotlin.jvm.PlatformType", "getEnd", "()Ljava/time/temporal/Temporal;", "getInterval", "()Lcom/google/common/collect/Range;", "start", "getStart", "contains", "", "value", "(Ljava/time/temporal/Temporal;)Z", "other", "equals", "hashCode", "", "overlap", "overlappingRange", "overlaps", "toRange", "toString", "", "time-intervals"})
public abstract class AbstractInterval<T extends Temporal & Comparable<? super T>> {
    @NotNull
    private final Range<T> interval;

    public final T getStart() {
        return (T)((Temporal)((Object)this.interval.lowerEndpoint()));
    }

    public final T getEnd() {
        return (T)((Temporal)((Object)this.interval.upperEndpoint()));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.thimmwork.time.interval.AbstractInterval<*>");
        }
        AbstractInterval cfr_ignored_0 = (AbstractInterval)object2;
        return !(Intrinsics.areEqual(this.interval, ((AbstractInterval)other).interval) ^ true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(@NotNull AbstractInterval<T> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Comparable comparable = (Comparable)this.getStart();
        T t = other.getStart();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"other.start");
        if (comparable.compareTo(t) > 0) return false;
        Comparable comparable2 = (Comparable)this.getEnd();
        T t2 = other.getEnd();
        Intrinsics.checkExpressionValueIsNotNull(t2, (String)"other.end");
        if (comparable2.compareTo(t2) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean overlaps(@NotNull AbstractInterval<T> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Comparable comparable = (Comparable)this.getStart();
        T t = other.getEnd();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"other.end");
        if (comparable.compareTo(t) >= 0) return false;
        Comparable comparable2 = (Comparable)this.getEnd();
        T t2 = other.getStart();
        Intrinsics.checkExpressionValueIsNotNull(t2, (String)"other.start");
        if (comparable2.compareTo(t2) <= 0) return false;
        return true;
    }

    @Nullable
    public abstract AbstractInterval<T> overlap(@NotNull AbstractInterval<T> var1);

    @Nullable
    protected final Range<T> overlappingRange(@NotNull AbstractInterval<T> other) {
        Range intersection;
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        if (!this.interval.isConnected(other.interval)) {
            return null;
        }
        Range range = intersection = this.interval.intersection(other.interval);
        Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"intersection");
        return range.isEmpty() ? null : intersection;
    }

    public boolean contains(@NotNull T value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.interval.contains((Comparable)value);
    }

    public int hashCode() {
        return this.interval.hashCode();
    }

    @NotNull
    public String toString() {
        return "Interval(start=" + this.getStart() + ",end=" + this.getEnd() + ')';
    }

    @NotNull
    public final Range<T> toRange() {
        return this.interval;
    }

    @NotNull
    protected final Range<T> getInterval() {
        return this.interval;
    }

    public AbstractInterval(@NotNull Range<T> interval) {
        Intrinsics.checkParameterIsNotNull(interval, (String)"interval");
        this.interval = interval;
    }
}

