/*
 * Decompiled with CFR 0.152.
 */
package net.thimmwork.time.interval;

import com.google.common.collect.Range;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.thimmwork.time.constant.Infinity;
import net.thimmwork.time.interval.AbstractInterval;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0000J\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0096\u0004\u00a8\u0006\u0012"}, d2={"Lnet/thimmwork/time/interval/InstantInterval;", "Lnet/thimmwork/time/interval/AbstractInterval;", "Ljava/time/Instant;", "start", "end", "(Ljava/time/Instant;Ljava/time/Instant;)V", "range", "Lcom/google/common/collect/Range;", "(Lcom/google/common/collect/Range;)V", "equals", "", "other", "", "hashCode", "", "normalize", "overlap", "Companion", "time-intervals"})
public final class InstantInterval
extends AbstractInterval<Instant> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final InstantInterval normalize() {
        Instant minInstant = (Instant)Infinity.getINSTANT_INTERVAL().getStart();
        Instant maxInstant = (Instant)Infinity.getINSTANT_INTERVAL().getEnd();
        Instant start = ((Instant)this.getStart()).isBefore(minInstant) ? minInstant : (Instant)this.getStart();
        Instant end = ((Instant)this.getEnd()).isAfter(maxInstant) ? maxInstant : (Instant)this.getEnd();
        Instant instant = start;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"start");
        Instant instant2 = end;
        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"end");
        return new InstantInterval(instant, instant2);
    }

    @Nullable
    public InstantInterval overlap(@NotNull AbstractInterval<Instant> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Range<Instant> overlappingRange = this.overlappingRange(other);
        return overlappingRange == null ? null : new InstantInterval(overlappingRange);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.thimmwork.time.interval.InstantInterval");
        }
        InstantInterval cfr_ignored_0 = (InstantInterval)object2;
        return !(Intrinsics.areEqual(this.getInterval(), ((InstantInterval)other).getInterval()) ^ true);
    }

    @Override
    public int hashCode() {
        return this.getInterval().hashCode();
    }

    private InstantInterval(Range<Instant> range) {
        super(range);
    }

    public InstantInterval(@NotNull Instant start, @NotNull Instant end) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Range range = Range.closedOpen((Comparable)start, (Comparable)end);
        Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"Range.closedOpen(start, end)");
        this((Range<Instant>)range);
    }

    public /* synthetic */ InstantInterval(Instant instant, Instant instant2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Object t = Infinity.getINSTANT_INTERVAL().getStart();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Infinity.INSTANT_INTERVAL.start");
            instant = (Instant)t;
        }
        if ((n & 2) != 0) {
            Object t = Infinity.getINSTANT_INTERVAL().getEnd();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Infinity.INSTANT_INTERVAL.end");
            instant2 = (Instant)t;
        }
        this(instant, instant2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lnet/thimmwork/time/interval/InstantInterval$Companion;", "", "()V", "parse", "Lnet/thimmwork/time/interval/InstantInterval;", "start", "", "end", "time-intervals"})
    public static final class Companion {
        @NotNull
        public final InstantInterval parse(@NotNull String start, @NotNull String end) {
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
            Instant instant = Instant.parse(start);
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.parse(start)");
            Instant instant2 = Instant.parse(end);
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"Instant.parse(end)");
            return new InstantInterval(instant, instant2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

