/*
 * Decompiled with CFR 0.152.
 */
package net.thimmwork.time.interval;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.thimmwork.time.interval.InstantInterval;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"instant", "Ljava/time/Instant;", "dateTime", "", "zoneId", "Ljava/time/ZoneId;", "instantInterval", "Lnet/thimmwork/time/interval/InstantInterval;", "dateTimeStart", "dateTimeEnd", "time-intervals"})
public final class InstantIntervalKt {
    @NotNull
    public static final InstantInterval instantInterval(@NotNull String dateTimeStart, @NotNull String dateTimeEnd, @NotNull ZoneId zoneId) {
        Intrinsics.checkParameterIsNotNull((Object)dateTimeStart, (String)"dateTimeStart");
        Intrinsics.checkParameterIsNotNull((Object)dateTimeEnd, (String)"dateTimeEnd");
        Intrinsics.checkParameterIsNotNull((Object)zoneId, (String)"zoneId");
        return new InstantInterval(InstantIntervalKt.instant(dateTimeStart, zoneId), InstantIntervalKt.instant(dateTimeEnd, zoneId));
    }

    @NotNull
    public static final Instant instant(@NotNull String dateTime, @NotNull ZoneId zoneId) {
        Intrinsics.checkParameterIsNotNull((Object)dateTime, (String)"dateTime");
        Intrinsics.checkParameterIsNotNull((Object)zoneId, (String)"zoneId");
        Instant instant = LocalDateTime.parse(dateTime).atZone(zoneId).toInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"LocalDateTime.parse(date\u2026tZone(zoneId).toInstant()");
        return instant;
    }
}

