/*
 * Decompiled with CFR 0.152.
 */
package net.thimmwork.time.interval;

import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.thimmwork.time.interval.InstantInterval;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\tJ\u0006\u0010\u000b\u001a\u00020\fJ\u001d\u0010\r\u001a\t\u0018\u00018\u0000\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u001b\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010\u001c\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0002RN\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00018\u00008\u0000 \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/thimmwork/time/interval/InstantIntervalMap;", "T", "", "()V", "delegate", "Lcom/google/common/collect/TreeRangeMap;", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "asMapOfInstantIntervals", "", "Lnet/thimmwork/time/interval/InstantInterval;", "clear", "", "get", "Lorg/checkerframework/checker/nullness/qual/Nullable;", "key", "(Ljava/time/Instant;)Ljava/lang/Object;", "isEmpty", "", "put", "value", "(Lnet/thimmwork/time/interval/InstantInterval;Ljava/lang/Object;)V", "putAll", "from", "remove", "size", "", "span", "toInstantInterval", "range", "Lcom/google/common/collect/Range;", "time-intervals"})
public final class InstantIntervalMap<T> {
    private final TreeRangeMap<Instant, T> delegate = TreeRangeMap.create();

    @Nullable
    public final T get(@NotNull Instant key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (T)this.delegate.get((Comparable)key);
    }

    public final boolean isEmpty() {
        boolean bl;
        block4: {
            boolean empty = this.delegate.asMapOfRanges().isEmpty();
            if (empty) {
                return true;
            }
            Iterable $receiver$iv = this.delegate.asMapOfRanges().keySet();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Range it;
                    Range range = it = (Range)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"it");
                    if (range.isEmpty()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<InstantInterval, T> asMapOfInstantIntervals() {
        void $receiver$iv$iv;
        Map map = this.delegate.asMapOfRanges();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"delegate.asMapOfRanges()");
        Map $receiver$iv = map;
        Map map2 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
            InstantInterval instantInterval = this.toInstantInterval((Range<Instant>)((Range)k));
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            InstantInterval instantInterval2 = instantInterval;
            Map map4 = map3;
            Object v = it$iv$iv.getValue();
            map4.put(instantInterval2, v);
        }
        return destination$iv$iv;
    }

    private final InstantInterval toInstantInterval(Range<Instant> range) {
        Comparable comparable = range.lowerEndpoint();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"range.lowerEndpoint()");
        Instant instant = (Instant)comparable;
        Comparable comparable2 = range.upperEndpoint();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable2, (String)"range.upperEndpoint()");
        return new InstantInterval(instant, (Instant)comparable2);
    }

    public final void clear() {
        this.delegate.clear();
    }

    public final void put(@NotNull InstantInterval key, T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.delegate.putCoalescing(key.toRange(), value);
    }

    public final void putAll(@NotNull InstantIntervalMap<T> from) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        Iterable $receiver$iv = from.delegate.asMapOfRanges().entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            this.delegate.put((Range)it.getKey(), it.getValue());
        }
    }

    public final void remove(@NotNull InstantInterval key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.delegate.remove(key.toRange());
    }

    public final int size() {
        return this.delegate.asMapOfRanges().size();
    }

    @NotNull
    public final InstantInterval span() {
        Range range = this.delegate.span();
        Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"delegate.span()");
        return this.toInstantInterval((Range<Instant>)range);
    }
}

