/*
 * Decompiled with CFR 0.152.
 */
package net.thimmwork.time.interval;

import com.google.common.collect.Range;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.Temporal;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.ClosedRange;
import net.thimmwork.time.constant.Infinity;
import net.thimmwork.time.interval.AbstractInterval;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004:\u0003 !\"B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0000J\u0013\u0010\u0013\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0096\u0002J\u0006\u0010\u0019\u001a\u00020\u0000J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0096\u0004J\u0017\u0010\u001b\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0096\u0004J\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001c\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lnet/thimmwork/time/interval/LocalDateInterval;", "Lnet/thimmwork/time/interval/AbstractInterval;", "Ljava/time/LocalDate;", "", "Lkotlin/ranges/ClosedRange;", "start", "end", "(Ljava/time/LocalDate;Ljava/time/LocalDate;)V", "range", "Lcom/google/common/collect/Range;", "(Lcom/google/common/collect/Range;)V", "endInclusive", "kotlin.jvm.PlatformType", "getEndInclusive", "()Ljava/time/LocalDate;", "contains", "", "value", "other", "equals", "", "hashCode", "", "iterator", "", "normalize", "overlap", "overlaps", "step", "", "toString", "", "Companion", "ForwardLocalDateIterator", "ReverseLocalDateIterator", "time-intervals"})
public final class LocalDateInterval
extends AbstractInterval<LocalDate>
implements Iterable<LocalDate>,
ClosedRange<LocalDate>,
KMappedMarker {
    public static final Companion Companion = new Companion(null);

    public LocalDate getEndInclusive() {
        return (LocalDate)this.getInterval().upperEndpoint();
    }

    @Override
    public boolean contains(@NotNull LocalDate value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return super.contains((Temporal)value);
    }

    @NotNull
    public final LocalDateInterval normalize() {
        LocalDate end;
        LocalDate minDate = (LocalDate)Infinity.getLOCAL_DATE_INTERVAL().getStart();
        LocalDate maxDate = (LocalDate)Infinity.getLOCAL_DATE_INTERVAL().getEnd();
        LocalDate start = ((LocalDate)this.getStart()).isBefore(minDate) ? minDate : (LocalDate)this.getStart();
        LocalDate localDate = end = ((LocalDate)this.getEnd()).isAfter(maxDate) ? maxDate : (LocalDate)this.getEnd();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"end");
        return new LocalDateInterval(start, localDate);
    }

    @Override
    public final boolean contains(@NotNull LocalDateInterval other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return !((LocalDate)this.getStart()).isAfter((ChronoLocalDate)other.getStart()) && !((LocalDate)this.getEnd()).isBefore((ChronoLocalDate)other.getEnd());
    }

    @Override
    @NotNull
    public Iterator<LocalDate> iterator() {
        return new ForwardLocalDateIterator(this, 0L, 1, null);
    }

    @NotNull
    public final Iterable<LocalDate> step(long step) {
        if (step > 0L) {
            return new Iterable<LocalDate>(this, step){
                final /* synthetic */ LocalDateInterval this$0;
                final /* synthetic */ long $step$inlined;
                {
                    this.this$0 = localDateInterval;
                    this.$step$inlined = l;
                }

                @NotNull
                public Iterator<LocalDate> iterator() {
                    return new ForwardLocalDateIterator(this.this$0, this.$step$inlined);
                }
            };
        }
        return new Iterable<LocalDate>(this, step){
            final /* synthetic */ LocalDateInterval this$0;
            final /* synthetic */ long $step$inlined;
            {
                this.this$0 = localDateInterval;
                this.$step$inlined = l;
            }

            @NotNull
            public Iterator<LocalDate> iterator() {
                return this.this$0.new ReverseLocalDateIterator(this.$step$inlined);
            }
        };
    }

    @Override
    public boolean overlaps(@NotNull AbstractInterval<LocalDate> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return ((LocalDate)this.getStart()).compareTo(other.getEnd()) <= 0 && ((LocalDate)this.getEnd()).compareTo(other.getStart()) >= 0;
    }

    @Nullable
    public LocalDateInterval overlap(@NotNull AbstractInterval<LocalDate> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Range<LocalDate> overlappingRange = this.overlappingRange(other);
        return overlappingRange == null ? null : new LocalDateInterval(overlappingRange);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.thimmwork.time.interval.LocalDateInterval");
        }
        LocalDateInterval cfr_ignored_0 = (LocalDateInterval)object2;
        return !(Intrinsics.areEqual(this.getInterval(), ((LocalDateInterval)other).getInterval()) ^ true);
    }

    @Override
    public int hashCode() {
        return this.getInterval().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return "LocalDateInterval(interval=" + this.getInterval() + ')';
    }

    private LocalDateInterval(Range<LocalDate> range) {
        super(range);
    }

    public LocalDateInterval(@NotNull LocalDate start, @NotNull LocalDate end) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Range range = Range.closed((Comparable)start, (Comparable)end);
        Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"Range.closed(start, end)");
        this((Range<LocalDate>)range);
    }

    public /* synthetic */ LocalDateInterval(LocalDate localDate, LocalDate localDate2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalDate localDate3 = Infinity.getMIN_DATE();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate3, (String)"Infinity.MIN_DATE");
            localDate = localDate3;
        }
        if ((n & 2) != 0) {
            LocalDate localDate4 = Infinity.getMAX_DATE();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate4, (String)"Infinity.MAX_DATE");
            localDate2 = localDate4;
        }
        this(localDate, localDate2);
    }

    public boolean isEmpty() {
        return ClosedRange.DefaultImpls.isEmpty((ClosedRange)this);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\tH\u0096\u0002J\t\u0010\u0006\u001a\u00020\u0002H\u0096\u0002R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/thimmwork/time/interval/LocalDateInterval$ReverseLocalDateIterator;", "", "Ljava/time/LocalDate;", "step", "", "(Lnet/thimmwork/time/interval/LocalDateInterval;J)V", "next", "kotlin.jvm.PlatformType", "hasNext", "", "time-intervals"})
    private final class ReverseLocalDateIterator
    implements Iterator<LocalDate>,
    KMappedMarker {
        private LocalDate next;
        private final long step;

        @Override
        public boolean hasNext() {
            return !this.next.isBefore((ChronoLocalDate)LocalDateInterval.this.getStart());
        }

        @Override
        @NotNull
        public LocalDate next() {
            if (this.hasNext()) {
                LocalDate localDate;
                LocalDate it = localDate = this.next;
                this.next = this.next.plusDays(this.step);
                LocalDate localDate2 = localDate;
                Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"next.also {\n            \u2026s(step)\n                }");
                return localDate2;
            }
            throw (Throwable)new NoSuchElementException();
        }

        public ReverseLocalDateIterator(long step) {
            this.step = step;
            this.next = (LocalDate)LocalDateInterval.this.getEnd();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\u0006\u001a\u00020\u0002H\u0096\u0002R\u001a\u0010\u0006\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/thimmwork/time/interval/LocalDateInterval$ForwardLocalDateIterator;", "", "Ljava/time/LocalDate;", "step", "", "(Lnet/thimmwork/time/interval/LocalDateInterval;J)V", "next", "getNext", "()Ljava/time/LocalDate;", "setNext", "(Ljava/time/LocalDate;)V", "hasNext", "", "time-intervals"})
    private final class ForwardLocalDateIterator
    implements Iterator<LocalDate>,
    KMappedMarker {
        @NotNull
        private LocalDate next;
        private final long step;
        final /* synthetic */ LocalDateInterval this$0;

        @NotNull
        protected final LocalDate getNext() {
            return this.next;
        }

        protected final void setNext(@NotNull LocalDate localDate) {
            Intrinsics.checkParameterIsNotNull((Object)localDate, (String)"<set-?>");
            this.next = localDate;
        }

        @Override
        public boolean hasNext() {
            return !this.next.isAfter((ChronoLocalDate)this.this$0.getEnd());
        }

        @Override
        @NotNull
        public LocalDate next() {
            if (this.hasNext()) {
                LocalDate localDate;
                LocalDate it = localDate = this.next;
                LocalDate localDate2 = this.next.plusDays(this.step);
                Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"next.plusDays(step)");
                this.next = localDate2;
                return localDate;
            }
            throw (Throwable)new NoSuchElementException();
        }

        public ForwardLocalDateIterator(LocalDateInterval $outer, long step) {
            this.this$0 = $outer;
            this.step = step;
            this.next = (LocalDate)$outer.getStart();
        }

        public /* synthetic */ ForwardLocalDateIterator(LocalDateInterval localDateInterval, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 1L;
            }
            this(localDateInterval, l);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lnet/thimmwork/time/interval/LocalDateInterval$Companion;", "", "()V", "parse", "Lnet/thimmwork/time/interval/LocalDateInterval;", "start", "", "end", "time-intervals"})
    public static final class Companion {
        @NotNull
        public final LocalDateInterval parse(@NotNull String start, @NotNull String end) {
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
            LocalDate localDate = LocalDate.parse(start);
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.parse(start)");
            LocalDate localDate2 = LocalDate.parse(end);
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"LocalDate.parse(end)");
            return new LocalDateInterval(localDate, localDate2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

