/*
 * Decompiled with CFR 0.152.
 */
package net.thimmwork.time.interval;

import com.google.common.collect.Range;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.thimmwork.time.constant.Infinity;
import net.thimmwork.time.interval.AbstractInterval;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000J\u0013\u0010\f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0000J\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0096\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lnet/thimmwork/time/interval/LocalDateTimeInterval;", "Lnet/thimmwork/time/interval/AbstractInterval;", "Ljava/time/LocalDateTime;", "start", "end", "(Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;)V", "range", "Lcom/google/common/collect/Range;", "(Lcom/google/common/collect/Range;)V", "contains", "", "other", "equals", "", "hashCode", "", "normalize", "overlap", "toString", "", "Companion", "time-intervals"})
public final class LocalDateTimeInterval
extends AbstractInterval<LocalDateTime> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final LocalDateTimeInterval normalize() {
        LocalDateTime minDate = (LocalDateTime)Infinity.getLOCAL_DATE_TIME_INTERVAL().getStart();
        LocalDateTime maxDate = (LocalDateTime)Infinity.getLOCAL_DATE_TIME_INTERVAL().getEnd();
        LocalDateTime start = ((LocalDateTime)this.getStart()).isBefore(minDate) ? minDate : (LocalDateTime)this.getStart();
        LocalDateTime end = ((LocalDateTime)this.getEnd()).isAfter(maxDate) ? maxDate : (LocalDateTime)this.getEnd();
        LocalDateTime localDateTime = start;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"start");
        LocalDateTime localDateTime2 = end;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime2, (String)"end");
        return new LocalDateTimeInterval(localDateTime, localDateTime2);
    }

    @Override
    public final boolean contains(@NotNull LocalDateTimeInterval other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return !((LocalDateTime)this.getStart()).isAfter((ChronoLocalDateTime)other.getStart()) && !((LocalDateTime)this.getEnd()).isBefore((ChronoLocalDateTime)other.getEnd());
    }

    @Nullable
    public LocalDateTimeInterval overlap(@NotNull AbstractInterval<LocalDateTime> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Range<LocalDateTime> overlappingRange = this.overlappingRange(other);
        return overlappingRange == null ? null : new LocalDateTimeInterval(overlappingRange);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.thimmwork.time.interval.LocalDateTimeInterval");
        }
        LocalDateTimeInterval cfr_ignored_0 = (LocalDateTimeInterval)object2;
        return !(Intrinsics.areEqual(this.getInterval(), ((LocalDateTimeInterval)other).getInterval()) ^ true);
    }

    @Override
    public int hashCode() {
        return this.getInterval().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return "LocalDateTimeInterval(interval=" + this.getInterval() + ')';
    }

    private LocalDateTimeInterval(Range<LocalDateTime> range) {
        super(range);
    }

    public LocalDateTimeInterval(@NotNull LocalDateTime start, @NotNull LocalDateTime end) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Range range = Range.closedOpen((Comparable)start, (Comparable)end);
        Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"Range.closedOpen(start, end)");
        this((Range<LocalDateTime>)range);
    }

    public /* synthetic */ LocalDateTimeInterval(LocalDateTime localDateTime, LocalDateTime localDateTime2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalDateTime localDateTime3 = Infinity.getMIN_DATE_TIME();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime3, (String)"Infinity.MIN_DATE_TIME");
            localDateTime = localDateTime3;
        }
        if ((n & 2) != 0) {
            LocalDateTime localDateTime4 = Infinity.getMAX_DATE_TIME();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime4, (String)"Infinity.MAX_DATE_TIME");
            localDateTime2 = localDateTime4;
        }
        this(localDateTime, localDateTime2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lnet/thimmwork/time/interval/LocalDateTimeInterval$Companion;", "", "()V", "parse", "Lnet/thimmwork/time/interval/LocalDateTimeInterval;", "start", "", "end", "time-intervals"})
    public static final class Companion {
        @NotNull
        public final LocalDateTimeInterval parse(@NotNull String start, @NotNull String end) {
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
            LocalDateTime localDateTime = LocalDateTime.parse(start);
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.parse(start)");
            LocalDateTime localDateTime2 = LocalDateTime.parse(end);
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime2, (String)"LocalDateTime.parse(end)");
            return new LocalDateTimeInterval(localDateTime, localDateTime2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

