/*
 * Decompiled with CFR 0.152.
 */
package net.thimmwork.time.interval;

import com.google.common.collect.Range;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.thimmwork.time.constant.Infinity;
import net.thimmwork.time.interval.AbstractInterval;
import net.thimmwork.time.interval.InstantInterval;
import net.thimmwork.time.interval.LocalDateTimeInterval;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0000J\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0096\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lnet/thimmwork/time/interval/OffsetDateTimeInterval;", "Lnet/thimmwork/time/interval/AbstractInterval;", "Ljava/time/OffsetDateTime;", "start", "end", "(Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;)V", "range", "Lcom/google/common/collect/Range;", "(Lcom/google/common/collect/Range;)V", "equals", "", "other", "", "hashCode", "", "normalize", "overlap", "toInstantInterval", "Lnet/thimmwork/time/interval/InstantInterval;", "toLocalDateTimeInterval", "Lnet/thimmwork/time/interval/LocalDateTimeInterval;", "toString", "", "Companion", "time-intervals"})
public final class OffsetDateTimeInterval
extends AbstractInterval<OffsetDateTime> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final OffsetDateTimeInterval normalize() {
        Instant minInstant = (Instant)Infinity.getINSTANT_INTERVAL().getStart();
        Instant maxInstant = (Instant)Infinity.getINSTANT_INTERVAL().getEnd();
        Instant start = ((OffsetDateTime)this.getStart()).toInstant().isBefore(minInstant) ? minInstant : ((OffsetDateTime)this.getStart()).toInstant();
        Instant end = ((OffsetDateTime)this.getEnd()).toInstant().isAfter(maxInstant) ? maxInstant : ((OffsetDateTime)this.getEnd()).toInstant();
        OffsetDateTime offsetDateTime = start.atOffset(((OffsetDateTime)this.getStart()).getOffset());
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"start.atOffset(this.start.getOffset())");
        OffsetDateTime offsetDateTime2 = end.atOffset(((OffsetDateTime)this.getEnd()).getOffset());
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime2, (String)"end.atOffset(this.end.getOffset())");
        return new OffsetDateTimeInterval(offsetDateTime, offsetDateTime2);
    }

    @NotNull
    public final LocalDateTimeInterval toLocalDateTimeInterval() {
        LocalDateTime localDateTime = ((OffsetDateTime)this.getStart()).toLocalDateTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"start.toLocalDateTime()");
        LocalDateTime localDateTime2 = ((OffsetDateTime)this.getEnd()).toLocalDateTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime2, (String)"end.toLocalDateTime()");
        return new LocalDateTimeInterval(localDateTime, localDateTime2);
    }

    @NotNull
    public final InstantInterval toInstantInterval() {
        Instant instant = ((OffsetDateTime)this.getStart()).toInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"start.toInstant()");
        Instant instant2 = ((OffsetDateTime)this.getEnd()).toInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"end.toInstant()");
        return new InstantInterval(instant, instant2);
    }

    @Nullable
    public OffsetDateTimeInterval overlap(@NotNull AbstractInterval<OffsetDateTime> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Range<OffsetDateTime> overlappingRange = this.overlappingRange(other);
        return overlappingRange == null ? null : new OffsetDateTimeInterval(overlappingRange);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.thimmwork.time.interval.OffsetDateTimeInterval");
        }
        OffsetDateTimeInterval cfr_ignored_0 = (OffsetDateTimeInterval)object2;
        return !(Intrinsics.areEqual(this.getInterval(), ((OffsetDateTimeInterval)other).getInterval()) ^ true);
    }

    @Override
    public int hashCode() {
        return this.getInterval().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return "OffsetDateTimeInterval(interval=" + this.getInterval() + ')';
    }

    private OffsetDateTimeInterval(Range<OffsetDateTime> range) {
        super(range);
    }

    public OffsetDateTimeInterval(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Range range = Range.closedOpen((Comparable)start, (Comparable)end);
        Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"Range.closedOpen(start, end)");
        this((Range<OffsetDateTime>)range);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lnet/thimmwork/time/interval/OffsetDateTimeInterval$Companion;", "", "()V", "parse", "Lnet/thimmwork/time/interval/OffsetDateTimeInterval;", "start", "", "end", "time-intervals"})
    public static final class Companion {
        @NotNull
        public final OffsetDateTimeInterval parse(@NotNull String start, @NotNull String end) {
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(start);
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"OffsetDateTime.parse(start)");
            OffsetDateTime offsetDateTime2 = OffsetDateTime.parse(end);
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime2, (String)"OffsetDateTime.parse(end)");
            return new OffsetDateTimeInterval(offsetDateTime, offsetDateTime2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

