/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.extra.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"strptime/1", "strptime/2"})
public class StrPTimeFunction
implements Function {
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType((String)"strptime", (JsonNode)in, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        try {
            for (JsonNode fmt : args.get(0).apply(in)) {
                if (!fmt.isTextual()) {
                    throw JsonQueryException.format((String)"Illegal argument type: %s", (Object[])new Object[]{fmt.getNodeType()});
                }
                SimpleDateFormat sdf = new SimpleDateFormat(fmt.asText());
                if (args.size() == 2) {
                    for (JsonNode tz : args.get(1).apply(in)) {
                        if (!tz.isTextual()) {
                            throw JsonQueryException.format((String)"Timezone must be a string", (Object[])new Object[0]);
                        }
                        sdf.setTimeZone(TimeZone.getTimeZone(tz.asText()));
                        out.add((JsonNode)new LongNode(sdf.parse(in.asText()).getTime()));
                    }
                    continue;
                }
                out.add((JsonNode)new LongNode(sdf.parse(in.asText()).getTime()));
            }
        }
        catch (Exception e) {
            throw new JsonQueryException((Throwable)e);
        }
        return out;
    }
}

