/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.extra.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"uridecode/0"})
public class UriDecodeFunction
implements Function {
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType((String)"urldecode", (JsonNode)in, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
        try {
            return Collections.singletonList(new TextNode(URLDecoder.decode(in.asText(), "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonQueryException((Throwable)e);
        }
    }
}

