/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.jmx.exporter.agent.BuildInfo;
import net.thisptr.jmx.exporter.agent.ExporterHttpHandler;
import net.thisptr.jmx.exporter.agent.config.Config;
import net.thisptr.jmx.exporter.agent.config.watcher.ConfigWatcher;
import net.thisptr.jmx.exporter.agent.config.watcher.PollingConfigWatcher;
import net.thisptr.jmx.exporter.agent.metrics.Instrumented;
import net.thisptr.jmx.exporter.agent.metrics.MetricRegistry;
import net.thisptr.jmx.exporter.agent.scripting.ScriptEngineRegistry;
import net.thisptr.jmx.exporter.agent.scripting.janino.JaninoScriptEngine;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.core.JsonParseException;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.JsonMappingException;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.net.HostAndPort;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.Undertow;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.ContentEncodingRepository;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.EncodingHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.GzipEncodingProvider;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Options;

public class Agent {
    private static final Logger LOG = Logger.getLogger(Agent.class.getName());
    static final String DEFAULT_CLASSPATH_CONFIG_FILE = "scriptable-jmx-exporter.yaml";
    private Undertow server;
    private volatile ExporterHttpHandler handler;
    private final MetricRegistry metricRegistry = new MetricRegistry();

    public Agent() {
        this.metricRegistry.add(BuildInfo.getInstance());
    }

    private static ConfigWatcher newConfigWatcher(String args, ConfigWatcher.ConfigListener listener) throws JsonParseException, JsonMappingException, IOException {
        if (args == null) {
            args = "@classpath:scriptable-jmx-exporter.yaml";
        }
        return new PollingConfigWatcher(args, listener);
    }

    private static void safeStart(Undertow server) throws Throwable {
        try {
            server.start();
        }
        catch (Throwable th) {
            try {
                server.stop();
            }
            catch (Throwable th2) {
                th.addSuppressed(th2);
            }
            throw th;
        }
    }

    private Undertow newServer(HostAndPort hostAndPort) {
        HttpHandler thisHandler = exchange -> this.handler.handleRequest(exchange);
        EncodingHandler encodingHandler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("gzip", new GzipEncodingProvider(), 50)).setNext(thisHandler);
        return Undertow.builder().setWorkerOption(Options.WORKER_NAME, "scriptable-jmx-exporter").setWorkerOption(Options.THREAD_DAEMON, true).addHttpListener(hostAndPort.getPort(), hostAndPort.getHost()).setHandler(encodingHandler).build();
    }

    private void start(String args) throws Throwable {
        try {
            ConfigWatcher watcher = Agent.newConfigWatcher(args, (oldConfig, newConfig) -> {
                LOG.log(Level.FINE, "Detected configuration change. Reconfiguring Scriptable JMX Exporter...");
                ExporterHttpHandler handler = new ExporterHttpHandler(newConfig.rules, newConfig.options, this.metricRegistry);
                if (!oldConfig.server.bindAddress.equals(newConfig.server.bindAddress)) {
                    try {
                        this.server.stop();
                    }
                    catch (Throwable th) {
                        LOG.log(Level.WARNING, "Failed to stop Scriptable JMX Exporter server for reconfiguration.", th);
                    }
                    this.server = this.newServer(newConfig.server.bindAddress);
                    Agent.safeStart(this.server);
                }
                this.handler = handler;
                LOG.log(Level.INFO, "Successfully reconfigured Scriptable JMX Exporter on {0}.", newConfig.server.bindAddress);
            });
            if (watcher instanceof Instrumented) {
                this.metricRegistry.add((Instrumented)((Object)watcher));
            }
            Config initialConfig = watcher.config();
            this.handler = new ExporterHttpHandler(initialConfig.rules, initialConfig.options, this.metricRegistry);
            this.server = this.newServer(initialConfig.server.bindAddress);
            Agent.safeStart(this.server);
            watcher.start();
            LOG.log(Level.INFO, "Successfully started Scriptable JMX Exporter on {0}.", initialConfig.server.bindAddress);
        }
        catch (Throwable th) {
            LOG.log(Level.SEVERE, "Failed to start Scriptable JMX Exporter.", th);
            System.exit(1);
        }
    }

    public static void premain(String args) throws Throwable {
        BuildInfo buildInfo = BuildInfo.getInstance();
        LOG.log(Level.INFO, "Starting Scriptable JMX Exporter Version {0} (Commit: {1})", new String[]{buildInfo.buildVersion, buildInfo.commitId.substring(0, Math.min(7, buildInfo.commitId.length()))});
        Agent agent = new Agent();
        agent.start(args);
    }

    static {
        ScriptEngineRegistry registry = ScriptEngineRegistry.getInstance();
        registry.add("java", new JaninoScriptEngine());
    }
}

