/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.jmx.exporter.agent.config.Config;
import net.thisptr.jmx.exporter.agent.metrics.MetricRegistry;
import net.thisptr.jmx.exporter.agent.scraper.Sample;
import net.thisptr.jmx.exporter.agent.scraper.ScrapeOutput;
import net.thisptr.jmx.exporter.agent.scraper.Scraper;
import net.thisptr.jmx.exporter.agent.scripting.PrometheusMetric;
import net.thisptr.jmx.exporter.agent.scripting.PrometheusMetricOutput;
import net.thisptr.jmx.exporter.agent.scripting.ScriptEngine;
import net.thisptr.jmx.exporter.agent.scripting.ScriptEngineRegistry;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;
import net.thisptr.jmx.exporter.agent.writer.PrometheusMetricWriter;

public class ExporterHttpHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(ExporterHttpHandler.class.getName());
    private static final Config.ScrapeRule DEFAULT_RULE;
    private final Scraper scraper;
    private final Config.OptionsConfig options;
    private final MetricRegistry metricRegistry;

    public ExporterHttpHandler(List<Config.ScrapeRule> rules, Config.OptionsConfig options, MetricRegistry metricRegistry) {
        this.options = options;
        this.metricRegistry = metricRegistry;
        ArrayList<Config.ScrapeRule> rulesWithDefault = new ArrayList<Config.ScrapeRule>(rules);
        rulesWithDefault.add(DEFAULT_RULE);
        this.scraper = new Scraper(ManagementFactory.getPlatformMBeanServer(), rulesWithDefault);
    }

    private static void parseBooleanQueryParamAndThen(HttpServerExchange exchange, String name, Consumer<Boolean> fn) {
        String value;
        Map<String, Deque<String>> queryParams = exchange.getQueryParameters();
        Deque<String> deque = queryParams.get(name);
        if (deque != null && !(value = deque.getFirst()).isEmpty()) {
            fn.accept(Boolean.parseBoolean(value));
        }
    }

    private static void parseLongQueryParamAndThen(HttpServerExchange exchange, String name, LongConsumer fn) {
        String value;
        Map<String, Deque<String>> queryParams = exchange.getQueryParameters();
        Deque<String> deque = queryParams.get(name);
        if (deque != null && !(value = deque.getFirst()).isEmpty()) {
            fn.accept(Long.parseLong(value));
        }
    }

    private Config.OptionsConfig getOptions(HttpServerExchange exchange) {
        Config.OptionsConfig options = new Config.OptionsConfig();
        options.includeTimestamp = this.options.includeTimestamp;
        options.includeHelp = this.options.includeHelp;
        options.includeType = this.options.includeType;
        options.minimumResponseTime = this.options.minimumResponseTime;
        ExporterHttpHandler.parseBooleanQueryParamAndThen(exchange, "include_help", value -> {
            options.includeHelp = value;
        });
        ExporterHttpHandler.parseBooleanQueryParamAndThen(exchange, "include_type", value -> {
            options.includeType = value;
        });
        ExporterHttpHandler.parseBooleanQueryParamAndThen(exchange, "include_timestamp", value -> {
            options.includeTimestamp = value;
        });
        ExporterHttpHandler.parseLongQueryParamAndThen(exchange, "minimum_response_time", value -> {
            options.minimumResponseTime = Math.max(0L, Math.min(60000L, value));
        });
        return options;
    }

    private void handleGetMetrics(HttpServerExchange exchange) throws IOException {
        Config.OptionsConfig options = this.getOptions(exchange);
        TreeMap<String, List<PrometheusMetric>> allMetrics = new TreeMap<String, List<PrometheusMetric>>();
        try {
            this.metricRegistry.forEach(instrumented -> instrumented.toPrometheus(metric -> allMetrics.computeIfAbsent(metric.name, name -> new ArrayList()).add(metric)));
            this.scraper.scrape((ScrapeOutput)new PrometheusScrapeOutput(metric -> allMetrics.computeIfAbsent(metric.name, name -> new ArrayList()).add(metric)), Duration.ofMillis(options.minimumResponseTime));
        }
        catch (Exception e) {
            this.sendErrorResponse(exchange, 500, e.getClass().getSimpleName() + ": " + e.getMessage());
            return;
        }
        this.sendResponse(exchange, allMetrics, options);
    }

    private void sendErrorResponse(HttpServerExchange exchange, int statusCode, String message) throws IOException {
        exchange.setStatusCode(statusCode);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/plain");
        StreamSinkChannel channel = exchange.getResponseChannel();
        channel.write(ByteBuffer.wrap(message.getBytes(StandardCharsets.UTF_8)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpServerExchange exchange, Map<String, List<PrometheusMetric>> allMetrics, Config.OptionsConfig options) throws IOException {
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/plain; version=0.0.4; charset=utf-8");
        ByteBufferPool byteBufferPool = exchange.getConnection().getByteBufferPool().getArrayBackedPool();
        try (PooledByteBuffer byteBuffer = byteBufferPool.allocate();){
            StreamSinkChannel channel = exchange.getResponseChannel();
            PrometheusMetricWriter.WritableByteChannelController controller = channel::awaitWritable;
            try (PrometheusMetricWriter pwriter = new PrometheusMetricWriter(channel, controller, byteBuffer.getBuffer(), options.includeTimestamp);){
                allMetrics.forEach((name, metrics) -> {
                    try {
                        String type;
                        boolean totalOfCounter;
                        String help;
                        if (metrics.isEmpty()) {
                            return;
                        }
                        PrometheusMetric m4 = (PrometheusMetric)metrics.get(0);
                        if (options.includeHelp.booleanValue() && (help = m4.help) != null) {
                            totalOfCounter = "total".equals(m4.suffix) && "counter".equals(m4.type);
                            pwriter.writeHelp((String)name, m4.nameWriter, totalOfCounter ? m4.suffix : null, help);
                        }
                        if (options.includeType.booleanValue() && (type = m4.type) != null) {
                            totalOfCounter = "total".equals(m4.suffix) && "counter".equals(m4.type);
                            pwriter.writeType((String)name, m4.nameWriter, totalOfCounter ? m4.suffix : null, type);
                        }
                        metrics.forEach(metric -> {
                            try {
                                pwriter.write((PrometheusMetric)metric);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        switch (exchange.getRequestPath()) {
            case "/metrics": {
                if (!exchange.getRequestMethod().equalToString("GET")) {
                    exchange.setStatusCode(405);
                    return;
                }
                this.handleGetMetrics(exchange);
                break;
            }
            default: {
                exchange.setStatusCode(404);
            }
        }
    }

    static {
        try {
            DEFAULT_RULE = new Config.ScrapeRule();
            ExporterHttpHandler.DEFAULT_RULE.transform = ScriptEngineRegistry.getInstance().get("java").compileTransformScript(Collections.emptyList(), "V1.transform(in, out, \"type\");", -1);
            ExporterHttpHandler.DEFAULT_RULE.patterns = Collections.emptyList();
        }
        catch (ScriptEngine.ScriptCompileException e) {
            throw new RuntimeException(e);
        }
    }

    private static class PrometheusScrapeOutput
    implements ScrapeOutput {
        private final PrometheusMetricOutput output;

        public PrometheusScrapeOutput(PrometheusMetricOutput output) {
            this.output = output;
        }

        @Override
        public void emit(Sample sample) {
            try {
                sample.rule.transform.execute(sample, this.output);
            }
            catch (Throwable th) {
                LOG.log(Level.WARNING, String.format("Got exception while executing user script for %s:%s (type = %s)", sample.name, sample.attribute.getName(), sample.attribute.getType()), th);
            }
        }
    }
}

