/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.config.watcher;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.jmx.exporter.agent.config.Config;
import net.thisptr.jmx.exporter.agent.config.watcher.ConfigWatcher;
import net.thisptr.jmx.exporter.agent.config.watcher.loaders.ClassPathConfigLoader;
import net.thisptr.jmx.exporter.agent.config.watcher.loaders.FileConfigLoader;
import net.thisptr.jmx.exporter.agent.config.watcher.loaders.StaticConfigLoader;
import net.thisptr.jmx.exporter.agent.metrics.Instrumented;
import net.thisptr.jmx.exporter.agent.scripting.PrometheusMetric;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.core.JsonParser;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import net.thisptr.jmx.exporter.agent.utils.MoreValidators;

public class PollingConfigWatcher
extends Thread
implements ConfigWatcher,
Instrumented {
    private static final Logger LOG = Logger.getLogger(PollingConfigWatcher.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper(new YAMLFactory());
    private final ConfigWatcher.ConfigListener listener;
    private final List<ConfigLoader> loaders = new ArrayList<ConfigLoader>();
    private volatile boolean shutdownRequested = false;
    private volatile Config config;
    private List<byte[]> bytes = Collections.emptyList();
    private volatile boolean lastSuccess = true;
    private final AtomicInteger reloadTotal = new AtomicInteger();

    public PollingConfigWatcher(String args, ConfigWatcher.ConfigListener listener) {
        this.listener = listener;
        this.setName("Scriptable JMX Exporter " + PollingConfigWatcher.class.getSimpleName());
        this.setDaemon(true);
        PollingConfigWatcher.instanciateConfigLoaders(args.getBytes(StandardCharsets.UTF_8), this.loaders::add);
        try {
            this.reload();
            this.lastSuccess = true;
        }
        catch (Exception e) {
            this.lastSuccess = false;
            throw new RuntimeException(e);
        }
    }

    private boolean reload() throws Exception {
        ArrayList<byte[]> newBytes = new ArrayList<byte[]>(this.loaders.size());
        for (int i = 0; i < this.loaders.size(); ++i) {
            try {
                newBytes.add(this.loaders.get(i).bytes());
                continue;
            }
            catch (Throwable th) {
                LOG.log(Level.WARNING, "Failed to load configuration from " + this.loaders.get(i).toString() + ".", th);
                throw th;
            }
        }
        if (PollingConfigWatcher.bytesEquals(this.bytes, newBytes)) {
            return false;
        }
        ArrayList<Config> newConfigs = new ArrayList<Config>(this.loaders.size());
        for (int i = 0; i < newBytes.size(); ++i) {
            try {
                newConfigs.add(YAML_MAPPER.readValue((byte[])newBytes.get(i), Config.class));
                continue;
            }
            catch (Throwable th) {
                LOG.log(Level.WARNING, "Failed to load configuration from " + this.loaders.get(i).toString() + ".", th);
                throw th;
            }
        }
        Config newMergedConfig = Config.merge(newConfigs);
        try {
            MoreValidators.validate(newMergedConfig);
        }
        catch (Throwable th) {
            LOG.log(Level.WARNING, "Failed to load configuration. The configuration is invalid.", th);
            throw th;
        }
        this.config = newMergedConfig;
        this.bytes = newBytes;
        return true;
    }

    static void instanciateConfigLoaders(byte[] buf, Consumer<ConfigLoader> fn) {
        int offset = 0;
        while (offset < buf.length) {
            Object path;
            if (buf[offset] == 64) {
                int start = offset + 1;
                while (offset < buf.length && buf[offset] != 44) {
                    ++offset;
                }
                path = new String(buf, start, offset - start);
                if (((String)path).startsWith("classpath:")) {
                    fn.accept(new ClassPathConfigLoader(((String)path).substring("classpath:".length())));
                } else {
                    fn.accept(new FileConfigLoader(new File((String)path)));
                }
                ++offset;
                continue;
            }
            try {
                JsonParser parser = MAPPER.createParser(buf, offset, buf.length - offset);
                path = null;
                try {
                    int start = offset;
                    MAPPER.readValue(parser, JsonNode.class);
                    fn.accept(new StaticConfigLoader(Arrays.copyOfRange(buf, start, offset += (int)parser.getCurrentLocation().getByteOffset())));
                    ++offset;
                }
                catch (Throwable throwable) {
                    path = throwable;
                    throw throwable;
                }
                finally {
                    if (parser == null) continue;
                    if (path != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)path).addSuppressed(throwable);
                        }
                        continue;
                    }
                    parser.close();
                }
            }
            catch (IOException e) {
                String json = new String(buf, offset, buf.length - offset, StandardCharsets.UTF_8);
                throw new RuntimeException("Unable to parse JSON out of the first part of the input: " + json, e);
            }
        }
    }

    private static boolean bytesEquals(List<byte[]> a, List<byte[]> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (Arrays.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        while (!this.shutdownRequested) {
            boolean changed;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                LOG.log(Level.INFO, "Interrupted. Stopping Scriptable JMX Exporter " + PollingConfigWatcher.class.getSimpleName() + "...");
                break;
            }
            Config oldConfig = this.config;
            try {
                changed = this.reload();
            }
            catch (Throwable th) {
                this.lastSuccess = false;
                continue;
            }
            if (!changed) {
                this.lastSuccess = true;
                continue;
            }
            try {
                this.listener.changed(oldConfig, this.config);
                this.reloadTotal.incrementAndGet();
                this.lastSuccess = true;
            }
            catch (Throwable th) {
                this.lastSuccess = false;
                LOG.log(Level.WARNING, "Got unexpected exception while invoking listeners.", th);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdownRequested = true;
        this.interrupt();
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public void toPrometheus(Consumer<PrometheusMetric> fn) {
        PrometheusMetric m1 = new PrometheusMetric();
        m1.name = "scriptable_jmx_exporter_config_success";
        m1.value = this.lastSuccess ? 1.0 : 0.0;
        m1.type = "gauge";
        m1.help = "1 if the configurations in use and on disk are the same. 0 indicates the configurations on disk could not be reloaded due to some errors.";
        fn.accept(m1);
        PrometheusMetric m22 = new PrometheusMetric();
        m22.name = "scriptable_jmx_exporter_config_reload_success";
        m22.value = this.reloadTotal.get();
        m22.type = "counter";
        m22.suffix = "total";
        m22.help = "The total number of times configurations are reloaded successfully.";
        fn.accept(m22);
    }

    public static interface ConfigLoader {
        public byte[] bytes() throws IOException;

        public String toString();
    }
}

