/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.misc;

import java.time.Duration;

public class Pacemaker {
    public static final Duration DEFAULT_PRECISION = Duration.ofMillis(10L);
    private int i = 0;
    private final int n;
    private final long durationNanos;
    private final long startNanos = System.nanoTime();
    private final long precisionNanos;

    public Pacemaker(Duration duration, int n) {
        this.durationNanos = duration.toNanos();
        this.precisionNanos = DEFAULT_PRECISION.toNanos();
        this.n = n;
    }

    public void yield() throws InterruptedException {
        ++this.i;
        long waitUntilNanos = this.startNanos + (long)((double)this.i / (double)this.n * (double)this.durationNanos);
        long sleepNanos = waitUntilNanos - System.nanoTime();
        if (sleepNanos > this.precisionNanos) {
            Pacemaker.sleepNanos(sleepNanos);
        }
    }

    private static void sleepNanos(long totalNanos) throws InterruptedException {
        int nanos = (int)(totalNanos % 1000000L);
        long millis = totalNanos / 1000000L;
        Thread.sleep(millis, nanos);
    }
}

