/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternAndCaptures {
    private static final Pattern NAMED_CAPTURE_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private final Pattern pattern;
    private final String[] capturesNames;

    private PatternAndCaptures(Pattern pattern, String[] captureNames) {
        this.pattern = pattern;
        this.capturesNames = captureNames;
    }

    public static PatternAndCaptures compile(String regex) {
        Pattern pattern = Pattern.compile(regex);
        ArrayList<String> captures = new ArrayList<String>();
        Matcher m4 = NAMED_CAPTURE_PATTERN.matcher(regex);
        while (m4.find()) {
            captures.add(m4.group(1));
        }
        return new PatternAndCaptures(pattern, captures.toArray(new String[0]));
    }

    public boolean matches(CharSequence sequence) {
        return this.matches(sequence, null);
    }

    public boolean matches(CharSequence sequence, Map<String, String> captures) {
        Matcher m4 = this.pattern.matcher(sequence);
        if (m4.matches()) {
            if (captures != null) {
                for (String captureName : this.capturesNames) {
                    String captureValue = m4.group(captureName);
                    if (captureValue == null) continue;
                    captures.put(captureName, captureValue);
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.capturesNames);
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternAndCaptures other = (PatternAndCaptures)obj;
        if (!Arrays.equals(this.capturesNames, other.capturesNames)) {
            return false;
        }
        return !(this.pattern == null ? other.pattern != null : !this.pattern.toString().equals(other.pattern.toString()));
    }
}

