/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.scripting.janino.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.thisptr.jmx.exporter.agent.misc.MutableInteger;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.collect.Maps;

public class Labels {
    private final Map<String, MutableInteger> counts;
    private final List<String> labels;
    private final List<String> values;
    private final List<Integer> dups;

    public Labels(int expectedSize) {
        this.labels = new ArrayList<String>(expectedSize);
        this.values = new ArrayList<String>(expectedSize);
        this.dups = new ArrayList<Integer>(expectedSize);
        this.counts = Maps.newHashMapWithExpectedSize(expectedSize);
    }

    public void push(String label, String value) {
        int dup = this.counts.computeIfAbsent(label, dummy -> new MutableInteger()).getAndIncrement();
        if (dup == 0) {
            this.labels.add(label);
        } else {
            this.labels.add(label + "_" + dup);
        }
        this.values.add(value);
        this.dups.add(dup);
    }

    public void pop(String label) {
        if (this.counts.get(label).decrementAndGet() <= 0) {
            this.counts.remove(label);
        }
        int index = this.labels.size() - 1;
        this.labels.remove(index);
        this.values.remove(index);
    }

    public void forEach(BiConsumer<String, String> fn) {
        for (int i = 0; i < this.labels.size(); ++i) {
            fn.accept(this.labels.get(i), this.values.get(i));
        }
    }

    public Map<String, String> toMapIfNotEmpty() {
        int size = this.labels.size();
        if (size == 0) {
            return null;
        }
        HashMap<String, String> map = Maps.newHashMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            map.put(this.labels.get(i), this.values.get(i));
        }
        return map;
    }

    public int size() {
        return this.labels.size();
    }

    public void clear() {
        this.labels.clear();
        this.values.clear();
        this.dups.clear();
        this.counts.clear();
    }
}

