/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.NetworkUtils;

public class RemoteObfuscatedIPAttribute
implements ExchangeAttribute {
    public static final String REMOTE_OBFUSCATED_IP_SHORT = "%o";
    public static final String REMOTE_OBFUSCATED_IP = "%{REMOTE_OBFUSCATED_IP}";
    public static final ExchangeAttribute INSTANCE = new RemoteObfuscatedIPAttribute();

    private RemoteObfuscatedIPAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        InetSocketAddress sourceAddress = exchange.getSourceAddress();
        InetAddress address = sourceAddress.getAddress();
        if (address == null) {
            address = ((InetSocketAddress)exchange.getConnection().getPeerAddress()).getAddress();
        }
        if (address == null) {
            return null;
        }
        return NetworkUtils.toObfuscatedString(address);
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Remote Obfuscated IP", newValue);
    }

    public String toString() {
        return REMOTE_OBFUSCATED_IP;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Remote Obfuscated IP";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RemoteObfuscatedIPAttribute.REMOTE_OBFUSCATED_IP) || token.equals(RemoteObfuscatedIPAttribute.REMOTE_OBFUSCATED_IP_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

