/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AttachmentKey;

public class ResponseTimeAttribute
implements ExchangeAttribute {
    private static final AttachmentKey<Long> FIRST_RESPONSE_TIME_NANOS = AttachmentKey.create(Long.class);
    public static final String RESPONSE_TIME_MILLIS_SHORT = "%D";
    public static final String RESPONSE_TIME_SECONDS_SHORT = "%T";
    public static final String RESPONSE_TIME_MILLIS = "%{RESPONSE_TIME}";
    public static final String RESPONSE_TIME_MICROS = "%{RESPONSE_TIME_MICROS}";
    public static final String RESPONSE_TIME_NANOS = "%{RESPONSE_TIME_NANOS}";
    private final TimeUnit timeUnit;

    public ResponseTimeAttribute(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        long nanos;
        long requestStartTime = exchange.getRequestStartTime();
        if (requestStartTime == -1L) {
            return null;
        }
        Long first = exchange.getAttachment(FIRST_RESPONSE_TIME_NANOS);
        if (first != null) {
            nanos = first;
        } else {
            nanos = System.nanoTime() - requestStartTime;
            if (exchange.isResponseComplete()) {
                exchange.putAttachment(FIRST_RESPONSE_TIME_NANOS, nanos);
            }
        }
        if (this.timeUnit == TimeUnit.SECONDS) {
            StringBuilder buf = new StringBuilder();
            long milis = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
            buf.append(Long.toString(milis / 1000L));
            buf.append('.');
            int remains = (int)(milis % 1000L);
            buf.append(Long.toString(remains / 100));
            buf.append(Long.toString((remains %= 100) / 10));
            buf.append(Long.toString(remains % 10));
            return buf.toString();
        }
        return String.valueOf(this.timeUnit.convert(nanos, TimeUnit.NANOSECONDS));
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Response Time", newValue);
    }

    public String toString() {
        if (this.timeUnit.equals((Object)TimeUnit.MILLISECONDS)) {
            return RESPONSE_TIME_MILLIS;
        }
        if (this.timeUnit.equals((Object)TimeUnit.SECONDS)) {
            return RESPONSE_TIME_SECONDS_SHORT;
        }
        if (this.timeUnit.equals((Object)TimeUnit.MICROSECONDS)) {
            return RESPONSE_TIME_MICROS;
        }
        if (this.timeUnit.equals((Object)TimeUnit.NANOSECONDS)) {
            return RESPONSE_TIME_NANOS;
        }
        return "ResponseTimeAttribute";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response Time";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ResponseTimeAttribute.RESPONSE_TIME_MILLIS) || token.equals(ResponseTimeAttribute.RESPONSE_TIME_MILLIS_SHORT)) {
                return new ResponseTimeAttribute(TimeUnit.MILLISECONDS);
            }
            if (token.equals(ResponseTimeAttribute.RESPONSE_TIME_SECONDS_SHORT)) {
                return new ResponseTimeAttribute(TimeUnit.SECONDS);
            }
            if (token.equals(ResponseTimeAttribute.RESPONSE_TIME_MICROS)) {
                return new ResponseTimeAttribute(TimeUnit.MICROSECONDS);
            }
            if (token.equals(ResponseTimeAttribute.RESPONSE_TIME_NANOS)) {
                return new ResponseTimeAttribute(TimeUnit.NANOSECONDS);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

