/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class SecureExchangeAttribute
implements ExchangeAttribute {
    public static final String TOKEN = "%{SECURE}";
    public static final String LEGACY_INCORRECT_TOKEN = "${SECURE}";
    public static final ExchangeAttribute INSTANCE = new SecureExchangeAttribute();

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return Boolean.toString(exchange.isSecure());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.putAttachment(HttpServerExchange.SECURE_REQUEST, Boolean.parseBoolean(newValue));
    }

    public String toString() {
        return TOKEN;
    }

    public static class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Secure";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(SecureExchangeAttribute.TOKEN) || token.equals(SecureExchangeAttribute.LEGACY_INCORRECT_TOKEN)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

